/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.rover.model.EnclosureType;
import com.oracle.bmc.rover.model.LifecycleState;
import com.oracle.bmc.rover.model.RoverNodeSummary;
import com.oracle.bmc.rover.model.RoverWorkload;
import com.oracle.bmc.rover.model.ShippingAddress;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoverCluster {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="clusterSize")
    private final Integer clusterSize;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="nodes")
    private final List<RoverNodeSummary> nodes;
    @JsonProperty(value="enclosureType")
    private final EnclosureType enclosureType;
    @JsonProperty(value="timeCustomerReceived")
    private final Date timeCustomerReceived;
    @JsonProperty(value="timeCustomerReturned")
    private final Date timeCustomerReturned;
    @JsonProperty(value="deliveryTrackingInfo")
    private final String deliveryTrackingInfo;
    @JsonProperty(value="clusterWorkloads")
    private final List<RoverWorkload> clusterWorkloads;
    @JsonProperty(value="superUserPassword")
    private final String superUserPassword;
    @JsonProperty(value="unlockPassphrase")
    private final String unlockPassphrase;
    @JsonProperty(value="pointOfContact")
    private final String pointOfContact;
    @JsonProperty(value="pointOfContactPhoneNumber")
    private final String pointOfContactPhoneNumber;
    @JsonProperty(value="shippingPreference")
    private final ShippingPreference shippingPreference;
    @JsonProperty(value="oracleShippingTrackingUrl")
    private final String oracleShippingTrackingUrl;
    @JsonProperty(value="shippingVendor")
    private final String shippingVendor;
    @JsonProperty(value="timePickupExpected")
    private final Date timePickupExpected;
    @JsonProperty(value="timeReturnWindowStarts")
    private final Date timeReturnWindowStarts;
    @JsonProperty(value="timeReturnWindowEnds")
    private final Date timeReturnWindowEnds;
    @JsonProperty(value="returnShippingLabelUri")
    private final String returnShippingLabelUri;
    @JsonProperty(value="imageExportPar")
    private final String imageExportPar;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).displayName(this.displayName).clusterSize(this.clusterSize).timeCreated(this.timeCreated).lifecycleState(this.lifecycleState).lifecycleStateDetails(this.lifecycleStateDetails).customerShippingAddress(this.customerShippingAddress).nodes(this.nodes).enclosureType(this.enclosureType).timeCustomerReceived(this.timeCustomerReceived).timeCustomerReturned(this.timeCustomerReturned).deliveryTrackingInfo(this.deliveryTrackingInfo).clusterWorkloads(this.clusterWorkloads).superUserPassword(this.superUserPassword).unlockPassphrase(this.unlockPassphrase).pointOfContact(this.pointOfContact).pointOfContactPhoneNumber(this.pointOfContactPhoneNumber).shippingPreference(this.shippingPreference).oracleShippingTrackingUrl(this.oracleShippingTrackingUrl).shippingVendor(this.shippingVendor).timePickupExpected(this.timePickupExpected).timeReturnWindowStarts(this.timeReturnWindowStarts).timeReturnWindowEnds(this.timeReturnWindowEnds).returnShippingLabelUri(this.returnShippingLabelUri).imageExportPar(this.imageExportPar).freeformTags(this.freeformTags).definedTags(this.definedTags).systemTags(this.systemTags);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getClusterSize() {
        return this.clusterSize;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public List<RoverNodeSummary> getNodes() {
        return this.nodes;
    }

    public EnclosureType getEnclosureType() {
        return this.enclosureType;
    }

    public Date getTimeCustomerReceived() {
        return this.timeCustomerReceived;
    }

    public Date getTimeCustomerReturned() {
        return this.timeCustomerReturned;
    }

    public String getDeliveryTrackingInfo() {
        return this.deliveryTrackingInfo;
    }

    public List<RoverWorkload> getClusterWorkloads() {
        return this.clusterWorkloads;
    }

    public String getSuperUserPassword() {
        return this.superUserPassword;
    }

    public String getUnlockPassphrase() {
        return this.unlockPassphrase;
    }

    public String getPointOfContact() {
        return this.pointOfContact;
    }

    public String getPointOfContactPhoneNumber() {
        return this.pointOfContactPhoneNumber;
    }

    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    public String getOracleShippingTrackingUrl() {
        return this.oracleShippingTrackingUrl;
    }

    public String getShippingVendor() {
        return this.shippingVendor;
    }

    public Date getTimePickupExpected() {
        return this.timePickupExpected;
    }

    public Date getTimeReturnWindowStarts() {
        return this.timeReturnWindowStarts;
    }

    public Date getTimeReturnWindowEnds() {
        return this.timeReturnWindowEnds;
    }

    public String getReturnShippingLabelUri() {
        return this.returnShippingLabelUri;
    }

    public String getImageExportPar() {
        return this.imageExportPar;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoverCluster)) {
            return false;
        }
        RoverCluster other = (RoverCluster)o;
        Integer this$clusterSize = this.getClusterSize();
        Integer other$clusterSize = other.getClusterSize();
        if (this$clusterSize == null ? other$clusterSize != null : !((Object)this$clusterSize).equals(other$clusterSize)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$lifecycleStateDetails = this.getLifecycleStateDetails();
        String other$lifecycleStateDetails = other.getLifecycleStateDetails();
        if (this$lifecycleStateDetails == null ? other$lifecycleStateDetails != null : !this$lifecycleStateDetails.equals(other$lifecycleStateDetails)) {
            return false;
        }
        ShippingAddress this$customerShippingAddress = this.getCustomerShippingAddress();
        ShippingAddress other$customerShippingAddress = other.getCustomerShippingAddress();
        if (this$customerShippingAddress == null ? other$customerShippingAddress != null : !((Object)this$customerShippingAddress).equals(other$customerShippingAddress)) {
            return false;
        }
        List<RoverNodeSummary> this$nodes = this.getNodes();
        List<RoverNodeSummary> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        EnclosureType this$enclosureType = this.getEnclosureType();
        EnclosureType other$enclosureType = other.getEnclosureType();
        if (this$enclosureType == null ? other$enclosureType != null : !((Object)((Object)this$enclosureType)).equals((Object)other$enclosureType)) {
            return false;
        }
        Date this$timeCustomerReceived = this.getTimeCustomerReceived();
        Date other$timeCustomerReceived = other.getTimeCustomerReceived();
        if (this$timeCustomerReceived == null ? other$timeCustomerReceived != null : !((Object)this$timeCustomerReceived).equals(other$timeCustomerReceived)) {
            return false;
        }
        Date this$timeCustomerReturned = this.getTimeCustomerReturned();
        Date other$timeCustomerReturned = other.getTimeCustomerReturned();
        if (this$timeCustomerReturned == null ? other$timeCustomerReturned != null : !((Object)this$timeCustomerReturned).equals(other$timeCustomerReturned)) {
            return false;
        }
        String this$deliveryTrackingInfo = this.getDeliveryTrackingInfo();
        String other$deliveryTrackingInfo = other.getDeliveryTrackingInfo();
        if (this$deliveryTrackingInfo == null ? other$deliveryTrackingInfo != null : !this$deliveryTrackingInfo.equals(other$deliveryTrackingInfo)) {
            return false;
        }
        List<RoverWorkload> this$clusterWorkloads = this.getClusterWorkloads();
        List<RoverWorkload> other$clusterWorkloads = other.getClusterWorkloads();
        if (this$clusterWorkloads == null ? other$clusterWorkloads != null : !((Object)this$clusterWorkloads).equals(other$clusterWorkloads)) {
            return false;
        }
        String this$superUserPassword = this.getSuperUserPassword();
        String other$superUserPassword = other.getSuperUserPassword();
        if (this$superUserPassword == null ? other$superUserPassword != null : !this$superUserPassword.equals(other$superUserPassword)) {
            return false;
        }
        String this$unlockPassphrase = this.getUnlockPassphrase();
        String other$unlockPassphrase = other.getUnlockPassphrase();
        if (this$unlockPassphrase == null ? other$unlockPassphrase != null : !this$unlockPassphrase.equals(other$unlockPassphrase)) {
            return false;
        }
        String this$pointOfContact = this.getPointOfContact();
        String other$pointOfContact = other.getPointOfContact();
        if (this$pointOfContact == null ? other$pointOfContact != null : !this$pointOfContact.equals(other$pointOfContact)) {
            return false;
        }
        String this$pointOfContactPhoneNumber = this.getPointOfContactPhoneNumber();
        String other$pointOfContactPhoneNumber = other.getPointOfContactPhoneNumber();
        if (this$pointOfContactPhoneNumber == null ? other$pointOfContactPhoneNumber != null : !this$pointOfContactPhoneNumber.equals(other$pointOfContactPhoneNumber)) {
            return false;
        }
        ShippingPreference this$shippingPreference = this.getShippingPreference();
        ShippingPreference other$shippingPreference = other.getShippingPreference();
        if (this$shippingPreference == null ? other$shippingPreference != null : !((Object)((Object)this$shippingPreference)).equals((Object)other$shippingPreference)) {
            return false;
        }
        String this$oracleShippingTrackingUrl = this.getOracleShippingTrackingUrl();
        String other$oracleShippingTrackingUrl = other.getOracleShippingTrackingUrl();
        if (this$oracleShippingTrackingUrl == null ? other$oracleShippingTrackingUrl != null : !this$oracleShippingTrackingUrl.equals(other$oracleShippingTrackingUrl)) {
            return false;
        }
        String this$shippingVendor = this.getShippingVendor();
        String other$shippingVendor = other.getShippingVendor();
        if (this$shippingVendor == null ? other$shippingVendor != null : !this$shippingVendor.equals(other$shippingVendor)) {
            return false;
        }
        Date this$timePickupExpected = this.getTimePickupExpected();
        Date other$timePickupExpected = other.getTimePickupExpected();
        if (this$timePickupExpected == null ? other$timePickupExpected != null : !((Object)this$timePickupExpected).equals(other$timePickupExpected)) {
            return false;
        }
        Date this$timeReturnWindowStarts = this.getTimeReturnWindowStarts();
        Date other$timeReturnWindowStarts = other.getTimeReturnWindowStarts();
        if (this$timeReturnWindowStarts == null ? other$timeReturnWindowStarts != null : !((Object)this$timeReturnWindowStarts).equals(other$timeReturnWindowStarts)) {
            return false;
        }
        Date this$timeReturnWindowEnds = this.getTimeReturnWindowEnds();
        Date other$timeReturnWindowEnds = other.getTimeReturnWindowEnds();
        if (this$timeReturnWindowEnds == null ? other$timeReturnWindowEnds != null : !((Object)this$timeReturnWindowEnds).equals(other$timeReturnWindowEnds)) {
            return false;
        }
        String this$returnShippingLabelUri = this.getReturnShippingLabelUri();
        String other$returnShippingLabelUri = other.getReturnShippingLabelUri();
        if (this$returnShippingLabelUri == null ? other$returnShippingLabelUri != null : !this$returnShippingLabelUri.equals(other$returnShippingLabelUri)) {
            return false;
        }
        String this$imageExportPar = this.getImageExportPar();
        String other$imageExportPar = other.getImageExportPar();
        if (this$imageExportPar == null ? other$imageExportPar != null : !this$imageExportPar.equals(other$imageExportPar)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$systemTags = this.getSystemTags();
        Map<String, Map<String, Object>> other$systemTags = other.getSystemTags();
        if (this$systemTags == null ? other$systemTags != null : !((Object)this$systemTags).equals(other$systemTags)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $clusterSize = this.getClusterSize();
        result = result * 59 + ($clusterSize == null ? 43 : ((Object)$clusterSize).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $lifecycleStateDetails = this.getLifecycleStateDetails();
        result = result * 59 + ($lifecycleStateDetails == null ? 43 : $lifecycleStateDetails.hashCode());
        ShippingAddress $customerShippingAddress = this.getCustomerShippingAddress();
        result = result * 59 + ($customerShippingAddress == null ? 43 : ((Object)$customerShippingAddress).hashCode());
        List<RoverNodeSummary> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        EnclosureType $enclosureType = this.getEnclosureType();
        result = result * 59 + ($enclosureType == null ? 43 : ((Object)((Object)$enclosureType)).hashCode());
        Date $timeCustomerReceived = this.getTimeCustomerReceived();
        result = result * 59 + ($timeCustomerReceived == null ? 43 : ((Object)$timeCustomerReceived).hashCode());
        Date $timeCustomerReturned = this.getTimeCustomerReturned();
        result = result * 59 + ($timeCustomerReturned == null ? 43 : ((Object)$timeCustomerReturned).hashCode());
        String $deliveryTrackingInfo = this.getDeliveryTrackingInfo();
        result = result * 59 + ($deliveryTrackingInfo == null ? 43 : $deliveryTrackingInfo.hashCode());
        List<RoverWorkload> $clusterWorkloads = this.getClusterWorkloads();
        result = result * 59 + ($clusterWorkloads == null ? 43 : ((Object)$clusterWorkloads).hashCode());
        String $superUserPassword = this.getSuperUserPassword();
        result = result * 59 + ($superUserPassword == null ? 43 : $superUserPassword.hashCode());
        String $unlockPassphrase = this.getUnlockPassphrase();
        result = result * 59 + ($unlockPassphrase == null ? 43 : $unlockPassphrase.hashCode());
        String $pointOfContact = this.getPointOfContact();
        result = result * 59 + ($pointOfContact == null ? 43 : $pointOfContact.hashCode());
        String $pointOfContactPhoneNumber = this.getPointOfContactPhoneNumber();
        result = result * 59 + ($pointOfContactPhoneNumber == null ? 43 : $pointOfContactPhoneNumber.hashCode());
        ShippingPreference $shippingPreference = this.getShippingPreference();
        result = result * 59 + ($shippingPreference == null ? 43 : ((Object)((Object)$shippingPreference)).hashCode());
        String $oracleShippingTrackingUrl = this.getOracleShippingTrackingUrl();
        result = result * 59 + ($oracleShippingTrackingUrl == null ? 43 : $oracleShippingTrackingUrl.hashCode());
        String $shippingVendor = this.getShippingVendor();
        result = result * 59 + ($shippingVendor == null ? 43 : $shippingVendor.hashCode());
        Date $timePickupExpected = this.getTimePickupExpected();
        result = result * 59 + ($timePickupExpected == null ? 43 : ((Object)$timePickupExpected).hashCode());
        Date $timeReturnWindowStarts = this.getTimeReturnWindowStarts();
        result = result * 59 + ($timeReturnWindowStarts == null ? 43 : ((Object)$timeReturnWindowStarts).hashCode());
        Date $timeReturnWindowEnds = this.getTimeReturnWindowEnds();
        result = result * 59 + ($timeReturnWindowEnds == null ? 43 : ((Object)$timeReturnWindowEnds).hashCode());
        String $returnShippingLabelUri = this.getReturnShippingLabelUri();
        result = result * 59 + ($returnShippingLabelUri == null ? 43 : $returnShippingLabelUri.hashCode());
        String $imageExportPar = this.getImageExportPar();
        result = result * 59 + ($imageExportPar == null ? 43 : $imageExportPar.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        Map<String, Map<String, Object>> $systemTags = this.getSystemTags();
        result = result * 59 + ($systemTags == null ? 43 : ((Object)$systemTags).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "RoverCluster(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", displayName=" + this.getDisplayName() + ", clusterSize=" + this.getClusterSize() + ", timeCreated=" + this.getTimeCreated() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", lifecycleStateDetails=" + this.getLifecycleStateDetails() + ", customerShippingAddress=" + this.getCustomerShippingAddress() + ", nodes=" + this.getNodes() + ", enclosureType=" + (Object)((Object)this.getEnclosureType()) + ", timeCustomerReceived=" + this.getTimeCustomerReceived() + ", timeCustomerReturned=" + this.getTimeCustomerReturned() + ", deliveryTrackingInfo=" + this.getDeliveryTrackingInfo() + ", clusterWorkloads=" + this.getClusterWorkloads() + ", superUserPassword=" + this.getSuperUserPassword() + ", unlockPassphrase=" + this.getUnlockPassphrase() + ", pointOfContact=" + this.getPointOfContact() + ", pointOfContactPhoneNumber=" + this.getPointOfContactPhoneNumber() + ", shippingPreference=" + (Object)((Object)this.getShippingPreference()) + ", oracleShippingTrackingUrl=" + this.getOracleShippingTrackingUrl() + ", shippingVendor=" + this.getShippingVendor() + ", timePickupExpected=" + this.getTimePickupExpected() + ", timeReturnWindowStarts=" + this.getTimeReturnWindowStarts() + ", timeReturnWindowEnds=" + this.getTimeReturnWindowEnds() + ", returnShippingLabelUri=" + this.getReturnShippingLabelUri() + ", imageExportPar=" + this.getImageExportPar() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", systemTags=" + this.getSystemTags() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "displayName", "clusterSize", "timeCreated", "lifecycleState", "lifecycleStateDetails", "customerShippingAddress", "nodes", "enclosureType", "timeCustomerReceived", "timeCustomerReturned", "deliveryTrackingInfo", "clusterWorkloads", "superUserPassword", "unlockPassphrase", "pointOfContact", "pointOfContactPhoneNumber", "shippingPreference", "oracleShippingTrackingUrl", "shippingVendor", "timePickupExpected", "timeReturnWindowStarts", "timeReturnWindowEnds", "returnShippingLabelUri", "imageExportPar", "freeformTags", "definedTags", "systemTags"})
    @Deprecated
    public RoverCluster(String id, String compartmentId, String displayName, Integer clusterSize, Date timeCreated, LifecycleState lifecycleState, String lifecycleStateDetails, ShippingAddress customerShippingAddress, List<RoverNodeSummary> nodes, EnclosureType enclosureType, Date timeCustomerReceived, Date timeCustomerReturned, String deliveryTrackingInfo, List<RoverWorkload> clusterWorkloads, String superUserPassword, String unlockPassphrase, String pointOfContact, String pointOfContactPhoneNumber, ShippingPreference shippingPreference, String oracleShippingTrackingUrl, String shippingVendor, Date timePickupExpected, Date timeReturnWindowStarts, Date timeReturnWindowEnds, String returnShippingLabelUri, String imageExportPar, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.clusterSize = clusterSize;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.customerShippingAddress = customerShippingAddress;
        this.nodes = nodes;
        this.enclosureType = enclosureType;
        this.timeCustomerReceived = timeCustomerReceived;
        this.timeCustomerReturned = timeCustomerReturned;
        this.deliveryTrackingInfo = deliveryTrackingInfo;
        this.clusterWorkloads = clusterWorkloads;
        this.superUserPassword = superUserPassword;
        this.unlockPassphrase = unlockPassphrase;
        this.pointOfContact = pointOfContact;
        this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
        this.shippingPreference = shippingPreference;
        this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
        this.shippingVendor = shippingVendor;
        this.timePickupExpected = timePickupExpected;
        this.timeReturnWindowStarts = timeReturnWindowStarts;
        this.timeReturnWindowEnds = timeReturnWindowEnds;
        this.returnShippingLabelUri = returnShippingLabelUri;
        this.imageExportPar = imageExportPar;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static enum ShippingPreference {
        OracleShipped("ORACLE_SHIPPED"),
        CustomerPickup("CUSTOMER_PICKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShippingPreference> map;

        private ShippingPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShippingPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShippingPreference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShippingPreference.class);
            map = new HashMap<String, ShippingPreference>();
            for (ShippingPreference v : ShippingPreference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="clusterSize")
        private Integer clusterSize;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="nodes")
        private List<RoverNodeSummary> nodes;
        @JsonProperty(value="enclosureType")
        private EnclosureType enclosureType;
        @JsonProperty(value="timeCustomerReceived")
        private Date timeCustomerReceived;
        @JsonProperty(value="timeCustomerReturned")
        private Date timeCustomerReturned;
        @JsonProperty(value="deliveryTrackingInfo")
        private String deliveryTrackingInfo;
        @JsonProperty(value="clusterWorkloads")
        private List<RoverWorkload> clusterWorkloads;
        @JsonProperty(value="superUserPassword")
        private String superUserPassword;
        @JsonProperty(value="unlockPassphrase")
        private String unlockPassphrase;
        @JsonProperty(value="pointOfContact")
        private String pointOfContact;
        @JsonProperty(value="pointOfContactPhoneNumber")
        private String pointOfContactPhoneNumber;
        @JsonProperty(value="shippingPreference")
        private ShippingPreference shippingPreference;
        @JsonProperty(value="oracleShippingTrackingUrl")
        private String oracleShippingTrackingUrl;
        @JsonProperty(value="shippingVendor")
        private String shippingVendor;
        @JsonProperty(value="timePickupExpected")
        private Date timePickupExpected;
        @JsonProperty(value="timeReturnWindowStarts")
        private Date timeReturnWindowStarts;
        @JsonProperty(value="timeReturnWindowEnds")
        private Date timeReturnWindowEnds;
        @JsonProperty(value="returnShippingLabelUri")
        private String returnShippingLabelUri;
        @JsonProperty(value="imageExportPar")
        private String imageExportPar;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder clusterSize(Integer clusterSize) {
            this.clusterSize = clusterSize;
            this.__explicitlySet__.add("clusterSize");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder nodes(List<RoverNodeSummary> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder enclosureType(EnclosureType enclosureType) {
            this.enclosureType = enclosureType;
            this.__explicitlySet__.add("enclosureType");
            return this;
        }

        public Builder timeCustomerReceived(Date timeCustomerReceived) {
            this.timeCustomerReceived = timeCustomerReceived;
            this.__explicitlySet__.add("timeCustomerReceived");
            return this;
        }

        public Builder timeCustomerReturned(Date timeCustomerReturned) {
            this.timeCustomerReturned = timeCustomerReturned;
            this.__explicitlySet__.add("timeCustomerReturned");
            return this;
        }

        public Builder deliveryTrackingInfo(String deliveryTrackingInfo) {
            this.deliveryTrackingInfo = deliveryTrackingInfo;
            this.__explicitlySet__.add("deliveryTrackingInfo");
            return this;
        }

        public Builder clusterWorkloads(List<RoverWorkload> clusterWorkloads) {
            this.clusterWorkloads = clusterWorkloads;
            this.__explicitlySet__.add("clusterWorkloads");
            return this;
        }

        public Builder superUserPassword(String superUserPassword) {
            this.superUserPassword = superUserPassword;
            this.__explicitlySet__.add("superUserPassword");
            return this;
        }

        public Builder unlockPassphrase(String unlockPassphrase) {
            this.unlockPassphrase = unlockPassphrase;
            this.__explicitlySet__.add("unlockPassphrase");
            return this;
        }

        public Builder pointOfContact(String pointOfContact) {
            this.pointOfContact = pointOfContact;
            this.__explicitlySet__.add("pointOfContact");
            return this;
        }

        public Builder pointOfContactPhoneNumber(String pointOfContactPhoneNumber) {
            this.pointOfContactPhoneNumber = pointOfContactPhoneNumber;
            this.__explicitlySet__.add("pointOfContactPhoneNumber");
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            this.__explicitlySet__.add("shippingPreference");
            return this;
        }

        public Builder oracleShippingTrackingUrl(String oracleShippingTrackingUrl) {
            this.oracleShippingTrackingUrl = oracleShippingTrackingUrl;
            this.__explicitlySet__.add("oracleShippingTrackingUrl");
            return this;
        }

        public Builder shippingVendor(String shippingVendor) {
            this.shippingVendor = shippingVendor;
            this.__explicitlySet__.add("shippingVendor");
            return this;
        }

        public Builder timePickupExpected(Date timePickupExpected) {
            this.timePickupExpected = timePickupExpected;
            this.__explicitlySet__.add("timePickupExpected");
            return this;
        }

        public Builder timeReturnWindowStarts(Date timeReturnWindowStarts) {
            this.timeReturnWindowStarts = timeReturnWindowStarts;
            this.__explicitlySet__.add("timeReturnWindowStarts");
            return this;
        }

        public Builder timeReturnWindowEnds(Date timeReturnWindowEnds) {
            this.timeReturnWindowEnds = timeReturnWindowEnds;
            this.__explicitlySet__.add("timeReturnWindowEnds");
            return this;
        }

        public Builder returnShippingLabelUri(String returnShippingLabelUri) {
            this.returnShippingLabelUri = returnShippingLabelUri;
            this.__explicitlySet__.add("returnShippingLabelUri");
            return this;
        }

        public Builder imageExportPar(String imageExportPar) {
            this.imageExportPar = imageExportPar;
            this.__explicitlySet__.add("imageExportPar");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public RoverCluster build() {
            RoverCluster __instance__ = new RoverCluster(this.id, this.compartmentId, this.displayName, this.clusterSize, this.timeCreated, this.lifecycleState, this.lifecycleStateDetails, this.customerShippingAddress, this.nodes, this.enclosureType, this.timeCustomerReceived, this.timeCustomerReturned, this.deliveryTrackingInfo, this.clusterWorkloads, this.superUserPassword, this.unlockPassphrase, this.pointOfContact, this.pointOfContactPhoneNumber, this.shippingPreference, this.oracleShippingTrackingUrl, this.shippingVendor, this.timePickupExpected, this.timeReturnWindowStarts, this.timeReturnWindowEnds, this.returnShippingLabelUri, this.imageExportPar, this.freeformTags, this.definedTags, this.systemTags);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(RoverCluster o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).displayName(o.getDisplayName()).clusterSize(o.getClusterSize()).timeCreated(o.getTimeCreated()).lifecycleState(o.getLifecycleState()).lifecycleStateDetails(o.getLifecycleStateDetails()).customerShippingAddress(o.getCustomerShippingAddress()).nodes(o.getNodes()).enclosureType(o.getEnclosureType()).timeCustomerReceived(o.getTimeCustomerReceived()).timeCustomerReturned(o.getTimeCustomerReturned()).deliveryTrackingInfo(o.getDeliveryTrackingInfo()).clusterWorkloads(o.getClusterWorkloads()).superUserPassword(o.getSuperUserPassword()).unlockPassphrase(o.getUnlockPassphrase()).pointOfContact(o.getPointOfContact()).pointOfContactPhoneNumber(o.getPointOfContactPhoneNumber()).shippingPreference(o.getShippingPreference()).oracleShippingTrackingUrl(o.getOracleShippingTrackingUrl()).shippingVendor(o.getShippingVendor()).timePickupExpected(o.getTimePickupExpected()).timeReturnWindowStarts(o.getTimeReturnWindowStarts()).timeReturnWindowEnds(o.getTimeReturnWindowEnds()).returnShippingLabelUri(o.getReturnShippingLabelUri()).imageExportPar(o.getImageExportPar()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).systemTags(o.getSystemTags());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "RoverCluster.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", displayName=" + this.displayName + ", clusterSize=" + this.clusterSize + ", timeCreated=" + this.timeCreated + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", lifecycleStateDetails=" + this.lifecycleStateDetails + ", customerShippingAddress=" + this.customerShippingAddress + ", nodes=" + this.nodes + ", enclosureType=" + (Object)((Object)this.enclosureType) + ", timeCustomerReceived=" + this.timeCustomerReceived + ", timeCustomerReturned=" + this.timeCustomerReturned + ", deliveryTrackingInfo=" + this.deliveryTrackingInfo + ", clusterWorkloads=" + this.clusterWorkloads + ", superUserPassword=" + this.superUserPassword + ", unlockPassphrase=" + this.unlockPassphrase + ", pointOfContact=" + this.pointOfContact + ", pointOfContactPhoneNumber=" + this.pointOfContactPhoneNumber + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", oracleShippingTrackingUrl=" + this.oracleShippingTrackingUrl + ", shippingVendor=" + this.shippingVendor + ", timePickupExpected=" + this.timePickupExpected + ", timeReturnWindowStarts=" + this.timeReturnWindowStarts + ", timeReturnWindowEnds=" + this.timeReturnWindowEnds + ", returnShippingLabelUri=" + this.returnShippingLabelUri + ", imageExportPar=" + this.imageExportPar + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", systemTags=" + this.systemTags + ")";
        }
    }
}

