/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.secrets.Secrets;
import com.oracle.bmc.secrets.model.SecretBundleVersionSummary;
import com.oracle.bmc.secrets.requests.ListSecretBundleVersionsRequest;
import com.oracle.bmc.secrets.responses.ListSecretBundleVersionsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class SecretsPaginators {
    private final Secrets client;

    public Iterable<ListSecretBundleVersionsResponse> listSecretBundleVersionsResponseIterator(final ListSecretBundleVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecretBundleVersionsRequest.Builder>(){

            public ListSecretBundleVersionsRequest.Builder get() {
                return ListSecretBundleVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretBundleVersionsResponse, String>(){

            public String apply(ListSecretBundleVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder>, ListSecretBundleVersionsRequest>(){

            public ListSecretBundleVersionsRequest apply(RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSecretBundleVersionsRequest, ListSecretBundleVersionsResponse>(){

            public ListSecretBundleVersionsResponse apply(ListSecretBundleVersionsRequest request) {
                return SecretsPaginators.this.client.listSecretBundleVersions(request);
            }
        });
    }

    public Iterable<SecretBundleVersionSummary> listSecretBundleVersionsRecordIterator(final ListSecretBundleVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecretBundleVersionsRequest.Builder>(){

            public ListSecretBundleVersionsRequest.Builder get() {
                return ListSecretBundleVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretBundleVersionsResponse, String>(){

            public String apply(ListSecretBundleVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder>, ListSecretBundleVersionsRequest>(){

            public ListSecretBundleVersionsRequest apply(RequestBuilderAndToken<ListSecretBundleVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretBundleVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSecretBundleVersionsRequest, ListSecretBundleVersionsResponse>(){

            public ListSecretBundleVersionsResponse apply(ListSecretBundleVersionsRequest request) {
                return SecretsPaginators.this.client.listSecretBundleVersions(request);
            }
        }, (Function)new Function<ListSecretBundleVersionsResponse, List<SecretBundleVersionSummary>>(){

            public List<SecretBundleVersionSummary> apply(ListSecretBundleVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public SecretsPaginators(Secrets client) {
        this.client = client;
    }
}

