/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.secrets.model.SecretBundleContentDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecretBundle {
    @JsonProperty(value="secretId")
    private final String secretId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonProperty(value="versionName")
    private final String versionName;
    @JsonProperty(value="secretBundleContent")
    private final SecretBundleContentDetails secretBundleContent;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="timeOfExpiry")
    private final Date timeOfExpiry;
    @JsonProperty(value="stages")
    private final List<Stages> stages;
    @JsonProperty(value="metadata")
    private final Map<String, Object> metadata;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().secretId(this.secretId).timeCreated(this.timeCreated).versionNumber(this.versionNumber).versionName(this.versionName).secretBundleContent(this.secretBundleContent).timeOfDeletion(this.timeOfDeletion).timeOfExpiry(this.timeOfExpiry).stages(this.stages).metadata(this.metadata);
    }

    public String getSecretId() {
        return this.secretId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public SecretBundleContentDetails getSecretBundleContent() {
        return this.secretBundleContent;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public Date getTimeOfExpiry() {
        return this.timeOfExpiry;
    }

    public List<Stages> getStages() {
        return this.stages;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretBundle)) {
            return false;
        }
        SecretBundle other = (SecretBundle)o;
        Long this$versionNumber = this.getVersionNumber();
        Long other$versionNumber = other.getVersionNumber();
        if (this$versionNumber == null ? other$versionNumber != null : !((Object)this$versionNumber).equals(other$versionNumber)) {
            return false;
        }
        String this$secretId = this.getSecretId();
        String other$secretId = other.getSecretId();
        if (this$secretId == null ? other$secretId != null : !this$secretId.equals(other$secretId)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        String this$versionName = this.getVersionName();
        String other$versionName = other.getVersionName();
        if (this$versionName == null ? other$versionName != null : !this$versionName.equals(other$versionName)) {
            return false;
        }
        SecretBundleContentDetails this$secretBundleContent = this.getSecretBundleContent();
        SecretBundleContentDetails other$secretBundleContent = other.getSecretBundleContent();
        if (this$secretBundleContent == null ? other$secretBundleContent != null : !((Object)this$secretBundleContent).equals(other$secretBundleContent)) {
            return false;
        }
        Date this$timeOfDeletion = this.getTimeOfDeletion();
        Date other$timeOfDeletion = other.getTimeOfDeletion();
        if (this$timeOfDeletion == null ? other$timeOfDeletion != null : !((Object)this$timeOfDeletion).equals(other$timeOfDeletion)) {
            return false;
        }
        Date this$timeOfExpiry = this.getTimeOfExpiry();
        Date other$timeOfExpiry = other.getTimeOfExpiry();
        if (this$timeOfExpiry == null ? other$timeOfExpiry != null : !((Object)this$timeOfExpiry).equals(other$timeOfExpiry)) {
            return false;
        }
        List<Stages> this$stages = this.getStages();
        List<Stages> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $versionNumber = this.getVersionNumber();
        result = result * 59 + ($versionNumber == null ? 43 : ((Object)$versionNumber).hashCode());
        String $secretId = this.getSecretId();
        result = result * 59 + ($secretId == null ? 43 : $secretId.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        String $versionName = this.getVersionName();
        result = result * 59 + ($versionName == null ? 43 : $versionName.hashCode());
        SecretBundleContentDetails $secretBundleContent = this.getSecretBundleContent();
        result = result * 59 + ($secretBundleContent == null ? 43 : ((Object)$secretBundleContent).hashCode());
        Date $timeOfDeletion = this.getTimeOfDeletion();
        result = result * 59 + ($timeOfDeletion == null ? 43 : ((Object)$timeOfDeletion).hashCode());
        Date $timeOfExpiry = this.getTimeOfExpiry();
        result = result * 59 + ($timeOfExpiry == null ? 43 : ((Object)$timeOfExpiry).hashCode());
        List<Stages> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "SecretBundle(secretId=" + this.getSecretId() + ", timeCreated=" + this.getTimeCreated() + ", versionNumber=" + this.getVersionNumber() + ", versionName=" + this.getVersionName() + ", secretBundleContent=" + this.getSecretBundleContent() + ", timeOfDeletion=" + this.getTimeOfDeletion() + ", timeOfExpiry=" + this.getTimeOfExpiry() + ", stages=" + this.getStages() + ", metadata=" + this.getMetadata() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"secretId", "timeCreated", "versionNumber", "versionName", "secretBundleContent", "timeOfDeletion", "timeOfExpiry", "stages", "metadata"})
    @Deprecated
    public SecretBundle(String secretId, Date timeCreated, Long versionNumber, String versionName, SecretBundleContentDetails secretBundleContent, Date timeOfDeletion, Date timeOfExpiry, List<Stages> stages, Map<String, Object> metadata) {
        this.secretId = secretId;
        this.timeCreated = timeCreated;
        this.versionNumber = versionNumber;
        this.versionName = versionName;
        this.secretBundleContent = secretBundleContent;
        this.timeOfDeletion = timeOfDeletion;
        this.timeOfExpiry = timeOfExpiry;
        this.stages = stages;
        this.metadata = metadata;
    }

    public static enum Stages {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Stages> map;

        private Stages(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stages create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Stages', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Stages.class);
            map = new HashMap<String, Stages>();
            for (Stages v : Stages.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="secretId")
        private String secretId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="versionNumber")
        private Long versionNumber;
        @JsonProperty(value="versionName")
        private String versionName;
        @JsonProperty(value="secretBundleContent")
        private SecretBundleContentDetails secretBundleContent;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="timeOfExpiry")
        private Date timeOfExpiry;
        @JsonProperty(value="stages")
        private List<Stages> stages;
        @JsonProperty(value="metadata")
        private Map<String, Object> metadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            this.__explicitlySet__.add("secretId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            this.__explicitlySet__.add("versionName");
            return this;
        }

        public Builder secretBundleContent(SecretBundleContentDetails secretBundleContent) {
            this.secretBundleContent = secretBundleContent;
            this.__explicitlySet__.add("secretBundleContent");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder timeOfExpiry(Date timeOfExpiry) {
            this.timeOfExpiry = timeOfExpiry;
            this.__explicitlySet__.add("timeOfExpiry");
            return this;
        }

        public Builder stages(List<Stages> stages) {
            this.stages = stages;
            this.__explicitlySet__.add("stages");
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public SecretBundle build() {
            SecretBundle __instance__ = new SecretBundle(this.secretId, this.timeCreated, this.versionNumber, this.versionName, this.secretBundleContent, this.timeOfDeletion, this.timeOfExpiry, this.stages, this.metadata);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SecretBundle o) {
            Builder copiedBuilder = this.secretId(o.getSecretId()).timeCreated(o.getTimeCreated()).versionNumber(o.getVersionNumber()).versionName(o.getVersionName()).secretBundleContent(o.getSecretBundleContent()).timeOfDeletion(o.getTimeOfDeletion()).timeOfExpiry(o.getTimeOfExpiry()).stages(o.getStages()).metadata(o.getMetadata());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "SecretBundle.Builder(secretId=" + this.secretId + ", timeCreated=" + this.timeCreated + ", versionNumber=" + this.versionNumber + ", versionName=" + this.versionName + ", secretBundleContent=" + this.secretBundleContent + ", timeOfDeletion=" + this.timeOfDeletion + ", timeOfExpiry=" + this.timeOfExpiry + ", stages=" + this.stages + ", metadata=" + this.metadata + ")";
        }
    }
}

