/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.adm.model;

/**
 * Details to create a vulnerability audit. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220421")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = CreateVulnerabilityAuditDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class CreateVulnerabilityAuditDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "knowledgeBaseId",
        "compartmentId",
        "applicationDependencies",
        "buildType",
        "configuration",
        "usageData",
        "displayName",
        "source",
        "freeformTags",
        "definedTags"
    })
    public CreateVulnerabilityAuditDetails(
            String knowledgeBaseId,
            String compartmentId,
            java.util.List<ApplicationDependency> applicationDependencies,
            VulnerabilityAudit.BuildType buildType,
            VulnerabilityAuditConfiguration configuration,
            UsageDataDetails usageData,
            String displayName,
            VulnerabilityAuditSource source,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags) {
        super();
        this.knowledgeBaseId = knowledgeBaseId;
        this.compartmentId = compartmentId;
        this.applicationDependencies = applicationDependencies;
        this.buildType = buildType;
        this.configuration = configuration;
        this.usageData = usageData;
        this.displayName = displayName;
        this.source = source;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * knowledge base.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("knowledgeBaseId")
        private String knowledgeBaseId;

        /**
         * The Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * knowledge base.
         *
         * @param knowledgeBaseId the value to set
         * @return this builder
         */
        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            this.__explicitlySet__.add("knowledgeBaseId");
            return this;
        }
        /**
         * The compartment Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * vulnerability audit. If compartment identifier is not provided the compartment of the
         * associated knowledge base will be used instead.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The compartment Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * vulnerability audit. If compartment identifier is not provided the compartment of the
         * associated knowledge base will be used instead.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /** List of application dependencies (without vulnerabilities). */
        @com.fasterxml.jackson.annotation.JsonProperty("applicationDependencies")
        private java.util.List<ApplicationDependency> applicationDependencies;

        /**
         * List of application dependencies (without vulnerabilities).
         *
         * @param applicationDependencies the value to set
         * @return this builder
         */
        public Builder applicationDependencies(
                java.util.List<ApplicationDependency> applicationDependencies) {
            this.applicationDependencies = applicationDependencies;
            this.__explicitlySet__.add("applicationDependencies");
            return this;
        }
        /**
         * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET
         * when the list of application dependencies is not Maven-related or is a mix of Maven and
         * other ecosystems. This option is soon to be deprecated.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("buildType")
        private VulnerabilityAudit.BuildType buildType;

        /**
         * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET
         * when the list of application dependencies is not Maven-related or is a mix of Maven and
         * other ecosystems. This option is soon to be deprecated.
         *
         * @param buildType the value to set
         * @return this builder
         */
        public Builder buildType(VulnerabilityAudit.BuildType buildType) {
            this.buildType = buildType;
            this.__explicitlySet__.add("buildType");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("configuration")
        private VulnerabilityAuditConfiguration configuration;

        public Builder configuration(VulnerabilityAuditConfiguration configuration) {
            this.configuration = configuration;
            this.__explicitlySet__.add("configuration");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("usageData")
        private UsageDataDetails usageData;

        public Builder usageData(UsageDataDetails usageData) {
            this.usageData = usageData;
            this.__explicitlySet__.add("usageData");
            return this;
        }
        /** The name of the vulnerability audit. */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * The name of the vulnerability audit.
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("source")
        private VulnerabilityAuditSource source;

        public Builder source(VulnerabilityAuditSource source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }
        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public CreateVulnerabilityAuditDetails build() {
            CreateVulnerabilityAuditDetails model =
                    new CreateVulnerabilityAuditDetails(
                            this.knowledgeBaseId,
                            this.compartmentId,
                            this.applicationDependencies,
                            this.buildType,
                            this.configuration,
                            this.usageData,
                            this.displayName,
                            this.source,
                            this.freeformTags,
                            this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(CreateVulnerabilityAuditDetails model) {
            if (model.wasPropertyExplicitlySet("knowledgeBaseId")) {
                this.knowledgeBaseId(model.getKnowledgeBaseId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("applicationDependencies")) {
                this.applicationDependencies(model.getApplicationDependencies());
            }
            if (model.wasPropertyExplicitlySet("buildType")) {
                this.buildType(model.getBuildType());
            }
            if (model.wasPropertyExplicitlySet("configuration")) {
                this.configuration(model.getConfiguration());
            }
            if (model.wasPropertyExplicitlySet("usageData")) {
                this.usageData(model.getUsageData());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * knowledge base.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("knowledgeBaseId")
    private final String knowledgeBaseId;

    /**
     * The Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * knowledge base.
     *
     * @return the value
     */
    public String getKnowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * The compartment Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * vulnerability audit. If compartment identifier is not provided the compartment of the
     * associated knowledge base will be used instead.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The compartment Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * vulnerability audit. If compartment identifier is not provided the compartment of the
     * associated knowledge base will be used instead.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /** List of application dependencies (without vulnerabilities). */
    @com.fasterxml.jackson.annotation.JsonProperty("applicationDependencies")
    private final java.util.List<ApplicationDependency> applicationDependencies;

    /**
     * List of application dependencies (without vulnerabilities).
     *
     * @return the value
     */
    public java.util.List<ApplicationDependency> getApplicationDependencies() {
        return applicationDependencies;
    }

    /**
     * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when
     * the list of application dependencies is not Maven-related or is a mix of Maven and other
     * ecosystems. This option is soon to be deprecated.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("buildType")
    private final VulnerabilityAudit.BuildType buildType;

    /**
     * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when
     * the list of application dependencies is not Maven-related or is a mix of Maven and other
     * ecosystems. This option is soon to be deprecated.
     *
     * @return the value
     */
    public VulnerabilityAudit.BuildType getBuildType() {
        return buildType;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("configuration")
    private final VulnerabilityAuditConfiguration configuration;

    public VulnerabilityAuditConfiguration getConfiguration() {
        return configuration;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("usageData")
    private final UsageDataDetails usageData;

    public UsageDataDetails getUsageData() {
        return usageData;
    }

    /** The name of the vulnerability audit. */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * The name of the vulnerability audit.
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("source")
    private final VulnerabilityAuditSource source;

    public VulnerabilityAuditSource getSource() {
        return source;
    }

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("CreateVulnerabilityAuditDetails(");
        sb.append("super=").append(super.toString());
        sb.append("knowledgeBaseId=").append(String.valueOf(this.knowledgeBaseId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", applicationDependencies=")
                .append(String.valueOf(this.applicationDependencies));
        sb.append(", buildType=").append(String.valueOf(this.buildType));
        sb.append(", configuration=").append(String.valueOf(this.configuration));
        sb.append(", usageData=").append(String.valueOf(this.usageData));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", source=").append(String.valueOf(this.source));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateVulnerabilityAuditDetails)) {
            return false;
        }

        CreateVulnerabilityAuditDetails other = (CreateVulnerabilityAuditDetails) o;
        return java.util.Objects.equals(this.knowledgeBaseId, other.knowledgeBaseId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(
                        this.applicationDependencies, other.applicationDependencies)
                && java.util.Objects.equals(this.buildType, other.buildType)
                && java.util.Objects.equals(this.configuration, other.configuration)
                && java.util.Objects.equals(this.usageData, other.usageData)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.source, other.source)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.knowledgeBaseId == null ? 43 : this.knowledgeBaseId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.applicationDependencies == null
                                ? 43
                                : this.applicationDependencies.hashCode());
        result = (result * PRIME) + (this.buildType == null ? 43 : this.buildType.hashCode());
        result =
                (result * PRIME)
                        + (this.configuration == null ? 43 : this.configuration.hashCode());
        result = (result * PRIME) + (this.usageData == null ? 43 : this.usageData.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.source == null ? 43 : this.source.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
