/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.adm.model;

/**
 * A vulnerability audit associates the application dependencies of a project with their associated
 * Vulnerabilities. Each Vulnerability is associated with a score (Common Vulnerability Scoring
 * System V2 or V3). A vulnerable application dependency can be ignored based on the configuration
 * of the vulnerability audit. maxObservedCvssV2Score, maxObservedCvssV3Score and
 * vulnerableArtifactsCount do not take into account non-vulnerable application dependency. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220421")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilityAudit.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilityAudit
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "displayName",
        "knowledgeBaseId",
        "timeCreated",
        "timeUpdated",
        "lifecycleState",
        "lifecycleDetails",
        "vulnerabilities",
        "maxObservedCvssV2Score",
        "maxObservedCvssV3Score",
        "maxObservedSeverity",
        "maxObservedCvssV2ScoreWithIgnored",
        "maxObservedCvssV3ScoreWithIgnored",
        "maxObservedSeverityWithIgnored",
        "vulnerableArtifactsCountWithIgnored",
        "vulnerableArtifactsCount",
        "configuration",
        "usageData",
        "isSuccess",
        "buildType",
        "source",
        "compartmentId",
        "freeformTags",
        "definedTags",
        "systemTags"
    })
    public VulnerabilityAudit(
            String id,
            String displayName,
            String knowledgeBaseId,
            java.util.Date timeCreated,
            java.util.Date timeUpdated,
            LifecycleState lifecycleState,
            LifecycleDetails lifecycleDetails,
            java.util.List<Vulnerability> vulnerabilities,
            Float maxObservedCvssV2Score,
            Float maxObservedCvssV3Score,
            VulnerabilitySeverity maxObservedSeverity,
            Float maxObservedCvssV2ScoreWithIgnored,
            Float maxObservedCvssV3ScoreWithIgnored,
            VulnerabilitySeverity maxObservedSeverityWithIgnored,
            Integer vulnerableArtifactsCountWithIgnored,
            Integer vulnerableArtifactsCount,
            VulnerabilityAuditConfiguration configuration,
            UsageDataDetails usageData,
            Boolean isSuccess,
            BuildType buildType,
            VulnerabilityAuditSource source,
            String compartmentId,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags,
            java.util.Map<String, java.util.Map<String, Object>> systemTags) {
        super();
        this.id = id;
        this.displayName = displayName;
        this.knowledgeBaseId = knowledgeBaseId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.vulnerabilities = vulnerabilities;
        this.maxObservedCvssV2Score = maxObservedCvssV2Score;
        this.maxObservedCvssV3Score = maxObservedCvssV3Score;
        this.maxObservedSeverity = maxObservedSeverity;
        this.maxObservedCvssV2ScoreWithIgnored = maxObservedCvssV2ScoreWithIgnored;
        this.maxObservedCvssV3ScoreWithIgnored = maxObservedCvssV3ScoreWithIgnored;
        this.maxObservedSeverityWithIgnored = maxObservedSeverityWithIgnored;
        this.vulnerableArtifactsCountWithIgnored = vulnerableArtifactsCountWithIgnored;
        this.vulnerableArtifactsCount = vulnerableArtifactsCount;
        this.configuration = configuration;
        this.usageData = usageData;
        this.isSuccess = isSuccess;
        this.buildType = buildType;
        this.source = source;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * vulnerability audit.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * vulnerability audit.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** The name of the vulnerability audit. */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * The name of the vulnerability audit.
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /**
         * The Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * knowledge base.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("knowledgeBaseId")
        private String knowledgeBaseId;

        /**
         * The Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * knowledge base.
         *
         * @param knowledgeBaseId the value to set
         * @return this builder
         */
        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            this.__explicitlySet__.add("knowledgeBaseId");
            return this;
        }
        /**
         * The creation date and time of the vulnerability audit (formatted according to
         * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeCreated")
        private java.util.Date timeCreated;

        /**
         * The creation date and time of the vulnerability audit (formatted according to
         * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
         *
         * @param timeCreated the value to set
         * @return this builder
         */
        public Builder timeCreated(java.util.Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }
        /**
         * The update date and time of the vulnerability audit (formatted according to
         * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
        private java.util.Date timeUpdated;

        /**
         * The update date and time of the vulnerability audit (formatted according to
         * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
         *
         * @param timeUpdated the value to set
         * @return this builder
         */
        public Builder timeUpdated(java.util.Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }
        /** The current lifecycle state of the vulnerability audit. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private LifecycleState lifecycleState;

        /**
         * The current lifecycle state of the vulnerability audit.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }
        /** Details on the lifecycle state. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleDetails")
        private LifecycleDetails lifecycleDetails;

        /**
         * Details on the lifecycle state.
         *
         * @param lifecycleDetails the value to set
         * @return this builder
         */
        public Builder lifecycleDetails(LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }
        /**
         * List of vulnerabilities found in the vulnerability audit. If a vulnerability affects
         * multiple dependencies, the metadata returned here consists of audit-wide aggregates.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilities")
        private java.util.List<Vulnerability> vulnerabilities;

        /**
         * List of vulnerabilities found in the vulnerability audit. If a vulnerability affects
         * multiple dependencies, the metadata returned here consists of audit-wide aggregates.
         *
         * @param vulnerabilities the value to set
         * @return this builder
         */
        public Builder vulnerabilities(java.util.List<Vulnerability> vulnerabilities) {
            this.vulnerabilities = vulnerabilities;
            this.__explicitlySet__.add("vulnerabilities");
            return this;
        }
        /**
         * Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored
         * vulnerable application dependencies.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV2Score")
        private Float maxObservedCvssV2Score;

        /**
         * Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored
         * vulnerable application dependencies.
         *
         * @param maxObservedCvssV2Score the value to set
         * @return this builder
         */
        public Builder maxObservedCvssV2Score(Float maxObservedCvssV2Score) {
            this.maxObservedCvssV2Score = maxObservedCvssV2Score;
            this.__explicitlySet__.add("maxObservedCvssV2Score");
            return this;
        }
        /**
         * Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored
         * vulnerable application dependencies.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV3Score")
        private Float maxObservedCvssV3Score;

        /**
         * Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored
         * vulnerable application dependencies.
         *
         * @param maxObservedCvssV3Score the value to set
         * @return this builder
         */
        public Builder maxObservedCvssV3Score(Float maxObservedCvssV3Score) {
            this.maxObservedCvssV3Score = maxObservedCvssV3Score;
            this.__explicitlySet__.add("maxObservedCvssV3Score");
            return this;
        }
        /** Maximum ADM Severity observed for non-ignored vulnerable application dependencies. */
        @com.fasterxml.jackson.annotation.JsonProperty("maxObservedSeverity")
        private VulnerabilitySeverity maxObservedSeverity;

        /**
         * Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
         *
         * @param maxObservedSeverity the value to set
         * @return this builder
         */
        public Builder maxObservedSeverity(VulnerabilitySeverity maxObservedSeverity) {
            this.maxObservedSeverity = maxObservedSeverity;
            this.__explicitlySet__.add("maxObservedSeverity");
            return this;
        }
        /**
         * Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable
         * application dependencies including ignored ones.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV2ScoreWithIgnored")
        private Float maxObservedCvssV2ScoreWithIgnored;

        /**
         * Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable
         * application dependencies including ignored ones.
         *
         * @param maxObservedCvssV2ScoreWithIgnored the value to set
         * @return this builder
         */
        public Builder maxObservedCvssV2ScoreWithIgnored(Float maxObservedCvssV2ScoreWithIgnored) {
            this.maxObservedCvssV2ScoreWithIgnored = maxObservedCvssV2ScoreWithIgnored;
            this.__explicitlySet__.add("maxObservedCvssV2ScoreWithIgnored");
            return this;
        }
        /**
         * Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable
         * application dependencies including ignored ones.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV3ScoreWithIgnored")
        private Float maxObservedCvssV3ScoreWithIgnored;

        /**
         * Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable
         * application dependencies including ignored ones.
         *
         * @param maxObservedCvssV3ScoreWithIgnored the value to set
         * @return this builder
         */
        public Builder maxObservedCvssV3ScoreWithIgnored(Float maxObservedCvssV3ScoreWithIgnored) {
            this.maxObservedCvssV3ScoreWithIgnored = maxObservedCvssV3ScoreWithIgnored;
            this.__explicitlySet__.add("maxObservedCvssV3ScoreWithIgnored");
            return this;
        }
        /**
         * Maximum ADM Severity observed for vulnerable application dependencies including ignored
         * ones.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("maxObservedSeverityWithIgnored")
        private VulnerabilitySeverity maxObservedSeverityWithIgnored;

        /**
         * Maximum ADM Severity observed for vulnerable application dependencies including ignored
         * ones.
         *
         * @param maxObservedSeverityWithIgnored the value to set
         * @return this builder
         */
        public Builder maxObservedSeverityWithIgnored(
                VulnerabilitySeverity maxObservedSeverityWithIgnored) {
            this.maxObservedSeverityWithIgnored = maxObservedSeverityWithIgnored;
            this.__explicitlySet__.add("maxObservedSeverityWithIgnored");
            return this;
        }
        /** Count of all vulnerable application dependencies. */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerableArtifactsCountWithIgnored")
        private Integer vulnerableArtifactsCountWithIgnored;

        /**
         * Count of all vulnerable application dependencies.
         *
         * @param vulnerableArtifactsCountWithIgnored the value to set
         * @return this builder
         */
        public Builder vulnerableArtifactsCountWithIgnored(
                Integer vulnerableArtifactsCountWithIgnored) {
            this.vulnerableArtifactsCountWithIgnored = vulnerableArtifactsCountWithIgnored;
            this.__explicitlySet__.add("vulnerableArtifactsCountWithIgnored");
            return this;
        }
        /** Count of non-ignored vulnerable application dependencies. */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerableArtifactsCount")
        private Integer vulnerableArtifactsCount;

        /**
         * Count of non-ignored vulnerable application dependencies.
         *
         * @param vulnerableArtifactsCount the value to set
         * @return this builder
         */
        public Builder vulnerableArtifactsCount(Integer vulnerableArtifactsCount) {
            this.vulnerableArtifactsCount = vulnerableArtifactsCount;
            this.__explicitlySet__.add("vulnerableArtifactsCount");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("configuration")
        private VulnerabilityAuditConfiguration configuration;

        public Builder configuration(VulnerabilityAuditConfiguration configuration) {
            this.configuration = configuration;
            this.__explicitlySet__.add("configuration");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("usageData")
        private UsageDataDetails usageData;

        public Builder usageData(UsageDataDetails usageData) {
            this.usageData = usageData;
            this.__explicitlySet__.add("usageData");
            return this;
        }
        /**
         * Indicates if an audit succeeded according to the configuration. The value is {@code null}
         * if the audit is in the {@code CREATING} state.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isSuccess")
        private Boolean isSuccess;

        /**
         * Indicates if an audit succeeded according to the configuration. The value is {@code null}
         * if the audit is in the {@code CREATING} state.
         *
         * @param isSuccess the value to set
         * @return this builder
         */
        public Builder isSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.__explicitlySet__.add("isSuccess");
            return this;
        }
        /**
         * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET
         * when the list of application dependencies is not Maven-related or is a mix of Maven and
         * other ecosystems. This option is soon to be deprecated.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("buildType")
        private BuildType buildType;

        /**
         * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET
         * when the list of application dependencies is not Maven-related or is a mix of Maven and
         * other ecosystems. This option is soon to be deprecated.
         *
         * @param buildType the value to set
         * @return this builder
         */
        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            this.__explicitlySet__.add("buildType");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("source")
        private VulnerabilityAuditSource source;

        public Builder source(VulnerabilityAuditSource source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }
        /**
         * The compartment Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * vulnerability audit.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The compartment Oracle Cloud identifier
         * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
         * vulnerability audit.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }
        /**
         * Usage of system tag keys. These predefined keys are scoped to namespaces. Example: {@code
         * {"orcl-cloud": {"free-tier-retained": "true"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("systemTags")
        private java.util.Map<String, java.util.Map<String, Object>> systemTags;

        /**
         * Usage of system tag keys. These predefined keys are scoped to namespaces. Example: {@code
         * {"orcl-cloud": {"free-tier-retained": "true"}}}
         *
         * @param systemTags the value to set
         * @return this builder
         */
        public Builder systemTags(java.util.Map<String, java.util.Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilityAudit build() {
            VulnerabilityAudit model =
                    new VulnerabilityAudit(
                            this.id,
                            this.displayName,
                            this.knowledgeBaseId,
                            this.timeCreated,
                            this.timeUpdated,
                            this.lifecycleState,
                            this.lifecycleDetails,
                            this.vulnerabilities,
                            this.maxObservedCvssV2Score,
                            this.maxObservedCvssV3Score,
                            this.maxObservedSeverity,
                            this.maxObservedCvssV2ScoreWithIgnored,
                            this.maxObservedCvssV3ScoreWithIgnored,
                            this.maxObservedSeverityWithIgnored,
                            this.vulnerableArtifactsCountWithIgnored,
                            this.vulnerableArtifactsCount,
                            this.configuration,
                            this.usageData,
                            this.isSuccess,
                            this.buildType,
                            this.source,
                            this.compartmentId,
                            this.freeformTags,
                            this.definedTags,
                            this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilityAudit model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("knowledgeBaseId")) {
                this.knowledgeBaseId(model.getKnowledgeBaseId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilities")) {
                this.vulnerabilities(model.getVulnerabilities());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV2Score")) {
                this.maxObservedCvssV2Score(model.getMaxObservedCvssV2Score());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV3Score")) {
                this.maxObservedCvssV3Score(model.getMaxObservedCvssV3Score());
            }
            if (model.wasPropertyExplicitlySet("maxObservedSeverity")) {
                this.maxObservedSeverity(model.getMaxObservedSeverity());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV2ScoreWithIgnored")) {
                this.maxObservedCvssV2ScoreWithIgnored(
                        model.getMaxObservedCvssV2ScoreWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV3ScoreWithIgnored")) {
                this.maxObservedCvssV3ScoreWithIgnored(
                        model.getMaxObservedCvssV3ScoreWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("maxObservedSeverityWithIgnored")) {
                this.maxObservedSeverityWithIgnored(model.getMaxObservedSeverityWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("vulnerableArtifactsCountWithIgnored")) {
                this.vulnerableArtifactsCountWithIgnored(
                        model.getVulnerableArtifactsCountWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("vulnerableArtifactsCount")) {
                this.vulnerableArtifactsCount(model.getVulnerableArtifactsCount());
            }
            if (model.wasPropertyExplicitlySet("configuration")) {
                this.configuration(model.getConfiguration());
            }
            if (model.wasPropertyExplicitlySet("usageData")) {
                this.usageData(model.getUsageData());
            }
            if (model.wasPropertyExplicitlySet("isSuccess")) {
                this.isSuccess(model.getIsSuccess());
            }
            if (model.wasPropertyExplicitlySet("buildType")) {
                this.buildType(model.getBuildType());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * vulnerability audit.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * vulnerability audit.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** The name of the vulnerability audit. */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * The name of the vulnerability audit.
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * The Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * knowledge base.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("knowledgeBaseId")
    private final String knowledgeBaseId;

    /**
     * The Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * knowledge base.
     *
     * @return the value
     */
    public String getKnowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * The creation date and time of the vulnerability audit (formatted according to
     * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeCreated")
    private final java.util.Date timeCreated;

    /**
     * The creation date and time of the vulnerability audit (formatted according to
     * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
     *
     * @return the value
     */
    public java.util.Date getTimeCreated() {
        return timeCreated;
    }

    /**
     * The update date and time of the vulnerability audit (formatted according to
     * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
    private final java.util.Date timeUpdated;

    /**
     * The update date and time of the vulnerability audit (formatted according to
     * [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
     *
     * @return the value
     */
    public java.util.Date getTimeUpdated() {
        return timeUpdated;
    }

    /** The current lifecycle state of the vulnerability audit. */
    public enum LifecycleState implements com.oracle.bmc.http.internal.BmcEnum {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        Failed("FAILED"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(LifecycleState.class);

        private final String value;
        private static java.util.Map<String, LifecycleState> map;

        static {
            map = new java.util.HashMap<>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        LifecycleState(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /** The current lifecycle state of the vulnerability audit. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final LifecycleState lifecycleState;

    /**
     * The current lifecycle state of the vulnerability audit.
     *
     * @return the value
     */
    public LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    /** Details on the lifecycle state. */
    public enum LifecycleDetails implements com.oracle.bmc.http.internal.BmcEnum {
        UsageDataNotFoundOrNotAuthorized("USAGE_DATA_NOT_FOUND_OR_NOT_AUTHORIZED"),
        UsageDataParseFailed("USAGE_DATA_PARSE_FAILED"),
        UsageDataCompressedSizeLimitExceeded("USAGE_DATA_COMPRESSED_SIZE_LIMIT_EXCEEDED"),
        UsageDataUncompressedSizeLimitExceeded("USAGE_DATA_UNCOMPRESSED_SIZE_LIMIT_EXCEEDED"),
        UsageDataUnknownError("USAGE_DATA_UNKNOWN_ERROR"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(LifecycleDetails.class);

        private final String value;
        private static java.util.Map<String, LifecycleDetails> map;

        static {
            map = new java.util.HashMap<>();
            for (LifecycleDetails v : LifecycleDetails.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        LifecycleDetails(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static LifecycleDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'LifecycleDetails', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /** Details on the lifecycle state. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleDetails")
    private final LifecycleDetails lifecycleDetails;

    /**
     * Details on the lifecycle state.
     *
     * @return the value
     */
    public LifecycleDetails getLifecycleDetails() {
        return lifecycleDetails;
    }

    /**
     * List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple
     * dependencies, the metadata returned here consists of audit-wide aggregates.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilities")
    private final java.util.List<Vulnerability> vulnerabilities;

    /**
     * List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple
     * dependencies, the metadata returned here consists of audit-wide aggregates.
     *
     * @return the value
     */
    public java.util.List<Vulnerability> getVulnerabilities() {
        return vulnerabilities;
    }

    /**
     * Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored
     * vulnerable application dependencies.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV2Score")
    private final Float maxObservedCvssV2Score;

    /**
     * Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored
     * vulnerable application dependencies.
     *
     * @return the value
     */
    public Float getMaxObservedCvssV2Score() {
        return maxObservedCvssV2Score;
    }

    /**
     * Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored
     * vulnerable application dependencies.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV3Score")
    private final Float maxObservedCvssV3Score;

    /**
     * Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored
     * vulnerable application dependencies.
     *
     * @return the value
     */
    public Float getMaxObservedCvssV3Score() {
        return maxObservedCvssV3Score;
    }

    /** Maximum ADM Severity observed for non-ignored vulnerable application dependencies. */
    @com.fasterxml.jackson.annotation.JsonProperty("maxObservedSeverity")
    private final VulnerabilitySeverity maxObservedSeverity;

    /**
     * Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
     *
     * @return the value
     */
    public VulnerabilitySeverity getMaxObservedSeverity() {
        return maxObservedSeverity;
    }

    /**
     * Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable
     * application dependencies including ignored ones.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV2ScoreWithIgnored")
    private final Float maxObservedCvssV2ScoreWithIgnored;

    /**
     * Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable
     * application dependencies including ignored ones.
     *
     * @return the value
     */
    public Float getMaxObservedCvssV2ScoreWithIgnored() {
        return maxObservedCvssV2ScoreWithIgnored;
    }

    /**
     * Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable
     * application dependencies including ignored ones.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxObservedCvssV3ScoreWithIgnored")
    private final Float maxObservedCvssV3ScoreWithIgnored;

    /**
     * Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable
     * application dependencies including ignored ones.
     *
     * @return the value
     */
    public Float getMaxObservedCvssV3ScoreWithIgnored() {
        return maxObservedCvssV3ScoreWithIgnored;
    }

    /**
     * Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxObservedSeverityWithIgnored")
    private final VulnerabilitySeverity maxObservedSeverityWithIgnored;

    /**
     * Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
     *
     * @return the value
     */
    public VulnerabilitySeverity getMaxObservedSeverityWithIgnored() {
        return maxObservedSeverityWithIgnored;
    }

    /** Count of all vulnerable application dependencies. */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerableArtifactsCountWithIgnored")
    private final Integer vulnerableArtifactsCountWithIgnored;

    /**
     * Count of all vulnerable application dependencies.
     *
     * @return the value
     */
    public Integer getVulnerableArtifactsCountWithIgnored() {
        return vulnerableArtifactsCountWithIgnored;
    }

    /** Count of non-ignored vulnerable application dependencies. */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerableArtifactsCount")
    private final Integer vulnerableArtifactsCount;

    /**
     * Count of non-ignored vulnerable application dependencies.
     *
     * @return the value
     */
    public Integer getVulnerableArtifactsCount() {
        return vulnerableArtifactsCount;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("configuration")
    private final VulnerabilityAuditConfiguration configuration;

    public VulnerabilityAuditConfiguration getConfiguration() {
        return configuration;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("usageData")
    private final UsageDataDetails usageData;

    public UsageDataDetails getUsageData() {
        return usageData;
    }

    /**
     * Indicates if an audit succeeded according to the configuration. The value is {@code null} if
     * the audit is in the {@code CREATING} state.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isSuccess")
    private final Boolean isSuccess;

    /**
     * Indicates if an audit succeeded according to the configuration. The value is {@code null} if
     * the audit is in the {@code CREATING} state.
     *
     * @return the value
     */
    public Boolean getIsSuccess() {
        return isSuccess;
    }

    /**
     * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when
     * the list of application dependencies is not Maven-related or is a mix of Maven and other
     * ecosystems. This option is soon to be deprecated.
     */
    public enum BuildType implements com.oracle.bmc.http.internal.BmcEnum {
        Maven("MAVEN"),
        Unset("UNSET"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG =
                org.slf4j.LoggerFactory.getLogger(BuildType.class);

        private final String value;
        private static java.util.Map<String, BuildType> map;

        static {
            map = new java.util.HashMap<>();
            for (BuildType v : BuildType.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        BuildType(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static BuildType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'BuildType', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when
     * the list of application dependencies is not Maven-related or is a mix of Maven and other
     * ecosystems. This option is soon to be deprecated.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("buildType")
    private final BuildType buildType;

    /**
     * The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when
     * the list of application dependencies is not Maven-related or is a mix of Maven and other
     * ecosystems. This option is soon to be deprecated.
     *
     * @return the value
     */
    public BuildType getBuildType() {
        return buildType;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("source")
    private final VulnerabilityAuditSource source;

    public VulnerabilityAuditSource getSource() {
        return source;
    }

    /**
     * The compartment Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * vulnerability audit.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The compartment Oracle Cloud identifier
     * ([OCID](https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm)) of the
     * vulnerability audit.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    /**
     * Usage of system tag keys. These predefined keys are scoped to namespaces. Example: {@code
     * {"orcl-cloud": {"free-tier-retained": "true"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("systemTags")
    private final java.util.Map<String, java.util.Map<String, Object>> systemTags;

    /**
     * Usage of system tag keys. These predefined keys are scoped to namespaces. Example: {@code
     * {"orcl-cloud": {"free-tier-retained": "true"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getSystemTags() {
        return systemTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilityAudit(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", knowledgeBaseId=").append(String.valueOf(this.knowledgeBaseId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", vulnerabilities=").append(String.valueOf(this.vulnerabilities));
        sb.append(", maxObservedCvssV2Score=").append(String.valueOf(this.maxObservedCvssV2Score));
        sb.append(", maxObservedCvssV3Score=").append(String.valueOf(this.maxObservedCvssV3Score));
        sb.append(", maxObservedSeverity=").append(String.valueOf(this.maxObservedSeverity));
        sb.append(", maxObservedCvssV2ScoreWithIgnored=")
                .append(String.valueOf(this.maxObservedCvssV2ScoreWithIgnored));
        sb.append(", maxObservedCvssV3ScoreWithIgnored=")
                .append(String.valueOf(this.maxObservedCvssV3ScoreWithIgnored));
        sb.append(", maxObservedSeverityWithIgnored=")
                .append(String.valueOf(this.maxObservedSeverityWithIgnored));
        sb.append(", vulnerableArtifactsCountWithIgnored=")
                .append(String.valueOf(this.vulnerableArtifactsCountWithIgnored));
        sb.append(", vulnerableArtifactsCount=")
                .append(String.valueOf(this.vulnerableArtifactsCount));
        sb.append(", configuration=").append(String.valueOf(this.configuration));
        sb.append(", usageData=").append(String.valueOf(this.usageData));
        sb.append(", isSuccess=").append(String.valueOf(this.isSuccess));
        sb.append(", buildType=").append(String.valueOf(this.buildType));
        sb.append(", source=").append(String.valueOf(this.source));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityAudit)) {
            return false;
        }

        VulnerabilityAudit other = (VulnerabilityAudit) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.knowledgeBaseId, other.knowledgeBaseId)
                && java.util.Objects.equals(this.timeCreated, other.timeCreated)
                && java.util.Objects.equals(this.timeUpdated, other.timeUpdated)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.lifecycleDetails, other.lifecycleDetails)
                && java.util.Objects.equals(this.vulnerabilities, other.vulnerabilities)
                && java.util.Objects.equals(
                        this.maxObservedCvssV2Score, other.maxObservedCvssV2Score)
                && java.util.Objects.equals(
                        this.maxObservedCvssV3Score, other.maxObservedCvssV3Score)
                && java.util.Objects.equals(this.maxObservedSeverity, other.maxObservedSeverity)
                && java.util.Objects.equals(
                        this.maxObservedCvssV2ScoreWithIgnored,
                        other.maxObservedCvssV2ScoreWithIgnored)
                && java.util.Objects.equals(
                        this.maxObservedCvssV3ScoreWithIgnored,
                        other.maxObservedCvssV3ScoreWithIgnored)
                && java.util.Objects.equals(
                        this.maxObservedSeverityWithIgnored, other.maxObservedSeverityWithIgnored)
                && java.util.Objects.equals(
                        this.vulnerableArtifactsCountWithIgnored,
                        other.vulnerableArtifactsCountWithIgnored)
                && java.util.Objects.equals(
                        this.vulnerableArtifactsCount, other.vulnerableArtifactsCount)
                && java.util.Objects.equals(this.configuration, other.configuration)
                && java.util.Objects.equals(this.usageData, other.usageData)
                && java.util.Objects.equals(this.isSuccess, other.isSuccess)
                && java.util.Objects.equals(this.buildType, other.buildType)
                && java.util.Objects.equals(this.source, other.source)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && java.util.Objects.equals(this.systemTags, other.systemTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result =
                (result * PRIME)
                        + (this.knowledgeBaseId == null ? 43 : this.knowledgeBaseId.hashCode());
        result = (result * PRIME) + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = (result * PRIME) + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilities == null ? 43 : this.vulnerabilities.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedCvssV2Score == null
                                ? 43
                                : this.maxObservedCvssV2Score.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedCvssV3Score == null
                                ? 43
                                : this.maxObservedCvssV3Score.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedSeverity == null
                                ? 43
                                : this.maxObservedSeverity.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedCvssV2ScoreWithIgnored == null
                                ? 43
                                : this.maxObservedCvssV2ScoreWithIgnored.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedCvssV3ScoreWithIgnored == null
                                ? 43
                                : this.maxObservedCvssV3ScoreWithIgnored.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedSeverityWithIgnored == null
                                ? 43
                                : this.maxObservedSeverityWithIgnored.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerableArtifactsCountWithIgnored == null
                                ? 43
                                : this.vulnerableArtifactsCountWithIgnored.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerableArtifactsCount == null
                                ? 43
                                : this.vulnerableArtifactsCount.hashCode());
        result =
                (result * PRIME)
                        + (this.configuration == null ? 43 : this.configuration.hashCode());
        result = (result * PRIME) + (this.usageData == null ? 43 : this.usageData.hashCode());
        result = (result * PRIME) + (this.isSuccess == null ? 43 : this.isSuccess.hashCode());
        result = (result * PRIME) + (this.buildType == null ? 43 : this.buildType.hashCode());
        result = (result * PRIME) + (this.source == null ? 43 : this.source.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
