/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.requests.*;
import com.oracle.bmc.cloudbridge.responses.*;

/** API for Oracle Cloud Bridge service. */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220509")
public interface InventoryAsync extends AutoCloseable {

    /** Rebuilds the client from scratch. Useful to refresh certificates. */
    void refreshClient();

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     *
     * @param endpoint The endpoint of the serice.
     */
    void setEndpoint(String endpoint);

    /** Gets the set endpoint for REST call (ex, https://www.example.com) */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     *
     * <p>Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the
     * endpoint. If the service is not available in this region, however, an
     * IllegalArgumentException will be raised.
     *
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     *
     * <p>Note, this will first try to map the region ID to a known Region and call {@link
     * #setRegion(Region) setRegion}.
     *
     * <p>If no known Region could be determined, it will create an endpoint based on the default
     * endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     *
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Determines whether realm specific endpoint should be used or not. Set
     * realmSpecificEndpointTemplateEnabled to "true" if the user wants to enable use of realm
     * specific endpoint template, otherwise set it to "false"
     *
     * @param realmSpecificEndpointTemplateEnabled flag to enable the use of realm specific endpoint
     *     template
     */
    void useRealmSpecificEndpointTemplate(boolean realmSpecificEndpointTemplateEnabled);

    /**
     * Returns an aggregation of assets. Aggregation groups are sorted by groupBy property. Default
     * sort order is ascending, but can be overridden by the sortOrder parameter.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<AnalyzeAssetsResponse> analyzeAssets(
            AnalyzeAssetsRequest request,
            com.oracle.bmc.responses.AsyncHandler<AnalyzeAssetsRequest, AnalyzeAssetsResponse>
                    handler);

    /**
     * Moves an asset resource from one compartment to another. When provided, If-Match is checked
     * against ETag values of the resource.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeAssetCompartmentResponse> changeAssetCompartment(
            ChangeAssetCompartmentRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ChangeAssetCompartmentRequest, ChangeAssetCompartmentResponse>
                    handler);

    /**
     * Change an asset's tag.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeAssetTagsResponse> changeAssetTags(
            ChangeAssetTagsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ChangeAssetTagsRequest, ChangeAssetTagsResponse>
                    handler);

    /**
     * Creates an asset.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateAssetResponse> createAsset(
            CreateAssetRequest request,
            com.oracle.bmc.responses.AsyncHandler<CreateAssetRequest, CreateAssetResponse> handler);

    /**
     * Creates an inventory.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateInventoryResponse> createInventory(
            CreateInventoryRequest request,
            com.oracle.bmc.responses.AsyncHandler<CreateInventoryRequest, CreateInventoryResponse>
                    handler);

    /**
     * Deletes an asset resource by identifier.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteAssetResponse> deleteAsset(
            DeleteAssetRequest request,
            com.oracle.bmc.responses.AsyncHandler<DeleteAssetRequest, DeleteAssetResponse> handler);

    /**
     * Deletes an inventory resource by identifier.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteInventoryResponse> deleteInventory(
            DeleteInventoryRequest request,
            com.oracle.bmc.responses.AsyncHandler<DeleteInventoryRequest, DeleteInventoryResponse>
                    handler);

    /**
     * Gets an asset by identifier.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetAssetResponse> getAsset(
            GetAssetRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetAssetRequest, GetAssetResponse> handler);

    /**
     * Gets an inventory by identifier.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetInventoryResponse> getInventory(
            GetInventoryRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetInventoryRequest, GetInventoryResponse>
                    handler);

    /**
     * Import resources in inventory.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ImportInventoryResponse> importInventory(
            ImportInventoryRequest request,
            com.oracle.bmc.responses.AsyncHandler<ImportInventoryRequest, ImportInventoryResponse>
                    handler);

    /**
     * Returns a list of assets.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListAssetsResponse> listAssets(
            ListAssetsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListAssetsRequest, ListAssetsResponse> handler);

    /**
     * List asset historical metrics.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListHistoricalMetricsResponse> listHistoricalMetrics(
            ListHistoricalMetricsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListHistoricalMetricsRequest, ListHistoricalMetricsResponse>
                    handler);

    /**
     * Returns a list of inventories.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListInventoriesResponse> listInventories(
            ListInventoriesRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListInventoriesRequest, ListInventoriesResponse>
                    handler);

    /**
     * Creates or updates all metrics related to the asset.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<SubmitHistoricalMetricsResponse> submitHistoricalMetrics(
            SubmitHistoricalMetricsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            SubmitHistoricalMetricsRequest, SubmitHistoricalMetricsResponse>
                    handler);

    /**
     * Updates the asset.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateAssetResponse> updateAsset(
            UpdateAssetRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateAssetRequest, UpdateAssetResponse> handler);

    /**
     * Updates an inventory.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateInventoryResponse> updateInventory(
            UpdateInventoryRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateInventoryRequest, UpdateInventoryResponse>
                    handler);
}
