/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.containerinstances.model;

/**
 * The volume based on configuration files received during container creation. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210415")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = ContainerConfigFileVolume.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "volumeType")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ContainerConfigFileVolume extends ContainerVolume {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        @com.fasterxml.jackson.annotation.JsonProperty("name")
        private String name;

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }
        /**
         * Contains string key value pairs which can be mounted as individual files inside the
         * container. The value needs to be base64 encoded. It is decoded to plain text before the
         * mount.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("configs")
        private java.util.List<ContainerConfigFile> configs;

        /**
         * Contains string key value pairs which can be mounted as individual files inside the
         * container. The value needs to be base64 encoded. It is decoded to plain text before the
         * mount.
         *
         * @param configs the value to set
         * @return this builder
         */
        public Builder configs(java.util.List<ContainerConfigFile> configs) {
            this.configs = configs;
            this.__explicitlySet__.add("configs");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ContainerConfigFileVolume build() {
            ContainerConfigFileVolume model =
                    new ContainerConfigFileVolume(this.name, this.configs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ContainerConfigFileVolume model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("configs")) {
                this.configs(model.getConfigs());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ContainerConfigFileVolume(String name, java.util.List<ContainerConfigFile> configs) {
        super(name);
        this.configs = configs;
    }

    /**
     * Contains string key value pairs which can be mounted as individual files inside the
     * container. The value needs to be base64 encoded. It is decoded to plain text before the
     * mount.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("configs")
    private final java.util.List<ContainerConfigFile> configs;

    /**
     * Contains string key value pairs which can be mounted as individual files inside the
     * container. The value needs to be base64 encoded. It is decoded to plain text before the
     * mount.
     *
     * @return the value
     */
    public java.util.List<ContainerConfigFile> getConfigs() {
        return configs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ContainerConfigFileVolume(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", configs=").append(String.valueOf(this.configs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerConfigFileVolume)) {
            return false;
        }

        ContainerConfigFileVolume other = (ContainerConfigFileVolume) o;
        return java.util.Objects.equals(this.configs, other.configs) && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.configs == null ? 43 : this.configs.hashCode());
        return result;
    }
}
