/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.core.model;

/**
 * The details for updating the instance source. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "sourceType",
        defaultImpl = UpdateInstanceSourceDetails.class)
@com.fasterxml.jackson.annotation.JsonSubTypes({
    @com.fasterxml.jackson.annotation.JsonSubTypes.Type(
            value = UpdateInstanceSourceViaBootVolumeDetails.class,
            name = "bootVolume"),
    @com.fasterxml.jackson.annotation.JsonSubTypes.Type(
            value = UpdateInstanceSourceViaImageDetails.class,
            name = "image")
})
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public class UpdateInstanceSourceDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"isPreserveBootVolumeEnabled"})
    protected UpdateInstanceSourceDetails(Boolean isPreserveBootVolumeEnabled) {
        super();
        this.isPreserveBootVolumeEnabled = isPreserveBootVolumeEnabled;
    }

    /**
     * Whether to preserve the boot volume that was previously attached to the instance after a
     * successful replacement of that boot volume.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isPreserveBootVolumeEnabled")
    private final Boolean isPreserveBootVolumeEnabled;

    /**
     * Whether to preserve the boot volume that was previously attached to the instance after a
     * successful replacement of that boot volume.
     *
     * @return the value
     */
    public Boolean getIsPreserveBootVolumeEnabled() {
        return isPreserveBootVolumeEnabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("UpdateInstanceSourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isPreserveBootVolumeEnabled=")
                .append(String.valueOf(this.isPreserveBootVolumeEnabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateInstanceSourceDetails)) {
            return false;
        }

        UpdateInstanceSourceDetails other = (UpdateInstanceSourceDetails) o;
        return java.util.Objects.equals(
                        this.isPreserveBootVolumeEnabled, other.isPreserveBootVolumeEnabled)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.isPreserveBootVolumeEnabled == null
                                ? 43
                                : this.isPreserveBootVolumeEnabled.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
