/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.databasemigration.model;

/**
 * Parameters to specify to resume a Migration Job. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20230518")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ResumeJobDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class ResumeJobDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"waitAfter"})
    public ResumeJobDetails(OdmsJobPhases waitAfter) {
        super();
        this.waitAfter = waitAfter;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Name of a migration phase. The Job will wait after executing this phase until Resume Job
         * endpoint is called again.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("waitAfter")
        private OdmsJobPhases waitAfter;

        /**
         * Name of a migration phase. The Job will wait after executing this phase until Resume Job
         * endpoint is called again.
         *
         * @param waitAfter the value to set
         * @return this builder
         */
        public Builder waitAfter(OdmsJobPhases waitAfter) {
            this.waitAfter = waitAfter;
            this.__explicitlySet__.add("waitAfter");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public ResumeJobDetails build() {
            ResumeJobDetails model = new ResumeJobDetails(this.waitAfter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(ResumeJobDetails model) {
            if (model.wasPropertyExplicitlySet("waitAfter")) {
                this.waitAfter(model.getWaitAfter());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Name of a migration phase. The Job will wait after executing this phase until Resume Job
     * endpoint is called again.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("waitAfter")
    private final OdmsJobPhases waitAfter;

    /**
     * Name of a migration phase. The Job will wait after executing this phase until Resume Job
     * endpoint is called again.
     *
     * @return the value
     */
    public OdmsJobPhases getWaitAfter() {
        return waitAfter;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("ResumeJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("waitAfter=").append(String.valueOf(this.waitAfter));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResumeJobDetails)) {
            return false;
        }

        ResumeJobDetails other = (ResumeJobDetails) o;
        return java.util.Objects.equals(this.waitAfter, other.waitAfter) && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.waitAfter == null ? 43 : this.waitAfter.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
