/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.devops.model;

/**
 * Specifies the Artifact Registry source details. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210630")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = GenericDeployArtifactSource.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "deployArtifactSourceType")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class GenericDeployArtifactSource extends DeployArtifactSource {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The OCID of a repository. */
        @com.fasterxml.jackson.annotation.JsonProperty("repositoryId")
        private String repositoryId;

        /**
         * The OCID of a repository.
         *
         * @param repositoryId the value to set
         * @return this builder
         */
        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }
        /** Specifies the artifact path in the repository. */
        @com.fasterxml.jackson.annotation.JsonProperty("deployArtifactPath")
        private String deployArtifactPath;

        /**
         * Specifies the artifact path in the repository.
         *
         * @param deployArtifactPath the value to set
         * @return this builder
         */
        public Builder deployArtifactPath(String deployArtifactPath) {
            this.deployArtifactPath = deployArtifactPath;
            this.__explicitlySet__.add("deployArtifactPath");
            return this;
        }
        /**
         * Users can set this as a placeholder value that refers to a pipeline parameter, for
         * example, ${appVersion}.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("deployArtifactVersion")
        private String deployArtifactVersion;

        /**
         * Users can set this as a placeholder value that refers to a pipeline parameter, for
         * example, ${appVersion}.
         *
         * @param deployArtifactVersion the value to set
         * @return this builder
         */
        public Builder deployArtifactVersion(String deployArtifactVersion) {
            this.deployArtifactVersion = deployArtifactVersion;
            this.__explicitlySet__.add("deployArtifactVersion");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public GenericDeployArtifactSource build() {
            GenericDeployArtifactSource model =
                    new GenericDeployArtifactSource(
                            this.repositoryId, this.deployArtifactPath, this.deployArtifactVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(GenericDeployArtifactSource model) {
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("deployArtifactPath")) {
                this.deployArtifactPath(model.getDeployArtifactPath());
            }
            if (model.wasPropertyExplicitlySet("deployArtifactVersion")) {
                this.deployArtifactVersion(model.getDeployArtifactVersion());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GenericDeployArtifactSource(
            String repositoryId, String deployArtifactPath, String deployArtifactVersion) {
        super();
        this.repositoryId = repositoryId;
        this.deployArtifactPath = deployArtifactPath;
        this.deployArtifactVersion = deployArtifactVersion;
    }

    /** The OCID of a repository. */
    @com.fasterxml.jackson.annotation.JsonProperty("repositoryId")
    private final String repositoryId;

    /**
     * The OCID of a repository.
     *
     * @return the value
     */
    public String getRepositoryId() {
        return repositoryId;
    }

    /** Specifies the artifact path in the repository. */
    @com.fasterxml.jackson.annotation.JsonProperty("deployArtifactPath")
    private final String deployArtifactPath;

    /**
     * Specifies the artifact path in the repository.
     *
     * @return the value
     */
    public String getDeployArtifactPath() {
        return deployArtifactPath;
    }

    /**
     * Users can set this as a placeholder value that refers to a pipeline parameter, for example,
     * ${appVersion}.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("deployArtifactVersion")
    private final String deployArtifactVersion;

    /**
     * Users can set this as a placeholder value that refers to a pipeline parameter, for example,
     * ${appVersion}.
     *
     * @return the value
     */
    public String getDeployArtifactVersion() {
        return deployArtifactVersion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("GenericDeployArtifactSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", deployArtifactPath=").append(String.valueOf(this.deployArtifactPath));
        sb.append(", deployArtifactVersion=").append(String.valueOf(this.deployArtifactVersion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericDeployArtifactSource)) {
            return false;
        }

        GenericDeployArtifactSource other = (GenericDeployArtifactSource) o;
        return java.util.Objects.equals(this.repositoryId, other.repositoryId)
                && java.util.Objects.equals(this.deployArtifactPath, other.deployArtifactPath)
                && java.util.Objects.equals(this.deployArtifactVersion, other.deployArtifactVersion)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result =
                (result * PRIME)
                        + (this.deployArtifactPath == null
                                ? 43
                                : this.deployArtifactPath.hashCode());
        result =
                (result * PRIME)
                        + (this.deployArtifactVersion == null
                                ? 43
                                : this.deployArtifactVersion.hashCode());
        return result;
    }
}
