/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.devops.model;

/**
 * Summary of vulnerability audit. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210630")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilityAuditSummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilityAuditSummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"vulnerabilityAuditId", "commitHash", "buildStageId"})
    public VulnerabilityAuditSummary(
            String vulnerabilityAuditId, String commitHash, String buildStageId) {
        super();
        this.vulnerabilityAuditId = vulnerabilityAuditId;
        this.commitHash = commitHash;
        this.buildStageId = buildStageId;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** The OCID of the vulnerability audit. */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityAuditId")
        private String vulnerabilityAuditId;

        /**
         * The OCID of the vulnerability audit.
         *
         * @param vulnerabilityAuditId the value to set
         * @return this builder
         */
        public Builder vulnerabilityAuditId(String vulnerabilityAuditId) {
            this.vulnerabilityAuditId = vulnerabilityAuditId;
            this.__explicitlySet__.add("vulnerabilityAuditId");
            return this;
        }
        /** Commit hash used while retrieving the pom file for vulnerabilityAudit. */
        @com.fasterxml.jackson.annotation.JsonProperty("commitHash")
        private String commitHash;

        /**
         * Commit hash used while retrieving the pom file for vulnerabilityAudit.
         *
         * @param commitHash the value to set
         * @return this builder
         */
        public Builder commitHash(String commitHash) {
            this.commitHash = commitHash;
            this.__explicitlySet__.add("commitHash");
            return this;
        }
        /** Build stage OCID where scan was configured. */
        @com.fasterxml.jackson.annotation.JsonProperty("buildStageId")
        private String buildStageId;

        /**
         * Build stage OCID where scan was configured.
         *
         * @param buildStageId the value to set
         * @return this builder
         */
        public Builder buildStageId(String buildStageId) {
            this.buildStageId = buildStageId;
            this.__explicitlySet__.add("buildStageId");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilityAuditSummary build() {
            VulnerabilityAuditSummary model =
                    new VulnerabilityAuditSummary(
                            this.vulnerabilityAuditId, this.commitHash, this.buildStageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilityAuditSummary model) {
            if (model.wasPropertyExplicitlySet("vulnerabilityAuditId")) {
                this.vulnerabilityAuditId(model.getVulnerabilityAuditId());
            }
            if (model.wasPropertyExplicitlySet("commitHash")) {
                this.commitHash(model.getCommitHash());
            }
            if (model.wasPropertyExplicitlySet("buildStageId")) {
                this.buildStageId(model.getBuildStageId());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** The OCID of the vulnerability audit. */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityAuditId")
    private final String vulnerabilityAuditId;

    /**
     * The OCID of the vulnerability audit.
     *
     * @return the value
     */
    public String getVulnerabilityAuditId() {
        return vulnerabilityAuditId;
    }

    /** Commit hash used while retrieving the pom file for vulnerabilityAudit. */
    @com.fasterxml.jackson.annotation.JsonProperty("commitHash")
    private final String commitHash;

    /**
     * Commit hash used while retrieving the pom file for vulnerabilityAudit.
     *
     * @return the value
     */
    public String getCommitHash() {
        return commitHash;
    }

    /** Build stage OCID where scan was configured. */
    @com.fasterxml.jackson.annotation.JsonProperty("buildStageId")
    private final String buildStageId;

    /**
     * Build stage OCID where scan was configured.
     *
     * @return the value
     */
    public String getBuildStageId() {
        return buildStageId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilityAuditSummary(");
        sb.append("super=").append(super.toString());
        sb.append("vulnerabilityAuditId=").append(String.valueOf(this.vulnerabilityAuditId));
        sb.append(", commitHash=").append(String.valueOf(this.commitHash));
        sb.append(", buildStageId=").append(String.valueOf(this.buildStageId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityAuditSummary)) {
            return false;
        }

        VulnerabilityAuditSummary other = (VulnerabilityAuditSummary) o;
        return java.util.Objects.equals(this.vulnerabilityAuditId, other.vulnerabilityAuditId)
                && java.util.Objects.equals(this.commitHash, other.commitHash)
                && java.util.Objects.equals(this.buildStageId, other.buildStageId)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.vulnerabilityAuditId == null
                                ? 43
                                : this.vulnerabilityAuditId.hashCode());
        result = (result * PRIME) + (this.commitHash == null ? 43 : this.commitHash.hashCode());
        result = (result * PRIME) + (this.buildStageId == null ? 43 : this.buildStageId.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
