/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.dts.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/dts/UpdateTransferDeviceExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use UpdateTransferDeviceRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 1.0.017")
public class UpdateTransferDeviceRequest
        extends com.oracle.bmc.requests.BmcRequest<
                com.oracle.bmc.dts.model.UpdateTransferDeviceDetails> {

    /** ID of the Transfer Job */
    private String id;

    /** ID of the Transfer Job */
    public String getId() {
        return id;
    }
    /** Label of the Transfer Device */
    private String transferDeviceLabel;

    /** Label of the Transfer Device */
    public String getTransferDeviceLabel() {
        return transferDeviceLabel;
    }
    /** fields to update */
    private com.oracle.bmc.dts.model.UpdateTransferDeviceDetails updateTransferDeviceDetails;

    /** fields to update */
    public com.oracle.bmc.dts.model.UpdateTransferDeviceDetails getUpdateTransferDeviceDetails() {
        return updateTransferDeviceDetails;
    }
    /**
     * The entity tag to match. Optional, if set, the update will be successful only if the object's
     * tag matches the tag specified in the request.
     */
    private String ifMatch;

    /**
     * The entity tag to match. Optional, if set, the update will be successful only if the object's
     * tag matches the tag specified in the request.
     */
    public String getIfMatch() {
        return ifMatch;
    }

    /**
     * Alternative accessor for the body parameter.
     *
     * @return body parameter
     */
    @Override
    @com.oracle.bmc.InternalSdk
    public com.oracle.bmc.dts.model.UpdateTransferDeviceDetails getBody$() {
        return updateTransferDeviceDetails;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    UpdateTransferDeviceRequest,
                    com.oracle.bmc.dts.model.UpdateTransferDeviceDetails> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** ID of the Transfer Job */
        private String id = null;

        /**
         * ID of the Transfer Job
         *
         * @param id the value to set
         * @return this builder instance
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /** Label of the Transfer Device */
        private String transferDeviceLabel = null;

        /**
         * Label of the Transfer Device
         *
         * @param transferDeviceLabel the value to set
         * @return this builder instance
         */
        public Builder transferDeviceLabel(String transferDeviceLabel) {
            this.transferDeviceLabel = transferDeviceLabel;
            return this;
        }

        /** fields to update */
        private com.oracle.bmc.dts.model.UpdateTransferDeviceDetails updateTransferDeviceDetails =
                null;

        /**
         * fields to update
         *
         * @param updateTransferDeviceDetails the value to set
         * @return this builder instance
         */
        public Builder updateTransferDeviceDetails(
                com.oracle.bmc.dts.model.UpdateTransferDeviceDetails updateTransferDeviceDetails) {
            this.updateTransferDeviceDetails = updateTransferDeviceDetails;
            return this;
        }

        /**
         * The entity tag to match. Optional, if set, the update will be successful only if the
         * object's tag matches the tag specified in the request.
         */
        private String ifMatch = null;

        /**
         * The entity tag to match. Optional, if set, the update will be successful only if the
         * object's tag matches the tag specified in the request.
         *
         * @param ifMatch the value to set
         * @return this builder instance
         */
        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(UpdateTransferDeviceRequest o) {
            id(o.getId());
            transferDeviceLabel(o.getTransferDeviceLabel());
            updateTransferDeviceDetails(o.getUpdateTransferDeviceDetails());
            ifMatch(o.getIfMatch());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of UpdateTransferDeviceRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of UpdateTransferDeviceRequest
         */
        public UpdateTransferDeviceRequest build() {
            UpdateTransferDeviceRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Alternative setter for the body parameter.
         *
         * @param body the body parameter
         * @return this builder instance
         */
        @com.oracle.bmc.InternalSdk
        public Builder body$(com.oracle.bmc.dts.model.UpdateTransferDeviceDetails body) {
            updateTransferDeviceDetails(body);
            return this;
        }

        /**
         * Build the instance of UpdateTransferDeviceRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of UpdateTransferDeviceRequest
         */
        public UpdateTransferDeviceRequest buildWithoutInvocationCallback() {
            UpdateTransferDeviceRequest request = new UpdateTransferDeviceRequest();
            request.id = id;
            request.transferDeviceLabel = transferDeviceLabel;
            request.updateTransferDeviceDetails = updateTransferDeviceDetails;
            request.ifMatch = ifMatch;
            return request;
            // new UpdateTransferDeviceRequest(id, transferDeviceLabel, updateTransferDeviceDetails,
            // ifMatch);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .id(id)
                .transferDeviceLabel(transferDeviceLabel)
                .updateTransferDeviceDetails(updateTransferDeviceDetails)
                .ifMatch(ifMatch);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",transferDeviceLabel=").append(String.valueOf(this.transferDeviceLabel));
        sb.append(",updateTransferDeviceDetails=")
                .append(String.valueOf(this.updateTransferDeviceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTransferDeviceRequest)) {
            return false;
        }

        UpdateTransferDeviceRequest other = (UpdateTransferDeviceRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.transferDeviceLabel, other.transferDeviceLabel)
                && java.util.Objects.equals(
                        this.updateTransferDeviceDetails, other.updateTransferDeviceDetails)
                && java.util.Objects.equals(this.ifMatch, other.ifMatch);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result =
                (result * PRIME)
                        + (this.transferDeviceLabel == null
                                ? 43
                                : this.transferDeviceLabel.hashCode());
        result =
                (result * PRIME)
                        + (this.updateTransferDeviceDetails == null
                                ? 43
                                : this.updateTransferDeviceDetails.hashCode());
        result = (result * PRIME) + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }
}
