/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.oda.requests.*;
import com.oracle.bmc.oda.responses.*;

/**
 * Collection of helper methods to produce {@link com.oracle.bmc.waiter.Waiter}s for different
 * resources of Management.
 *
 * <p>The default configuration used is defined by {@link
 * com.oracle.bmc.waiter.Waiters.Waiters#DEFAULT_POLLING_WAITER}.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20190506")
public class ManagementWaiters {
    private final java.util.concurrent.ExecutorService executorService;
    private final Management client;

    public ManagementWaiters(
            java.util.concurrent.ExecutorService executorService, Management client) {
        this.executorService = executorService;
        this.client = client;
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetAuthenticationProviderRequest, GetAuthenticationProviderResponse>
            forAuthenticationProvider(
                    GetAuthenticationProviderRequest request,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forAuthenticationProvider(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetAuthenticationProviderRequest, GetAuthenticationProviderResponse>
            forAuthenticationProvider(
                    GetAuthenticationProviderRequest request,
                    com.oracle.bmc.oda.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forAuthenticationProvider(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetAuthenticationProviderRequest, GetAuthenticationProviderResponse>
            forAuthenticationProvider(
                    GetAuthenticationProviderRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forAuthenticationProvider(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for AuthenticationProvider.
    private com.oracle.bmc.waiter.Waiter<
                    GetAuthenticationProviderRequest, GetAuthenticationProviderResponse>
            forAuthenticationProvider(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetAuthenticationProviderRequest request,
                    final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetAuthenticationProviderRequest,
                                GetAuthenticationProviderResponse>() {
                            @Override
                            public GetAuthenticationProviderResponse apply(
                                    GetAuthenticationProviderRequest request) {
                                return client.getAuthenticationProvider(request);
                            }
                        },
                        new java.util.function.Predicate<GetAuthenticationProviderResponse>() {
                            @Override
                            public boolean test(GetAuthenticationProviderResponse response) {
                                return targetStatesSet.contains(
                                        response.getAuthenticationProvider().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetChannelRequest, GetChannelResponse> forChannel(
            GetChannelRequest request, com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forChannel(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetChannelRequest, GetChannelResponse> forChannel(
            GetChannelRequest request,
            com.oracle.bmc.oda.model.LifecycleState targetState,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forChannel(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetChannelRequest, GetChannelResponse> forChannel(
            GetChannelRequest request,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy,
            com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forChannel(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for Channel.
    private com.oracle.bmc.waiter.Waiter<GetChannelRequest, GetChannelResponse> forChannel(
            com.oracle.bmc.waiter.BmcGenericWaiter waiter,
            final GetChannelRequest request,
            final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<GetChannelRequest, GetChannelResponse>() {
                            @Override
                            public GetChannelResponse apply(GetChannelRequest request) {
                                return client.getChannel(request);
                            }
                        },
                        new java.util.function.Predicate<GetChannelResponse>() {
                            @Override
                            public boolean test(GetChannelResponse response) {
                                return targetStatesSet.contains(
                                        response.getChannel().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse>
            forDigitalAssistant(
                    GetDigitalAssistantRequest request,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forDigitalAssistant(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse>
            forDigitalAssistant(
                    GetDigitalAssistantRequest request,
                    com.oracle.bmc.oda.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forDigitalAssistant(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse>
            forDigitalAssistant(
                    GetDigitalAssistantRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forDigitalAssistant(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for DigitalAssistant.
    private com.oracle.bmc.waiter.Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse>
            forDigitalAssistant(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetDigitalAssistantRequest request,
                    final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetDigitalAssistantRequest, GetDigitalAssistantResponse>() {
                            @Override
                            public GetDigitalAssistantResponse apply(
                                    GetDigitalAssistantRequest request) {
                                return client.getDigitalAssistant(request);
                            }
                        },
                        new java.util.function.Predicate<GetDigitalAssistantResponse>() {
                            @Override
                            public boolean test(GetDigitalAssistantResponse response) {
                                return targetStatesSet.contains(
                                        response.getDigitalAssistant().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse>
            forDigitalAssistantParameter(
                    GetDigitalAssistantParameterRequest request,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forDigitalAssistantParameter(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse>
            forDigitalAssistantParameter(
                    GetDigitalAssistantParameterRequest request,
                    com.oracle.bmc.oda.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forDigitalAssistantParameter(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse>
            forDigitalAssistantParameter(
                    GetDigitalAssistantParameterRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forDigitalAssistantParameter(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for DigitalAssistantParameter.
    private com.oracle.bmc.waiter.Waiter<
                    GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse>
            forDigitalAssistantParameter(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetDigitalAssistantParameterRequest request,
                    final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetDigitalAssistantParameterRequest,
                                GetDigitalAssistantParameterResponse>() {
                            @Override
                            public GetDigitalAssistantParameterResponse apply(
                                    GetDigitalAssistantParameterRequest request) {
                                return client.getDigitalAssistantParameter(request);
                            }
                        },
                        new java.util.function.Predicate<GetDigitalAssistantParameterResponse>() {
                            @Override
                            public boolean test(GetDigitalAssistantParameterResponse response) {
                                return targetStatesSet.contains(
                                        response.getDigitalAssistantParameter()
                                                .getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetStates the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetOdaPrivateEndpointRequest, GetOdaPrivateEndpointResponse>
            forOdaPrivateEndpoint(
                    GetOdaPrivateEndpointRequest request,
                    com.oracle.bmc.oda.model.OdaPrivateEndpoint.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forOdaPrivateEndpoint(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetOdaPrivateEndpointRequest, GetOdaPrivateEndpointResponse>
            forOdaPrivateEndpoint(
                    GetOdaPrivateEndpointRequest request,
                    com.oracle.bmc.oda.model.OdaPrivateEndpoint.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forOdaPrivateEndpoint(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetOdaPrivateEndpointRequest, GetOdaPrivateEndpointResponse>
            forOdaPrivateEndpoint(
                    GetOdaPrivateEndpointRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.OdaPrivateEndpoint.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one target state must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null target states are not permitted");

        return forOdaPrivateEndpoint(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for OdaPrivateEndpoint.
    private com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointRequest, GetOdaPrivateEndpointResponse>
            forOdaPrivateEndpoint(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetOdaPrivateEndpointRequest request,
                    final com.oracle.bmc.oda.model.OdaPrivateEndpoint.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.OdaPrivateEndpoint.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetOdaPrivateEndpointRequest, GetOdaPrivateEndpointResponse>() {
                            @Override
                            public GetOdaPrivateEndpointResponse apply(
                                    GetOdaPrivateEndpointRequest request) {
                                return client.getOdaPrivateEndpoint(request);
                            }
                        },
                        new java.util.function.Predicate<GetOdaPrivateEndpointResponse>() {
                            @Override
                            public boolean test(GetOdaPrivateEndpointResponse response) {
                                return targetStatesSet.contains(
                                        response.getOdaPrivateEndpoint().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.oda.model.OdaPrivateEndpoint.LifecycleState
                                        .Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetStates the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointAttachmentRequest, GetOdaPrivateEndpointAttachmentResponse>
            forOdaPrivateEndpointAttachment(
                    GetOdaPrivateEndpointAttachmentRequest request,
                    com.oracle.bmc.oda.model.OdaPrivateEndpointAttachment.LifecycleState...
                            targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forOdaPrivateEndpointAttachment(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointAttachmentRequest, GetOdaPrivateEndpointAttachmentResponse>
            forOdaPrivateEndpointAttachment(
                    GetOdaPrivateEndpointAttachmentRequest request,
                    com.oracle.bmc.oda.model.OdaPrivateEndpointAttachment.LifecycleState
                            targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forOdaPrivateEndpointAttachment(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointAttachmentRequest, GetOdaPrivateEndpointAttachmentResponse>
            forOdaPrivateEndpointAttachment(
                    GetOdaPrivateEndpointAttachmentRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.OdaPrivateEndpointAttachment.LifecycleState...
                            targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one target state must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null target states are not permitted");

        return forOdaPrivateEndpointAttachment(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for OdaPrivateEndpointAttachment.
    private com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointAttachmentRequest, GetOdaPrivateEndpointAttachmentResponse>
            forOdaPrivateEndpointAttachment(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetOdaPrivateEndpointAttachmentRequest request,
                    final com.oracle.bmc.oda.model.OdaPrivateEndpointAttachment.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.OdaPrivateEndpointAttachment.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetOdaPrivateEndpointAttachmentRequest,
                                GetOdaPrivateEndpointAttachmentResponse>() {
                            @Override
                            public GetOdaPrivateEndpointAttachmentResponse apply(
                                    GetOdaPrivateEndpointAttachmentRequest request) {
                                return client.getOdaPrivateEndpointAttachment(request);
                            }
                        },
                        new java.util.function.Predicate<
                                GetOdaPrivateEndpointAttachmentResponse>() {
                            @Override
                            public boolean test(GetOdaPrivateEndpointAttachmentResponse response) {
                                return targetStatesSet.contains(
                                        response.getOdaPrivateEndpointAttachment()
                                                .getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.oda.model.OdaPrivateEndpointAttachment.LifecycleState
                                        .Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetStates the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointScanProxyRequest, GetOdaPrivateEndpointScanProxyResponse>
            forOdaPrivateEndpointScanProxy(
                    GetOdaPrivateEndpointScanProxyRequest request,
                    com.oracle.bmc.oda.model.OdaPrivateEndpointScanProxy.LifecycleState...
                            targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forOdaPrivateEndpointScanProxy(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointScanProxyRequest, GetOdaPrivateEndpointScanProxyResponse>
            forOdaPrivateEndpointScanProxy(
                    GetOdaPrivateEndpointScanProxyRequest request,
                    com.oracle.bmc.oda.model.OdaPrivateEndpointScanProxy.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forOdaPrivateEndpointScanProxy(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointScanProxyRequest, GetOdaPrivateEndpointScanProxyResponse>
            forOdaPrivateEndpointScanProxy(
                    GetOdaPrivateEndpointScanProxyRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.OdaPrivateEndpointScanProxy.LifecycleState...
                            targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one target state must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null target states are not permitted");

        return forOdaPrivateEndpointScanProxy(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for OdaPrivateEndpointScanProxy.
    private com.oracle.bmc.waiter.Waiter<
                    GetOdaPrivateEndpointScanProxyRequest, GetOdaPrivateEndpointScanProxyResponse>
            forOdaPrivateEndpointScanProxy(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetOdaPrivateEndpointScanProxyRequest request,
                    final com.oracle.bmc.oda.model.OdaPrivateEndpointScanProxy.LifecycleState...
                            targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.OdaPrivateEndpointScanProxy.LifecycleState>
                targetStatesSet = new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetOdaPrivateEndpointScanProxyRequest,
                                GetOdaPrivateEndpointScanProxyResponse>() {
                            @Override
                            public GetOdaPrivateEndpointScanProxyResponse apply(
                                    GetOdaPrivateEndpointScanProxyRequest request) {
                                return client.getOdaPrivateEndpointScanProxy(request);
                            }
                        },
                        new java.util.function.Predicate<GetOdaPrivateEndpointScanProxyResponse>() {
                            @Override
                            public boolean test(GetOdaPrivateEndpointScanProxyResponse response) {
                                return targetStatesSet.contains(
                                        response.getOdaPrivateEndpointScanProxy()
                                                .getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(
                                com.oracle.bmc.oda.model.OdaPrivateEndpointScanProxy.LifecycleState
                                        .Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetSkillRequest, GetSkillResponse> forSkill(
            GetSkillRequest request, com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forSkill(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetSkillRequest, GetSkillResponse> forSkill(
            GetSkillRequest request,
            com.oracle.bmc.oda.model.LifecycleState targetState,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forSkill(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetSkillRequest, GetSkillResponse> forSkill(
            GetSkillRequest request,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy,
            com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forSkill(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for Skill.
    private com.oracle.bmc.waiter.Waiter<GetSkillRequest, GetSkillResponse> forSkill(
            com.oracle.bmc.waiter.BmcGenericWaiter waiter,
            final GetSkillRequest request,
            final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<GetSkillRequest, GetSkillResponse>() {
                            @Override
                            public GetSkillResponse apply(GetSkillRequest request) {
                                return client.getSkill(request);
                            }
                        },
                        new java.util.function.Predicate<GetSkillResponse>() {
                            @Override
                            public boolean test(GetSkillResponse response) {
                                return targetStatesSet.contains(
                                        response.getSkill().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetSkillParameterRequest, GetSkillParameterResponse>
            forSkillParameter(
                    GetSkillParameterRequest request,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forSkillParameter(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetSkillParameterRequest, GetSkillParameterResponse>
            forSkillParameter(
                    GetSkillParameterRequest request,
                    com.oracle.bmc.oda.model.LifecycleState targetState,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forSkillParameter(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetSkillParameterRequest, GetSkillParameterResponse>
            forSkillParameter(
                    GetSkillParameterRequest request,
                    com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
                    com.oracle.bmc.waiter.DelayStrategy delayStrategy,
                    com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forSkillParameter(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for SkillParameter.
    private com.oracle.bmc.waiter.Waiter<GetSkillParameterRequest, GetSkillParameterResponse>
            forSkillParameter(
                    com.oracle.bmc.waiter.BmcGenericWaiter waiter,
                    final GetSkillParameterRequest request,
                    final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetSkillParameterRequest, GetSkillParameterResponse>() {
                            @Override
                            public GetSkillParameterResponse apply(
                                    GetSkillParameterRequest request) {
                                return client.getSkillParameter(request);
                            }
                        },
                        new java.util.function.Predicate<GetSkillParameterResponse>() {
                            @Override
                            public boolean test(GetSkillParameterResponse response) {
                                return targetStatesSet.contains(
                                        response.getSkillParameter().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the default configuration.
     *
     * @param request the request to send
     * @param targetState the desired states to wait for. If multiple states are provided then the
     *     waiter will return once the resource reaches any of the provided states
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(
            GetTranslatorRequest request, com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forTranslator(
                com.oracle.bmc.waiter.Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param targetState the desired state to wait for
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @return a new {@code com.oracle.bmc.waiter.Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(
            GetTranslatorRequest request,
            com.oracle.bmc.oda.model.LifecycleState targetState,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy) {
        com.oracle.bmc.util.internal.Validate.notNull(
                targetState, "The targetState cannot be null");

        return forTranslator(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetState);
    }

    /**
     * Creates a new {@link com.oracle.bmc.waiter.Waiter} using the provided configuration.
     *
     * @param request the request to send
     * @param terminationStrategy the {@link com.oracle.bmc.waiter.TerminationStrategy} to use
     * @param delayStrategy the {@link com.oracle.bmc.waiter.DelayStrategy} to use
     * @param targetStates the desired states to wait for. The waiter will return once the resource
     *     reaches any of the provided states
     * @return a new {@code Waiter} instance
     */
    public com.oracle.bmc.waiter.Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(
            GetTranslatorRequest request,
            com.oracle.bmc.waiter.TerminationStrategy terminationStrategy,
            com.oracle.bmc.waiter.DelayStrategy delayStrategy,
            com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        com.oracle.bmc.util.internal.Validate.notEmpty(
                targetStates, "At least one targetState must be provided");
        com.oracle.bmc.util.internal.Validate.noNullElements(
                targetStates, "Null targetState values are not permitted");

        return forTranslator(
                com.oracle.bmc.waiter.Waiters.newWaiter(terminationStrategy, delayStrategy),
                request,
                targetStates);
    }

    // Helper method to create a new Waiter for Translator.
    private com.oracle.bmc.waiter.Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(
            com.oracle.bmc.waiter.BmcGenericWaiter waiter,
            final GetTranslatorRequest request,
            final com.oracle.bmc.oda.model.LifecycleState... targetStates) {
        final java.util.Set<com.oracle.bmc.oda.model.LifecycleState> targetStatesSet =
                new java.util.HashSet<>(java.util.Arrays.asList(targetStates));

        return new com.oracle.bmc.waiter.internal.SimpleWaiterImpl<>(
                executorService,
                waiter.toCallable(
                        () -> request,
                        new java.util.function.Function<
                                GetTranslatorRequest, GetTranslatorResponse>() {
                            @Override
                            public GetTranslatorResponse apply(GetTranslatorRequest request) {
                                return client.getTranslator(request);
                            }
                        },
                        new java.util.function.Predicate<GetTranslatorResponse>() {
                            @Override
                            public boolean test(GetTranslatorResponse response) {
                                return targetStatesSet.contains(
                                        response.getTranslator().getLifecycleState());
                            }
                        },
                        targetStatesSet.contains(com.oracle.bmc.oda.model.LifecycleState.Deleted)),
                request);
    }
}
