/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.opsi.model;

/**
 * Logical grouping used for Ops Insights Enterprise Manager Bridge operations. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200630")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = EnterpriseManagerBridges.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class EnterpriseManagerBridges
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"enterpriseManagerBridges"})
    public EnterpriseManagerBridges(Object enterpriseManagerBridges) {
        super();
        this.enterpriseManagerBridges = enterpriseManagerBridges;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Enterprise Manager Bridge Object. */
        @com.fasterxml.jackson.annotation.JsonProperty("enterpriseManagerBridges")
        private Object enterpriseManagerBridges;

        /**
         * Enterprise Manager Bridge Object.
         *
         * @param enterpriseManagerBridges the value to set
         * @return this builder
         */
        public Builder enterpriseManagerBridges(Object enterpriseManagerBridges) {
            this.enterpriseManagerBridges = enterpriseManagerBridges;
            this.__explicitlySet__.add("enterpriseManagerBridges");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public EnterpriseManagerBridges build() {
            EnterpriseManagerBridges model =
                    new EnterpriseManagerBridges(this.enterpriseManagerBridges);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(EnterpriseManagerBridges model) {
            if (model.wasPropertyExplicitlySet("enterpriseManagerBridges")) {
                this.enterpriseManagerBridges(model.getEnterpriseManagerBridges());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Enterprise Manager Bridge Object. */
    @com.fasterxml.jackson.annotation.JsonProperty("enterpriseManagerBridges")
    private final Object enterpriseManagerBridges;

    /**
     * Enterprise Manager Bridge Object.
     *
     * @return the value
     */
    public Object getEnterpriseManagerBridges() {
        return enterpriseManagerBridges;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("EnterpriseManagerBridges(");
        sb.append("super=").append(super.toString());
        sb.append("enterpriseManagerBridges=")
                .append(String.valueOf(this.enterpriseManagerBridges));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnterpriseManagerBridges)) {
            return false;
        }

        EnterpriseManagerBridges other = (EnterpriseManagerBridges) o;
        return java.util.Objects.equals(
                        this.enterpriseManagerBridges, other.enterpriseManagerBridges)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.enterpriseManagerBridges == null
                                ? 43
                                : this.enterpriseManagerBridges.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
