/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.opsi.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/opsi/ListImportableEnterpriseManagerEntitiesExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListImportableEnterpriseManagerEntitiesRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200630")
public class ListImportableEnterpriseManagerEntitiesRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** Unique Enterprise Manager bridge identifier */
    private String enterpriseManagerBridgeId;

    /** Unique Enterprise Manager bridge identifier */
    public String getEnterpriseManagerBridgeId() {
        return enterpriseManagerBridgeId;
    }
    /**
     * For list pagination. The maximum number of results per page, or items to return in a
     * paginated "List" call. For important details about how pagination works, see [List
     * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine). Example:
     * {@code 50}
     */
    private Integer limit;

    /**
     * For list pagination. The maximum number of results per page, or items to return in a
     * paginated "List" call. For important details about how pagination works, see [List
     * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine). Example:
     * {@code 50}
     */
    public Integer getLimit() {
        return limit;
    }
    /**
     * For list pagination. The value of the {@code opc-next-page} response header from the previous
     * "List" call. For important details about how pagination works, see [List
     * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
     */
    private String page;

    /**
     * For list pagination. The value of the {@code opc-next-page} response header from the previous
     * "List" call. For important details about how pagination works, see [List
     * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
     */
    public String getPage() {
        return page;
    }
    /**
     * Filter by one or more Enterprise Manager entity types. Currently, the supported types are
     * "oracle_pdb", "oracle_database", "host", "oracle_dbmachine", "oracle_exa_cloud_service", and
     * "oracle_oci_exadata_cloud_service". If this parameter is not specified, targets of all
     * supported entity types are returned by default.
     */
    private java.util.List<String> enterpriseManagerEntityType;

    /**
     * Filter by one or more Enterprise Manager entity types. Currently, the supported types are
     * "oracle_pdb", "oracle_database", "host", "oracle_dbmachine", "oracle_exa_cloud_service", and
     * "oracle_oci_exadata_cloud_service". If this parameter is not specified, targets of all
     * supported entity types are returned by default.
     */
    public java.util.List<String> getEnterpriseManagerEntityType() {
        return enterpriseManagerEntityType;
    }
    /**
     * Used in combination with enterpriseManagerParentEntityIdentifier to return the members of a
     * particular Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
     * enterpriseManagerParentEntityIdentifier must be specified to identify a particular Enterprise
     * Manager parent entity.
     */
    private String enterpriseManagerIdentifier;

    /**
     * Used in combination with enterpriseManagerParentEntityIdentifier to return the members of a
     * particular Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
     * enterpriseManagerParentEntityIdentifier must be specified to identify a particular Enterprise
     * Manager parent entity.
     */
    public String getEnterpriseManagerIdentifier() {
        return enterpriseManagerIdentifier;
    }
    /**
     * Used in combination with enterpriseManagerIdentifier to return the members of a particular
     * Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
     * enterpriseManagerParentEntityIdentifier must be specified to identify a particular Enterprise
     * Manager parent entity.
     */
    private String enterpriseManagerParentEntityIdentifier;

    /**
     * Used in combination with enterpriseManagerIdentifier to return the members of a particular
     * Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
     * enterpriseManagerParentEntityIdentifier must be specified to identify a particular Enterprise
     * Manager parent entity.
     */
    public String getEnterpriseManagerParentEntityIdentifier() {
        return enterpriseManagerParentEntityIdentifier;
    }
    /**
     * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
     * particular request, please provide the request ID.
     */
    private String opcRequestId;

    /**
     * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
     * particular request, please provide the request ID.
     */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListImportableEnterpriseManagerEntitiesRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** Unique Enterprise Manager bridge identifier */
        private String enterpriseManagerBridgeId = null;

        /**
         * Unique Enterprise Manager bridge identifier
         *
         * @param enterpriseManagerBridgeId the value to set
         * @return this builder instance
         */
        public Builder enterpriseManagerBridgeId(String enterpriseManagerBridgeId) {
            this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            return this;
        }

        /**
         * For list pagination. The maximum number of results per page, or items to return in a
         * paginated "List" call. For important details about how pagination works, see [List
         * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
         * Example: {@code 50}
         */
        private Integer limit = null;

        /**
         * For list pagination. The maximum number of results per page, or items to return in a
         * paginated "List" call. For important details about how pagination works, see [List
         * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
         * Example: {@code 50}
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * For list pagination. The value of the {@code opc-next-page} response header from the
         * previous "List" call. For important details about how pagination works, see [List
         * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
         */
        private String page = null;

        /**
         * For list pagination. The value of the {@code opc-next-page} response header from the
         * previous "List" call. For important details about how pagination works, see [List
         * Pagination](https://docs.cloud.oracle.com/Content/API/Concepts/usingapi.htm#nine).
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /**
         * Filter by one or more Enterprise Manager entity types. Currently, the supported types are
         * "oracle_pdb", "oracle_database", "host", "oracle_dbmachine", "oracle_exa_cloud_service",
         * and "oracle_oci_exadata_cloud_service". If this parameter is not specified, targets of
         * all supported entity types are returned by default.
         */
        private java.util.List<String> enterpriseManagerEntityType = null;

        /**
         * Filter by one or more Enterprise Manager entity types. Currently, the supported types are
         * "oracle_pdb", "oracle_database", "host", "oracle_dbmachine", "oracle_exa_cloud_service",
         * and "oracle_oci_exadata_cloud_service". If this parameter is not specified, targets of
         * all supported entity types are returned by default.
         *
         * @param enterpriseManagerEntityType the value to set
         * @return this builder instance
         */
        public Builder enterpriseManagerEntityType(
                java.util.List<String> enterpriseManagerEntityType) {
            this.enterpriseManagerEntityType = enterpriseManagerEntityType;
            return this;
        }

        /**
         * Singular setter. Filter by one or more Enterprise Manager entity types. Currently, the
         * supported types are "oracle_pdb", "oracle_database", "host", "oracle_dbmachine",
         * "oracle_exa_cloud_service", and "oracle_oci_exadata_cloud_service". If this parameter is
         * not specified, targets of all supported entity types are returned by default.
         *
         * @param singularValue the singular value to set
         * @return this builder instance
         */
        public Builder enterpriseManagerEntityType(String singularValue) {
            return this.enterpriseManagerEntityType(java.util.Arrays.asList(singularValue));
        }

        /**
         * Used in combination with enterpriseManagerParentEntityIdentifier to return the members of
         * a particular Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
         * enterpriseManagerParentEntityIdentifier must be specified to identify a particular
         * Enterprise Manager parent entity.
         */
        private String enterpriseManagerIdentifier = null;

        /**
         * Used in combination with enterpriseManagerParentEntityIdentifier to return the members of
         * a particular Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
         * enterpriseManagerParentEntityIdentifier must be specified to identify a particular
         * Enterprise Manager parent entity.
         *
         * @param enterpriseManagerIdentifier the value to set
         * @return this builder instance
         */
        public Builder enterpriseManagerIdentifier(String enterpriseManagerIdentifier) {
            this.enterpriseManagerIdentifier = enterpriseManagerIdentifier;
            return this;
        }

        /**
         * Used in combination with enterpriseManagerIdentifier to return the members of a
         * particular Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
         * enterpriseManagerParentEntityIdentifier must be specified to identify a particular
         * Enterprise Manager parent entity.
         */
        private String enterpriseManagerParentEntityIdentifier = null;

        /**
         * Used in combination with enterpriseManagerIdentifier to return the members of a
         * particular Enterprise Manager parent entity. Both enterpriseManagerIdentifier and
         * enterpriseManagerParentEntityIdentifier must be specified to identify a particular
         * Enterprise Manager parent entity.
         *
         * @param enterpriseManagerParentEntityIdentifier the value to set
         * @return this builder instance
         */
        public Builder enterpriseManagerParentEntityIdentifier(
                String enterpriseManagerParentEntityIdentifier) {
            this.enterpriseManagerParentEntityIdentifier = enterpriseManagerParentEntityIdentifier;
            return this;
        }

        /**
         * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
         * particular request, please provide the request ID.
         */
        private String opcRequestId = null;

        /**
         * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
         * particular request, please provide the request ID.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListImportableEnterpriseManagerEntitiesRequest o) {
            enterpriseManagerBridgeId(o.getEnterpriseManagerBridgeId());
            limit(o.getLimit());
            page(o.getPage());
            enterpriseManagerEntityType(o.getEnterpriseManagerEntityType());
            enterpriseManagerIdentifier(o.getEnterpriseManagerIdentifier());
            enterpriseManagerParentEntityIdentifier(o.getEnterpriseManagerParentEntityIdentifier());
            opcRequestId(o.getOpcRequestId());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListImportableEnterpriseManagerEntitiesRequest as configured by
         * this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListImportableEnterpriseManagerEntitiesRequest
         */
        public ListImportableEnterpriseManagerEntitiesRequest build() {
            ListImportableEnterpriseManagerEntitiesRequest request =
                    buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListImportableEnterpriseManagerEntitiesRequest as configured by
         * this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListImportableEnterpriseManagerEntitiesRequest
         */
        public ListImportableEnterpriseManagerEntitiesRequest buildWithoutInvocationCallback() {
            ListImportableEnterpriseManagerEntitiesRequest request =
                    new ListImportableEnterpriseManagerEntitiesRequest();
            request.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            request.limit = limit;
            request.page = page;
            request.enterpriseManagerEntityType = enterpriseManagerEntityType;
            request.enterpriseManagerIdentifier = enterpriseManagerIdentifier;
            request.enterpriseManagerParentEntityIdentifier =
                    enterpriseManagerParentEntityIdentifier;
            request.opcRequestId = opcRequestId;
            return request;
            // new ListImportableEnterpriseManagerEntitiesRequest(enterpriseManagerBridgeId, limit,
            // page, enterpriseManagerEntityType, enterpriseManagerIdentifier,
            // enterpriseManagerParentEntityIdentifier, opcRequestId);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .enterpriseManagerBridgeId(enterpriseManagerBridgeId)
                .limit(limit)
                .page(page)
                .enterpriseManagerEntityType(enterpriseManagerEntityType)
                .enterpriseManagerIdentifier(enterpriseManagerIdentifier)
                .enterpriseManagerParentEntityIdentifier(enterpriseManagerParentEntityIdentifier)
                .opcRequestId(opcRequestId);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",enterpriseManagerBridgeId=")
                .append(String.valueOf(this.enterpriseManagerBridgeId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",enterpriseManagerEntityType=")
                .append(String.valueOf(this.enterpriseManagerEntityType));
        sb.append(",enterpriseManagerIdentifier=")
                .append(String.valueOf(this.enterpriseManagerIdentifier));
        sb.append(",enterpriseManagerParentEntityIdentifier=")
                .append(String.valueOf(this.enterpriseManagerParentEntityIdentifier));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListImportableEnterpriseManagerEntitiesRequest)) {
            return false;
        }

        ListImportableEnterpriseManagerEntitiesRequest other =
                (ListImportableEnterpriseManagerEntitiesRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(
                        this.enterpriseManagerBridgeId, other.enterpriseManagerBridgeId)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(
                        this.enterpriseManagerEntityType, other.enterpriseManagerEntityType)
                && java.util.Objects.equals(
                        this.enterpriseManagerIdentifier, other.enterpriseManagerIdentifier)
                && java.util.Objects.equals(
                        this.enterpriseManagerParentEntityIdentifier,
                        other.enterpriseManagerParentEntityIdentifier)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.enterpriseManagerBridgeId == null
                                ? 43
                                : this.enterpriseManagerBridgeId.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result =
                (result * PRIME)
                        + (this.enterpriseManagerEntityType == null
                                ? 43
                                : this.enterpriseManagerEntityType.hashCode());
        result =
                (result * PRIME)
                        + (this.enterpriseManagerIdentifier == null
                                ? 43
                                : this.enterpriseManagerIdentifier.hashCode());
        result =
                (result * PRIME)
                        + (this.enterpriseManagerParentEntityIdentifier == null
                                ? 43
                                : this.enterpriseManagerParentEntityIdentifier.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }
}
