/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.usageapi.requests;

import com.oracle.bmc.usageapi.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/latest/usageapi/GetEmailRecipientsGroupExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * GetEmailRecipientsGroupRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200107")
public class GetEmailRecipientsGroupRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** The email recipient group OCID. */
    private String emailRecipientsGroupId;

    /** The email recipient group OCID. */
    public String getEmailRecipientsGroupId() {
        return emailRecipientsGroupId;
    }
    /** The UsageStatement Subscription unique OCID. */
    private String subscriptionId;

    /** The UsageStatement Subscription unique OCID. */
    public String getSubscriptionId() {
        return subscriptionId;
    }
    /** The compartment ID in which to list resources. */
    private String compartmentId;

    /** The compartment ID in which to list resources. */
    public String getCompartmentId() {
        return compartmentId;
    }
    /**
     * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
     * particular request, please provide the request ID.
     */
    private String opcRequestId;

    /**
     * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
     * particular request, please provide the request ID.
     */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    GetEmailRecipientsGroupRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The email recipient group OCID. */
        private String emailRecipientsGroupId = null;

        /**
         * The email recipient group OCID.
         *
         * @param emailRecipientsGroupId the value to set
         * @return this builder instance
         */
        public Builder emailRecipientsGroupId(String emailRecipientsGroupId) {
            this.emailRecipientsGroupId = emailRecipientsGroupId;
            return this;
        }

        /** The UsageStatement Subscription unique OCID. */
        private String subscriptionId = null;

        /**
         * The UsageStatement Subscription unique OCID.
         *
         * @param subscriptionId the value to set
         * @return this builder instance
         */
        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        /** The compartment ID in which to list resources. */
        private String compartmentId = null;

        /**
         * The compartment ID in which to list resources.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /**
         * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
         * particular request, please provide the request ID.
         */
        private String opcRequestId = null;

        /**
         * Unique Oracle-assigned identifier for the request. If you need to contact Oracle about a
         * particular request, please provide the request ID.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(GetEmailRecipientsGroupRequest o) {
            emailRecipientsGroupId(o.getEmailRecipientsGroupId());
            subscriptionId(o.getSubscriptionId());
            compartmentId(o.getCompartmentId());
            opcRequestId(o.getOpcRequestId());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of GetEmailRecipientsGroupRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of GetEmailRecipientsGroupRequest
         */
        public GetEmailRecipientsGroupRequest build() {
            GetEmailRecipientsGroupRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of GetEmailRecipientsGroupRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of GetEmailRecipientsGroupRequest
         */
        public GetEmailRecipientsGroupRequest buildWithoutInvocationCallback() {
            GetEmailRecipientsGroupRequest request = new GetEmailRecipientsGroupRequest();
            request.emailRecipientsGroupId = emailRecipientsGroupId;
            request.subscriptionId = subscriptionId;
            request.compartmentId = compartmentId;
            request.opcRequestId = opcRequestId;
            return request;
            // new GetEmailRecipientsGroupRequest(emailRecipientsGroupId, subscriptionId,
            // compartmentId, opcRequestId);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .emailRecipientsGroupId(emailRecipientsGroupId)
                .subscriptionId(subscriptionId)
                .compartmentId(compartmentId)
                .opcRequestId(opcRequestId);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",emailRecipientsGroupId=").append(String.valueOf(this.emailRecipientsGroupId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEmailRecipientsGroupRequest)) {
            return false;
        }

        GetEmailRecipientsGroupRequest other = (GetEmailRecipientsGroupRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(
                        this.emailRecipientsGroupId, other.emailRecipientsGroupId)
                && java.util.Objects.equals(this.subscriptionId, other.subscriptionId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.emailRecipientsGroupId == null
                                ? 43
                                : this.emailRecipientsGroupId.hashCode());
        result =
                (result * PRIME)
                        + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }
}
