/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vnmonitoring.model;

/**
 * Details used in a request to create a DRG route table. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = CreateDrgRouteTableDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class CreateDrgRouteTableDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "definedTags",
        "displayName",
        "freeformTags",
        "drgId",
        "importDrgRouteDistributionId",
        "isEcmpEnabled"
    })
    public CreateDrgRouteTableDetails(
            java.util.Map<String, java.util.Map<String, Object>> definedTags,
            String displayName,
            java.util.Map<String, String> freeformTags,
            String drgId,
            String importDrgRouteDistributionId,
            Boolean isEcmpEnabled) {
        super();
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.drgId = drgId;
        this.importDrgRouteDistributionId = importDrgRouteDistributionId;
        this.isEcmpEnabled = isEcmpEnabled;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }
        /**
         * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
         * confidential information.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
         * confidential information.
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the DRG the DRG route table belongs to.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("drgId")
        private String drgId;

        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the DRG the DRG route table belongs to.
         *
         * @param drgId the value to set
         * @return this builder
         */
        public Builder drgId(String drgId) {
            this.drgId = drgId;
            this.__explicitlySet__.add("drgId");
            return this;
        }
        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the import route distribution used to specify how incoming route advertisements
         * through referenced attachments are inserted into the DRG route table.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("importDrgRouteDistributionId")
        private String importDrgRouteDistributionId;

        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the import route distribution used to specify how incoming route advertisements
         * through referenced attachments are inserted into the DRG route table.
         *
         * @param importDrgRouteDistributionId the value to set
         * @return this builder
         */
        public Builder importDrgRouteDistributionId(String importDrgRouteDistributionId) {
            this.importDrgRouteDistributionId = importDrgRouteDistributionId;
            this.__explicitlySet__.add("importDrgRouteDistributionId");
            return this;
        }
        /**
         * If you want traffic to be routed using ECMP across your virtual circuits or IPSec tunnels
         * to your on-premises networks, enable ECMP on the DRG route table.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isEcmpEnabled")
        private Boolean isEcmpEnabled;

        /**
         * If you want traffic to be routed using ECMP across your virtual circuits or IPSec tunnels
         * to your on-premises networks, enable ECMP on the DRG route table.
         *
         * @param isEcmpEnabled the value to set
         * @return this builder
         */
        public Builder isEcmpEnabled(Boolean isEcmpEnabled) {
            this.isEcmpEnabled = isEcmpEnabled;
            this.__explicitlySet__.add("isEcmpEnabled");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public CreateDrgRouteTableDetails build() {
            CreateDrgRouteTableDetails model =
                    new CreateDrgRouteTableDetails(
                            this.definedTags,
                            this.displayName,
                            this.freeformTags,
                            this.drgId,
                            this.importDrgRouteDistributionId,
                            this.isEcmpEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(CreateDrgRouteTableDetails model) {
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("drgId")) {
                this.drgId(model.getDrgId());
            }
            if (model.wasPropertyExplicitlySet("importDrgRouteDistributionId")) {
                this.importDrgRouteDistributionId(model.getImportDrgRouteDistributionId());
            }
            if (model.wasPropertyExplicitlySet("isEcmpEnabled")) {
                this.isEcmpEnabled(model.getIsEcmpEnabled());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    /**
     * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
     * confidential information.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering
     * confidential information.
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the DRG the DRG route table belongs to.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("drgId")
    private final String drgId;

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the DRG the DRG route table belongs to.
     *
     * @return the value
     */
    public String getDrgId() {
        return drgId;
    }

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the import route distribution used to specify how incoming route advertisements through
     * referenced attachments are inserted into the DRG route table.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("importDrgRouteDistributionId")
    private final String importDrgRouteDistributionId;

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the import route distribution used to specify how incoming route advertisements through
     * referenced attachments are inserted into the DRG route table.
     *
     * @return the value
     */
    public String getImportDrgRouteDistributionId() {
        return importDrgRouteDistributionId;
    }

    /**
     * If you want traffic to be routed using ECMP across your virtual circuits or IPSec tunnels to
     * your on-premises networks, enable ECMP on the DRG route table.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isEcmpEnabled")
    private final Boolean isEcmpEnabled;

    /**
     * If you want traffic to be routed using ECMP across your virtual circuits or IPSec tunnels to
     * your on-premises networks, enable ECMP on the DRG route table.
     *
     * @return the value
     */
    public Boolean getIsEcmpEnabled() {
        return isEcmpEnabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("CreateDrgRouteTableDetails(");
        sb.append("super=").append(super.toString());
        sb.append("definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", drgId=").append(String.valueOf(this.drgId));
        sb.append(", importDrgRouteDistributionId=")
                .append(String.valueOf(this.importDrgRouteDistributionId));
        sb.append(", isEcmpEnabled=").append(String.valueOf(this.isEcmpEnabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDrgRouteTableDetails)) {
            return false;
        }

        CreateDrgRouteTableDetails other = (CreateDrgRouteTableDetails) o;
        return java.util.Objects.equals(this.definedTags, other.definedTags)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.drgId, other.drgId)
                && java.util.Objects.equals(
                        this.importDrgRouteDistributionId, other.importDrgRouteDistributionId)
                && java.util.Objects.equals(this.isEcmpEnabled, other.isEcmpEnabled)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.drgId == null ? 43 : this.drgId.hashCode());
        result =
                (result * PRIME)
                        + (this.importDrgRouteDistributionId == null
                                ? 43
                                : this.importDrgRouteDistributionId.hashCode());
        result =
                (result * PRIME)
                        + (this.isEcmpEnabled == null ? 43 : this.isEcmpEnabled.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
