/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * The information for a new host scan recipe <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = CreateHostScanRecipeDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class CreateHostScanRecipeDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "displayName",
        "compartmentId",
        "portSettings",
        "agentSettings",
        "applicationSettings",
        "schedule",
        "freeformTags",
        "definedTags"
    })
    public CreateHostScanRecipeDetails(
            String displayName,
            String compartmentId,
            HostScanPortSettings portSettings,
            HostScanAgentSettings agentSettings,
            ApplicationScanSettings applicationSettings,
            Schedule schedule,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags) {
        super();
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.portSettings = portSettings;
        this.agentSettings = agentSettings;
        this.applicationSettings = applicationSettings;
        this.schedule = schedule;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid
         * entering confidential information.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid
         * entering confidential information.
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /**
         * Compartment ID of the scanning config. If no individual hosts are specified, all hosts in
         * this compartment are scanned
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * Compartment ID of the scanning config. If no individual hosts are specified, all hosts in
         * this compartment are scanned
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("portSettings")
        private HostScanPortSettings portSettings;

        public Builder portSettings(HostScanPortSettings portSettings) {
            this.portSettings = portSettings;
            this.__explicitlySet__.add("portSettings");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("agentSettings")
        private HostScanAgentSettings agentSettings;

        public Builder agentSettings(HostScanAgentSettings agentSettings) {
            this.agentSettings = agentSettings;
            this.__explicitlySet__.add("agentSettings");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("applicationSettings")
        private ApplicationScanSettings applicationSettings;

        public Builder applicationSettings(ApplicationScanSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            this.__explicitlySet__.add("applicationSettings");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("schedule")
        private Schedule schedule;

        public Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            this.__explicitlySet__.add("schedule");
            return this;
        }
        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public CreateHostScanRecipeDetails build() {
            CreateHostScanRecipeDetails model =
                    new CreateHostScanRecipeDetails(
                            this.displayName,
                            this.compartmentId,
                            this.portSettings,
                            this.agentSettings,
                            this.applicationSettings,
                            this.schedule,
                            this.freeformTags,
                            this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(CreateHostScanRecipeDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("portSettings")) {
                this.portSettings(model.getPortSettings());
            }
            if (model.wasPropertyExplicitlySet("agentSettings")) {
                this.agentSettings(model.getAgentSettings());
            }
            if (model.wasPropertyExplicitlySet("applicationSettings")) {
                this.applicationSettings(model.getApplicationSettings());
            }
            if (model.wasPropertyExplicitlySet("schedule")) {
                this.schedule(model.getSchedule());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid
     * entering confidential information.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * Recipe identifier, which can be renamed. If not present, it will be auto-generated. Avoid
     * entering confidential information.
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * Compartment ID of the scanning config. If no individual hosts are specified, all hosts in
     * this compartment are scanned
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * Compartment ID of the scanning config. If no individual hosts are specified, all hosts in
     * this compartment are scanned
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("portSettings")
    private final HostScanPortSettings portSettings;

    public HostScanPortSettings getPortSettings() {
        return portSettings;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("agentSettings")
    private final HostScanAgentSettings agentSettings;

    public HostScanAgentSettings getAgentSettings() {
        return agentSettings;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("applicationSettings")
    private final ApplicationScanSettings applicationSettings;

    public ApplicationScanSettings getApplicationSettings() {
        return applicationSettings;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("schedule")
    private final Schedule schedule;

    public Schedule getSchedule() {
        return schedule;
    }

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("CreateHostScanRecipeDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", portSettings=").append(String.valueOf(this.portSettings));
        sb.append(", agentSettings=").append(String.valueOf(this.agentSettings));
        sb.append(", applicationSettings=").append(String.valueOf(this.applicationSettings));
        sb.append(", schedule=").append(String.valueOf(this.schedule));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateHostScanRecipeDetails)) {
            return false;
        }

        CreateHostScanRecipeDetails other = (CreateHostScanRecipeDetails) o;
        return java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.portSettings, other.portSettings)
                && java.util.Objects.equals(this.agentSettings, other.agentSettings)
                && java.util.Objects.equals(this.applicationSettings, other.applicationSettings)
                && java.util.Objects.equals(this.schedule, other.schedule)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.portSettings == null ? 43 : this.portSettings.hashCode());
        result =
                (result * PRIME)
                        + (this.agentSettings == null ? 43 : this.agentSettings.hashCode());
        result =
                (result * PRIME)
                        + (this.applicationSettings == null
                                ? 43
                                : this.applicationSettings.hashCode());
        result = (result * PRIME) + (this.schedule == null ? 43 : this.schedule.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
