/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Details on a CVE. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = CveDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class CveDetails extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "cveReference",
        "title",
        "description",
        "relatedCveReference",
        "cvss3",
        "timePublished",
        "timeUpdated",
        "threat",
        "impact",
        "solution",
        "patchable",
        "exploitable",
        "referenceUrl"
    })
    public CveDetails(
            String cveReference,
            String title,
            String description,
            String relatedCveReference,
            String cvss3,
            java.util.Date timePublished,
            java.util.Date timeUpdated,
            String threat,
            String impact,
            String solution,
            String patchable,
            String exploitable,
            String referenceUrl) {
        super();
        this.cveReference = cveReference;
        this.title = title;
        this.description = description;
        this.relatedCveReference = relatedCveReference;
        this.cvss3 = cvss3;
        this.timePublished = timePublished;
        this.timeUpdated = timeUpdated;
        this.threat = threat;
        this.impact = impact;
        this.solution = solution;
        this.patchable = patchable;
        this.exploitable = exploitable;
        this.referenceUrl = referenceUrl;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** CVE ID. */
        @com.fasterxml.jackson.annotation.JsonProperty("cveReference")
        private String cveReference;

        /**
         * CVE ID.
         *
         * @param cveReference the value to set
         * @return this builder
         */
        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            this.__explicitlySet__.add("cveReference");
            return this;
        }
        /** Vulnerability title. */
        @com.fasterxml.jackson.annotation.JsonProperty("title")
        private String title;

        /**
         * Vulnerability title.
         *
         * @param title the value to set
         * @return this builder
         */
        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }
        /** CVE description. */
        @com.fasterxml.jackson.annotation.JsonProperty("description")
        private String description;

        /**
         * CVE description.
         *
         * @param description the value to set
         * @return this builder
         */
        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }
        /** ID of related CVE, if applicable. */
        @com.fasterxml.jackson.annotation.JsonProperty("relatedCveReference")
        private String relatedCveReference;

        /**
         * ID of related CVE, if applicable.
         *
         * @param relatedCveReference the value to set
         * @return this builder
         */
        public Builder relatedCveReference(String relatedCveReference) {
            this.relatedCveReference = relatedCveReference;
            this.__explicitlySet__.add("relatedCveReference");
            return this;
        }
        /** CVSS 3 Score. */
        @com.fasterxml.jackson.annotation.JsonProperty("cvss3")
        private String cvss3;

        /**
         * CVSS 3 Score.
         *
         * @param cvss3 the value to set
         * @return this builder
         */
        public Builder cvss3(String cvss3) {
            this.cvss3 = cvss3;
            this.__explicitlySet__.add("cvss3");
            return this;
        }
        /** Date/time the CVE was published. */
        @com.fasterxml.jackson.annotation.JsonProperty("timePublished")
        private java.util.Date timePublished;

        /**
         * Date/time the CVE was published.
         *
         * @param timePublished the value to set
         * @return this builder
         */
        public Builder timePublished(java.util.Date timePublished) {
            this.timePublished = timePublished;
            this.__explicitlySet__.add("timePublished");
            return this;
        }
        /** Date/time the CVE was last modified. */
        @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
        private java.util.Date timeUpdated;

        /**
         * Date/time the CVE was last modified.
         *
         * @param timeUpdated the value to set
         * @return this builder
         */
        public Builder timeUpdated(java.util.Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }
        /** Threat this item poses to resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("threat")
        private String threat;

        /**
         * Threat this item poses to resource.
         *
         * @param threat the value to set
         * @return this builder
         */
        public Builder threat(String threat) {
            this.threat = threat;
            this.__explicitlySet__.add("threat");
            return this;
        }
        /** Impact on resource if this vulnerability is exploited. */
        @com.fasterxml.jackson.annotation.JsonProperty("impact")
        private String impact;

        /**
         * Impact on resource if this vulnerability is exploited.
         *
         * @param impact the value to set
         * @return this builder
         */
        public Builder impact(String impact) {
            this.impact = impact;
            this.__explicitlySet__.add("impact");
            return this;
        }
        /** Recommended solution to fix this vulnerability. */
        @com.fasterxml.jackson.annotation.JsonProperty("solution")
        private String solution;

        /**
         * Recommended solution to fix this vulnerability.
         *
         * @param solution the value to set
         * @return this builder
         */
        public Builder solution(String solution) {
            this.solution = solution;
            this.__explicitlySet__.add("solution");
            return this;
        }
        /** Can this vulnerability be patched. */
        @com.fasterxml.jackson.annotation.JsonProperty("patchable")
        private String patchable;

        /**
         * Can this vulnerability be patched.
         *
         * @param patchable the value to set
         * @return this builder
         */
        public Builder patchable(String patchable) {
            this.patchable = patchable;
            this.__explicitlySet__.add("patchable");
            return this;
        }
        /** Can this vulnerability be exploited. */
        @com.fasterxml.jackson.annotation.JsonProperty("exploitable")
        private String exploitable;

        /**
         * Can this vulnerability be exploited.
         *
         * @param exploitable the value to set
         * @return this builder
         */
        public Builder exploitable(String exploitable) {
            this.exploitable = exploitable;
            this.__explicitlySet__.add("exploitable");
            return this;
        }
        /** Reference link to know more about this vulnerability. */
        @com.fasterxml.jackson.annotation.JsonProperty("referenceUrl")
        private String referenceUrl;

        /**
         * Reference link to know more about this vulnerability.
         *
         * @param referenceUrl the value to set
         * @return this builder
         */
        public Builder referenceUrl(String referenceUrl) {
            this.referenceUrl = referenceUrl;
            this.__explicitlySet__.add("referenceUrl");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public CveDetails build() {
            CveDetails model =
                    new CveDetails(
                            this.cveReference,
                            this.title,
                            this.description,
                            this.relatedCveReference,
                            this.cvss3,
                            this.timePublished,
                            this.timeUpdated,
                            this.threat,
                            this.impact,
                            this.solution,
                            this.patchable,
                            this.exploitable,
                            this.referenceUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(CveDetails model) {
            if (model.wasPropertyExplicitlySet("cveReference")) {
                this.cveReference(model.getCveReference());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("relatedCveReference")) {
                this.relatedCveReference(model.getRelatedCveReference());
            }
            if (model.wasPropertyExplicitlySet("cvss3")) {
                this.cvss3(model.getCvss3());
            }
            if (model.wasPropertyExplicitlySet("timePublished")) {
                this.timePublished(model.getTimePublished());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("threat")) {
                this.threat(model.getThreat());
            }
            if (model.wasPropertyExplicitlySet("impact")) {
                this.impact(model.getImpact());
            }
            if (model.wasPropertyExplicitlySet("solution")) {
                this.solution(model.getSolution());
            }
            if (model.wasPropertyExplicitlySet("patchable")) {
                this.patchable(model.getPatchable());
            }
            if (model.wasPropertyExplicitlySet("exploitable")) {
                this.exploitable(model.getExploitable());
            }
            if (model.wasPropertyExplicitlySet("referenceUrl")) {
                this.referenceUrl(model.getReferenceUrl());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** CVE ID. */
    @com.fasterxml.jackson.annotation.JsonProperty("cveReference")
    private final String cveReference;

    /**
     * CVE ID.
     *
     * @return the value
     */
    public String getCveReference() {
        return cveReference;
    }

    /** Vulnerability title. */
    @com.fasterxml.jackson.annotation.JsonProperty("title")
    private final String title;

    /**
     * Vulnerability title.
     *
     * @return the value
     */
    public String getTitle() {
        return title;
    }

    /** CVE description. */
    @com.fasterxml.jackson.annotation.JsonProperty("description")
    private final String description;

    /**
     * CVE description.
     *
     * @return the value
     */
    public String getDescription() {
        return description;
    }

    /** ID of related CVE, if applicable. */
    @com.fasterxml.jackson.annotation.JsonProperty("relatedCveReference")
    private final String relatedCveReference;

    /**
     * ID of related CVE, if applicable.
     *
     * @return the value
     */
    public String getRelatedCveReference() {
        return relatedCveReference;
    }

    /** CVSS 3 Score. */
    @com.fasterxml.jackson.annotation.JsonProperty("cvss3")
    private final String cvss3;

    /**
     * CVSS 3 Score.
     *
     * @return the value
     */
    public String getCvss3() {
        return cvss3;
    }

    /** Date/time the CVE was published. */
    @com.fasterxml.jackson.annotation.JsonProperty("timePublished")
    private final java.util.Date timePublished;

    /**
     * Date/time the CVE was published.
     *
     * @return the value
     */
    public java.util.Date getTimePublished() {
        return timePublished;
    }

    /** Date/time the CVE was last modified. */
    @com.fasterxml.jackson.annotation.JsonProperty("timeUpdated")
    private final java.util.Date timeUpdated;

    /**
     * Date/time the CVE was last modified.
     *
     * @return the value
     */
    public java.util.Date getTimeUpdated() {
        return timeUpdated;
    }

    /** Threat this item poses to resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("threat")
    private final String threat;

    /**
     * Threat this item poses to resource.
     *
     * @return the value
     */
    public String getThreat() {
        return threat;
    }

    /** Impact on resource if this vulnerability is exploited. */
    @com.fasterxml.jackson.annotation.JsonProperty("impact")
    private final String impact;

    /**
     * Impact on resource if this vulnerability is exploited.
     *
     * @return the value
     */
    public String getImpact() {
        return impact;
    }

    /** Recommended solution to fix this vulnerability. */
    @com.fasterxml.jackson.annotation.JsonProperty("solution")
    private final String solution;

    /**
     * Recommended solution to fix this vulnerability.
     *
     * @return the value
     */
    public String getSolution() {
        return solution;
    }

    /** Can this vulnerability be patched. */
    @com.fasterxml.jackson.annotation.JsonProperty("patchable")
    private final String patchable;

    /**
     * Can this vulnerability be patched.
     *
     * @return the value
     */
    public String getPatchable() {
        return patchable;
    }

    /** Can this vulnerability be exploited. */
    @com.fasterxml.jackson.annotation.JsonProperty("exploitable")
    private final String exploitable;

    /**
     * Can this vulnerability be exploited.
     *
     * @return the value
     */
    public String getExploitable() {
        return exploitable;
    }

    /** Reference link to know more about this vulnerability. */
    @com.fasterxml.jackson.annotation.JsonProperty("referenceUrl")
    private final String referenceUrl;

    /**
     * Reference link to know more about this vulnerability.
     *
     * @return the value
     */
    public String getReferenceUrl() {
        return referenceUrl;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("CveDetails(");
        sb.append("super=").append(super.toString());
        sb.append("cveReference=").append(String.valueOf(this.cveReference));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", relatedCveReference=").append(String.valueOf(this.relatedCveReference));
        sb.append(", cvss3=").append(String.valueOf(this.cvss3));
        sb.append(", timePublished=").append(String.valueOf(this.timePublished));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", threat=").append(String.valueOf(this.threat));
        sb.append(", impact=").append(String.valueOf(this.impact));
        sb.append(", solution=").append(String.valueOf(this.solution));
        sb.append(", patchable=").append(String.valueOf(this.patchable));
        sb.append(", exploitable=").append(String.valueOf(this.exploitable));
        sb.append(", referenceUrl=").append(String.valueOf(this.referenceUrl));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CveDetails)) {
            return false;
        }

        CveDetails other = (CveDetails) o;
        return java.util.Objects.equals(this.cveReference, other.cveReference)
                && java.util.Objects.equals(this.title, other.title)
                && java.util.Objects.equals(this.description, other.description)
                && java.util.Objects.equals(this.relatedCveReference, other.relatedCveReference)
                && java.util.Objects.equals(this.cvss3, other.cvss3)
                && java.util.Objects.equals(this.timePublished, other.timePublished)
                && java.util.Objects.equals(this.timeUpdated, other.timeUpdated)
                && java.util.Objects.equals(this.threat, other.threat)
                && java.util.Objects.equals(this.impact, other.impact)
                && java.util.Objects.equals(this.solution, other.solution)
                && java.util.Objects.equals(this.patchable, other.patchable)
                && java.util.Objects.equals(this.exploitable, other.exploitable)
                && java.util.Objects.equals(this.referenceUrl, other.referenceUrl)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = (result * PRIME) + (this.title == null ? 43 : this.title.hashCode());
        result = (result * PRIME) + (this.description == null ? 43 : this.description.hashCode());
        result =
                (result * PRIME)
                        + (this.relatedCveReference == null
                                ? 43
                                : this.relatedCveReference.hashCode());
        result = (result * PRIME) + (this.cvss3 == null ? 43 : this.cvss3.hashCode());
        result =
                (result * PRIME)
                        + (this.timePublished == null ? 43 : this.timePublished.hashCode());
        result = (result * PRIME) + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = (result * PRIME) + (this.threat == null ? 43 : this.threat.hashCode());
        result = (result * PRIME) + (this.impact == null ? 43 : this.impact.hashCode());
        result = (result * PRIME) + (this.solution == null ? 43 : this.solution.hashCode());
        result = (result * PRIME) + (this.patchable == null ? 43 : this.patchable.hashCode());
        result = (result * PRIME) + (this.exploitable == null ? 43 : this.exploitable.hashCode());
        result = (result * PRIME) + (this.referenceUrl == null ? 43 : this.referenceUrl.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
