/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * A single CIS (Center for Internet Security) benchmark executed in a host scan <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostCisBenchmarkScanResultScore.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostCisBenchmarkScanResultScore
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"benchmarkIdentifier", "description", "score"})
    public HostCisBenchmarkScanResultScore(
            String benchmarkIdentifier, String description, ScanResultScore score) {
        super();
        this.benchmarkIdentifier = benchmarkIdentifier;
        this.description = description;
        this.score = score;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Identifier for this CIS (Center for Internet Security) benchmark */
        @com.fasterxml.jackson.annotation.JsonProperty("benchmarkIdentifier")
        private String benchmarkIdentifier;

        /**
         * Identifier for this CIS (Center for Internet Security) benchmark
         *
         * @param benchmarkIdentifier the value to set
         * @return this builder
         */
        public Builder benchmarkIdentifier(String benchmarkIdentifier) {
            this.benchmarkIdentifier = benchmarkIdentifier;
            this.__explicitlySet__.add("benchmarkIdentifier");
            return this;
        }
        /** Details about what this CIS (Center for Internet Security) benchmark represents */
        @com.fasterxml.jackson.annotation.JsonProperty("description")
        private String description;

        /**
         * Details about what this CIS (Center for Internet Security) benchmark represents
         *
         * @param description the value to set
         * @return this builder
         */
        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }
        /** Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail) */
        @com.fasterxml.jackson.annotation.JsonProperty("score")
        private ScanResultScore score;

        /**
         * Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail)
         *
         * @param score the value to set
         * @return this builder
         */
        public Builder score(ScanResultScore score) {
            this.score = score;
            this.__explicitlySet__.add("score");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostCisBenchmarkScanResultScore build() {
            HostCisBenchmarkScanResultScore model =
                    new HostCisBenchmarkScanResultScore(
                            this.benchmarkIdentifier, this.description, this.score);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostCisBenchmarkScanResultScore model) {
            if (model.wasPropertyExplicitlySet("benchmarkIdentifier")) {
                this.benchmarkIdentifier(model.getBenchmarkIdentifier());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("score")) {
                this.score(model.getScore());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Identifier for this CIS (Center for Internet Security) benchmark */
    @com.fasterxml.jackson.annotation.JsonProperty("benchmarkIdentifier")
    private final String benchmarkIdentifier;

    /**
     * Identifier for this CIS (Center for Internet Security) benchmark
     *
     * @return the value
     */
    public String getBenchmarkIdentifier() {
        return benchmarkIdentifier;
    }

    /** Details about what this CIS (Center for Internet Security) benchmark represents */
    @com.fasterxml.jackson.annotation.JsonProperty("description")
    private final String description;

    /**
     * Details about what this CIS (Center for Internet Security) benchmark represents
     *
     * @return the value
     */
    public String getDescription() {
        return description;
    }

    /** Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail) */
    @com.fasterxml.jackson.annotation.JsonProperty("score")
    private final ScanResultScore score;

    /**
     * Result score of CIS (Center for Internet Security) benchmark execution (Pass/Fail)
     *
     * @return the value
     */
    public ScanResultScore getScore() {
        return score;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostCisBenchmarkScanResultScore(");
        sb.append("super=").append(super.toString());
        sb.append("benchmarkIdentifier=").append(String.valueOf(this.benchmarkIdentifier));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", score=").append(String.valueOf(this.score));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostCisBenchmarkScanResultScore)) {
            return false;
        }

        HostCisBenchmarkScanResultScore other = (HostCisBenchmarkScanResultScore) o;
        return java.util.Objects.equals(this.benchmarkIdentifier, other.benchmarkIdentifier)
                && java.util.Objects.equals(this.description, other.description)
                && java.util.Objects.equals(this.score, other.score)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.benchmarkIdentifier == null
                                ? 43
                                : this.benchmarkIdentifier.hashCode());
        result = (result * PRIME) + (this.description == null ? 43 : this.description.hashCode());
        result = (result * PRIME) + (this.score == null ? 43 : this.score.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
