/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Agent configuration options for the OCI host scan agent <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostScanAgentConfigurationOCI.Builder.class)
@com.fasterxml.jackson.annotation.JsonTypeInfo(
        use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
        include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
        property = "vendor")
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostScanAgentConfigurationOCI extends HostScanAgentConfiguration {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        @com.fasterxml.jackson.annotation.JsonProperty("vendorType")
        private VendorType vendorType;

        public Builder vendorType(VendorType vendorType) {
            this.vendorType = vendorType;
            this.__explicitlySet__.add("vendorType");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("cisBenchmarkSettings")
        private HostCisBenchmarkSettings cisBenchmarkSettings;

        public Builder cisBenchmarkSettings(HostCisBenchmarkSettings cisBenchmarkSettings) {
            this.cisBenchmarkSettings = cisBenchmarkSettings;
            this.__explicitlySet__.add("cisBenchmarkSettings");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("endpointProtectionSettings")
        private HostEndpointProtectionSettings endpointProtectionSettings;

        public Builder endpointProtectionSettings(
                HostEndpointProtectionSettings endpointProtectionSettings) {
            this.endpointProtectionSettings = endpointProtectionSettings;
            this.__explicitlySet__.add("endpointProtectionSettings");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostScanAgentConfigurationOCI build() {
            HostScanAgentConfigurationOCI model =
                    new HostScanAgentConfigurationOCI(
                            this.vendorType,
                            this.cisBenchmarkSettings,
                            this.endpointProtectionSettings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostScanAgentConfigurationOCI model) {
            if (model.wasPropertyExplicitlySet("vendorType")) {
                this.vendorType(model.getVendorType());
            }
            if (model.wasPropertyExplicitlySet("cisBenchmarkSettings")) {
                this.cisBenchmarkSettings(model.getCisBenchmarkSettings());
            }
            if (model.wasPropertyExplicitlySet("endpointProtectionSettings")) {
                this.endpointProtectionSettings(model.getEndpointProtectionSettings());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostScanAgentConfigurationOCI(
            VendorType vendorType,
            HostCisBenchmarkSettings cisBenchmarkSettings,
            HostEndpointProtectionSettings endpointProtectionSettings) {
        super(vendorType);
        this.cisBenchmarkSettings = cisBenchmarkSettings;
        this.endpointProtectionSettings = endpointProtectionSettings;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("cisBenchmarkSettings")
    private final HostCisBenchmarkSettings cisBenchmarkSettings;

    public HostCisBenchmarkSettings getCisBenchmarkSettings() {
        return cisBenchmarkSettings;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("endpointProtectionSettings")
    private final HostEndpointProtectionSettings endpointProtectionSettings;

    public HostEndpointProtectionSettings getEndpointProtectionSettings() {
        return endpointProtectionSettings;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostScanAgentConfigurationOCI(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cisBenchmarkSettings=").append(String.valueOf(this.cisBenchmarkSettings));
        sb.append(", endpointProtectionSettings=")
                .append(String.valueOf(this.endpointProtectionSettings));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostScanAgentConfigurationOCI)) {
            return false;
        }

        HostScanAgentConfigurationOCI other = (HostScanAgentConfigurationOCI) o;
        return java.util.Objects.equals(this.cisBenchmarkSettings, other.cisBenchmarkSettings)
                && java.util.Objects.equals(
                        this.endpointProtectionSettings, other.endpointProtectionSettings)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.cisBenchmarkSettings == null
                                ? 43
                                : this.cisBenchmarkSettings.hashCode());
        result =
                (result * PRIME)
                        + (this.endpointProtectionSettings == null
                                ? 43
                                : this.endpointProtectionSettings.hashCode());
        return result;
    }
}
