/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Summary of a scan vulnerability <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = VulnerabilitySummary.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class VulnerabilitySummary
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "compartmentId",
        "vulnerabilityReference",
        "severity",
        "state",
        "cveDescription",
        "name",
        "timeLastDetected",
        "timeFirstDetected",
        "impactedResourcesCount",
        "vulnerabilityType",
        "lifecycleState"
    })
    public VulnerabilitySummary(
            String id,
            String compartmentId,
            String vulnerabilityReference,
            ScanResultProblemSeverity severity,
            ScanResultVulnerabilityState state,
            String cveDescription,
            String name,
            java.util.Date timeLastDetected,
            java.util.Date timeFirstDetected,
            ImpactedResourcesCount impactedResourcesCount,
            VulnerabilityType vulnerabilityType,
            LifecycleState lifecycleState) {
        super();
        this.id = id;
        this.compartmentId = compartmentId;
        this.vulnerabilityReference = vulnerabilityReference;
        this.severity = severity;
        this.state = state;
        this.cveDescription = cveDescription;
        this.name = name;
        this.timeLastDetected = timeLastDetected;
        this.timeFirstDetected = timeFirstDetected;
        this.impactedResourcesCount = impactedResourcesCount;
        this.vulnerabilityType = vulnerabilityType;
        this.lifecycleState = lifecycleState;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** ID of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * ID of the vulnerability
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /**
         * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
         * different compartments.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
         * different compartments.
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /**
         * Reference to the vulnerability type's unique identifier. For CVE, this is the MITRE CVE
         * ID
         */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityReference")
        private String vulnerabilityReference;

        /**
         * Reference to the vulnerability type's unique identifier. For CVE, this is the MITRE CVE
         * ID
         *
         * @param vulnerabilityReference the value to set
         * @return this builder
         */
        public Builder vulnerabilityReference(String vulnerabilityReference) {
            this.vulnerabilityReference = vulnerabilityReference;
            this.__explicitlySet__.add("vulnerabilityReference");
            return this;
        }
        /** Severity of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("severity")
        private ScanResultProblemSeverity severity;

        /**
         * Severity of the vulnerability
         *
         * @param severity the value to set
         * @return this builder
         */
        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }
        /** State of the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("state")
        private ScanResultVulnerabilityState state;

        /**
         * State of the vulnerability
         *
         * @param state the value to set
         * @return this builder
         */
        public Builder state(ScanResultVulnerabilityState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }
        /** The description of CVE vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("cveDescription")
        private String cveDescription;

        /**
         * The description of CVE vulnerability
         *
         * @param cveDescription the value to set
         * @return this builder
         */
        public Builder cveDescription(String cveDescription) {
            this.cveDescription = cveDescription;
            this.__explicitlySet__.add("cveDescription");
            return this;
        }
        /** Vulnerability name */
        @com.fasterxml.jackson.annotation.JsonProperty("name")
        private String name;

        /**
         * Vulnerability name
         *
         * @param name the value to set
         * @return this builder
         */
        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }
        /** Date of scan result that most recently reported the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetected")
        private java.util.Date timeLastDetected;

        /**
         * Date of scan result that most recently reported the vulnerability
         *
         * @param timeLastDetected the value to set
         * @return this builder
         */
        public Builder timeLastDetected(java.util.Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }
        /** Date of scan result that first reported the vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFirstDetected")
        private java.util.Date timeFirstDetected;

        /**
         * Date of scan result that first reported the vulnerability
         *
         * @param timeFirstDetected the value to set
         * @return this builder
         */
        public Builder timeFirstDetected(java.util.Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("impactedResourcesCount")
        private ImpactedResourcesCount impactedResourcesCount;

        public Builder impactedResourcesCount(ImpactedResourcesCount impactedResourcesCount) {
            this.impactedResourcesCount = impactedResourcesCount;
            this.__explicitlySet__.add("impactedResourcesCount");
            return this;
        }
        /** Specifies the type of Vulnerability */
        @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityType")
        private VulnerabilityType vulnerabilityType;

        /**
         * Specifies the type of Vulnerability
         *
         * @param vulnerabilityType the value to set
         * @return this builder
         */
        public Builder vulnerabilityType(VulnerabilityType vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            this.__explicitlySet__.add("vulnerabilityType");
            return this;
        }
        /** The current state of the resource. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private LifecycleState lifecycleState;

        /**
         * The current state of the resource.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public VulnerabilitySummary build() {
            VulnerabilitySummary model =
                    new VulnerabilitySummary(
                            this.id,
                            this.compartmentId,
                            this.vulnerabilityReference,
                            this.severity,
                            this.state,
                            this.cveDescription,
                            this.name,
                            this.timeLastDetected,
                            this.timeFirstDetected,
                            this.impactedResourcesCount,
                            this.vulnerabilityType,
                            this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(VulnerabilitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityReference")) {
                this.vulnerabilityReference(model.getVulnerabilityReference());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("cveDescription")) {
                this.cveDescription(model.getCveDescription());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("impactedResourcesCount")) {
                this.impactedResourcesCount(model.getImpactedResourcesCount());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityType")) {
                this.vulnerabilityType(model.getVulnerabilityType());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** ID of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * ID of the vulnerability
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /**
     * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
     * different compartments.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in
     * different compartments.
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /**
     * Reference to the vulnerability type's unique identifier. For CVE, this is the MITRE CVE ID
     */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityReference")
    private final String vulnerabilityReference;

    /**
     * Reference to the vulnerability type's unique identifier. For CVE, this is the MITRE CVE ID
     *
     * @return the value
     */
    public String getVulnerabilityReference() {
        return vulnerabilityReference;
    }

    /** Severity of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("severity")
    private final ScanResultProblemSeverity severity;

    /**
     * Severity of the vulnerability
     *
     * @return the value
     */
    public ScanResultProblemSeverity getSeverity() {
        return severity;
    }

    /** State of the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("state")
    private final ScanResultVulnerabilityState state;

    /**
     * State of the vulnerability
     *
     * @return the value
     */
    public ScanResultVulnerabilityState getState() {
        return state;
    }

    /** The description of CVE vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("cveDescription")
    private final String cveDescription;

    /**
     * The description of CVE vulnerability
     *
     * @return the value
     */
    public String getCveDescription() {
        return cveDescription;
    }

    /** Vulnerability name */
    @com.fasterxml.jackson.annotation.JsonProperty("name")
    private final String name;

    /**
     * Vulnerability name
     *
     * @return the value
     */
    public String getName() {
        return name;
    }

    /** Date of scan result that most recently reported the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("timeLastDetected")
    private final java.util.Date timeLastDetected;

    /**
     * Date of scan result that most recently reported the vulnerability
     *
     * @return the value
     */
    public java.util.Date getTimeLastDetected() {
        return timeLastDetected;
    }

    /** Date of scan result that first reported the vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFirstDetected")
    private final java.util.Date timeFirstDetected;

    /**
     * Date of scan result that first reported the vulnerability
     *
     * @return the value
     */
    public java.util.Date getTimeFirstDetected() {
        return timeFirstDetected;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("impactedResourcesCount")
    private final ImpactedResourcesCount impactedResourcesCount;

    public ImpactedResourcesCount getImpactedResourcesCount() {
        return impactedResourcesCount;
    }

    /** Specifies the type of Vulnerability */
    @com.fasterxml.jackson.annotation.JsonProperty("vulnerabilityType")
    private final VulnerabilityType vulnerabilityType;

    /**
     * Specifies the type of Vulnerability
     *
     * @return the value
     */
    public VulnerabilityType getVulnerabilityType() {
        return vulnerabilityType;
    }

    /** The current state of the resource. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final LifecycleState lifecycleState;

    /**
     * The current state of the resource.
     *
     * @return the value
     */
    public LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("VulnerabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", vulnerabilityReference=").append(String.valueOf(this.vulnerabilityReference));
        sb.append(", severity=").append(String.valueOf(this.severity));
        sb.append(", state=").append(String.valueOf(this.state));
        sb.append(", cveDescription=").append(String.valueOf(this.cveDescription));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", impactedResourcesCount=").append(String.valueOf(this.impactedResourcesCount));
        sb.append(", vulnerabilityType=").append(String.valueOf(this.vulnerabilityType));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilitySummary)) {
            return false;
        }

        VulnerabilitySummary other = (VulnerabilitySummary) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(
                        this.vulnerabilityReference, other.vulnerabilityReference)
                && java.util.Objects.equals(this.severity, other.severity)
                && java.util.Objects.equals(this.state, other.state)
                && java.util.Objects.equals(this.cveDescription, other.cveDescription)
                && java.util.Objects.equals(this.name, other.name)
                && java.util.Objects.equals(this.timeLastDetected, other.timeLastDetected)
                && java.util.Objects.equals(this.timeFirstDetected, other.timeFirstDetected)
                && java.util.Objects.equals(
                        this.impactedResourcesCount, other.impactedResourcesCount)
                && java.util.Objects.equals(this.vulnerabilityType, other.vulnerabilityType)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilityReference == null
                                ? 43
                                : this.vulnerabilityReference.hashCode());
        result = (result * PRIME) + (this.severity == null ? 43 : this.severity.hashCode());
        result = (result * PRIME) + (this.state == null ? 43 : this.state.hashCode());
        result =
                (result * PRIME)
                        + (this.cveDescription == null ? 43 : this.cveDescription.hashCode());
        result = (result * PRIME) + (this.name == null ? 43 : this.name.hashCode());
        result =
                (result * PRIME)
                        + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result =
                (result * PRIME)
                        + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result =
                (result * PRIME)
                        + (this.impactedResourcesCount == null
                                ? 43
                                : this.impactedResourcesCount.hashCode());
        result =
                (result * PRIME)
                        + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
