/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.UpdateGroupDetails;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateGroupRequest
extends BmcRequest<UpdateGroupDetails> {
    private String streamId;
    private String groupName;
    private UpdateGroupDetails updateGroupDetails;
    private String opcRequestId;

    @InternalSdk
    public UpdateGroupDetails getBody$() {
        return this.updateGroupDetails;
    }

    @ConstructorProperties(value={"streamId", "groupName", "updateGroupDetails", "opcRequestId"})
    UpdateGroupRequest(String streamId, String groupName, UpdateGroupDetails updateGroupDetails, String opcRequestId) {
        this.streamId = streamId;
        this.groupName = groupName;
        this.updateGroupDetails = updateGroupDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public UpdateGroupDetails getUpdateGroupDetails() {
        return this.updateGroupDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateGroupRequest, UpdateGroupDetails> {
        private String streamId;
        private String groupName;
        private UpdateGroupDetails updateGroupDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateGroupRequest o) {
            this.streamId(o.getStreamId());
            this.groupName(o.getGroupName());
            this.updateGroupDetails(o.getUpdateGroupDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateGroupRequest build() {
            UpdateGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateGroupDetails body) {
            this.updateGroupDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder updateGroupDetails(UpdateGroupDetails updateGroupDetails) {
            this.updateGroupDetails = updateGroupDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateGroupRequest buildWithoutInvocationCallback() {
            return new UpdateGroupRequest(this.streamId, this.groupName, this.updateGroupDetails, this.opcRequestId);
        }

        public String toString() {
            return "UpdateGroupRequest.Builder(streamId=" + this.streamId + ", groupName=" + this.groupName + ", updateGroupDetails=" + this.updateGroupDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

