/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.tenantmanagercontrolplane.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.model.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetDomainResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DomainWaiters {
    private final ExecutorService executorService;
    private final Domain client;

    public Waiter<GetDomainRequest, GetDomainResponse> forDomain(GetDomainRequest request, Domain.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDomain(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDomainRequest, GetDomainResponse> forDomain(GetDomainRequest request, Domain.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDomainRequest, GetDomainResponse> forDomain(GetDomainRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Domain.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDomain(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDomainRequest, GetDomainResponse> forDomain(BmcGenericWaiter waiter, GetDomainRequest request, Domain.LifecycleState ... targetStates) {
        final HashSet<Domain.LifecycleState> targetStatesSet = new HashSet<Domain.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDomainRequest, GetDomainResponse>(){

            public GetDomainResponse apply(GetDomainRequest request) {
                return DomainWaiters.this.client.getDomain(request);
            }
        }, (Predicate)new Predicate<GetDomainResponse>(){

            public boolean apply(GetDomainResponse response) {
                return targetStatesSet.contains((Object)response.getDomain().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Domain.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DomainWaiters(ExecutorService executorService, Domain client) {
        this.executorService = executorService;
        this.client = client;
    }
}

