/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitationSummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListRecipientInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListRecipientInvitationsResponse;
import java.beans.ConstructorProperties;
import java.util.List;

public class RecipientInvitationPaginators {
    private final RecipientInvitation client;

    public Iterable<ListRecipientInvitationsResponse> listRecipientInvitationsResponseIterator(final ListRecipientInvitationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecipientInvitationsRequest.Builder>(){

            public ListRecipientInvitationsRequest.Builder get() {
                return ListRecipientInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecipientInvitationsResponse, String>(){

            public String apply(ListRecipientInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder>, ListRecipientInvitationsRequest>(){

            public ListRecipientInvitationsRequest apply(RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse>(){

            public ListRecipientInvitationsResponse apply(ListRecipientInvitationsRequest request) {
                return RecipientInvitationPaginators.this.client.listRecipientInvitations(request);
            }
        });
    }

    public Iterable<RecipientInvitationSummary> listRecipientInvitationsRecordIterator(final ListRecipientInvitationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecipientInvitationsRequest.Builder>(){

            public ListRecipientInvitationsRequest.Builder get() {
                return ListRecipientInvitationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecipientInvitationsResponse, String>(){

            public String apply(ListRecipientInvitationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder>, ListRecipientInvitationsRequest>(){

            public ListRecipientInvitationsRequest apply(RequestBuilderAndToken<ListRecipientInvitationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecipientInvitationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse>(){

            public ListRecipientInvitationsResponse apply(ListRecipientInvitationsRequest request) {
                return RecipientInvitationPaginators.this.client.listRecipientInvitations(request);
            }
        }, (Function)new Function<ListRecipientInvitationsResponse, List<RecipientInvitationSummary>>(){

            public List<RecipientInvitationSummary> apply(ListRecipientInvitationsResponse response) {
                return response.getRecipientInvitationCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public RecipientInvitationPaginators(RecipientInvitation client) {
        this.client = client;
    }
}

