/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRecipientInvitationRequest
extends BmcRequest<Void> {
    private String recipientInvitationId;
    private String opcRequestId;

    @ConstructorProperties(value={"recipientInvitationId", "opcRequestId"})
    GetRecipientInvitationRequest(String recipientInvitationId, String opcRequestId) {
        this.recipientInvitationId = recipientInvitationId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRecipientInvitationId() {
        return this.recipientInvitationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRecipientInvitationRequest, Void> {
        private String recipientInvitationId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRecipientInvitationRequest o) {
            this.recipientInvitationId(o.getRecipientInvitationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRecipientInvitationRequest build() {
            GetRecipientInvitationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder recipientInvitationId(String recipientInvitationId) {
            this.recipientInvitationId = recipientInvitationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRecipientInvitationRequest buildWithoutInvocationCallback() {
            return new GetRecipientInvitationRequest(this.recipientInvitationId, this.opcRequestId);
        }

        public String toString() {
            return "GetRecipientInvitationRequest.Builder(recipientInvitationId=" + this.recipientInvitationId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

