/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import com.oracle.bmc.vault.VaultsAsync;
import com.oracle.bmc.vault.internal.http.CancelSecretDeletionConverter;
import com.oracle.bmc.vault.internal.http.CancelSecretVersionDeletionConverter;
import com.oracle.bmc.vault.internal.http.ChangeSecretCompartmentConverter;
import com.oracle.bmc.vault.internal.http.CreateSecretConverter;
import com.oracle.bmc.vault.internal.http.GetSecretConverter;
import com.oracle.bmc.vault.internal.http.GetSecretVersionConverter;
import com.oracle.bmc.vault.internal.http.ListSecretVersionsConverter;
import com.oracle.bmc.vault.internal.http.ListSecretsConverter;
import com.oracle.bmc.vault.internal.http.ScheduleSecretDeletionConverter;
import com.oracle.bmc.vault.internal.http.ScheduleSecretVersionDeletionConverter;
import com.oracle.bmc.vault.internal.http.UpdateSecretConverter;
import com.oracle.bmc.vault.requests.CancelSecretDeletionRequest;
import com.oracle.bmc.vault.requests.CancelSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.ChangeSecretCompartmentRequest;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretVersionRequest;
import com.oracle.bmc.vault.requests.ListSecretVersionsRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretDeletionRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.CancelSecretDeletionResponse;
import com.oracle.bmc.vault.responses.CancelSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.ChangeSecretCompartmentResponse;
import com.oracle.bmc.vault.responses.CreateSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretVersionResponse;
import com.oracle.bmc.vault.responses.ListSecretVersionsResponse;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretDeletionResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultsAsyncClient
implements VaultsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(VaultsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("VAULTS").serviceEndpointPrefix("").serviceEndpointTemplate("https://vaults.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public VaultsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public VaultsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public VaultsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public VaultsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<CancelSecretDeletionResponse> cancelSecretDeletion(CancelSecretDeletionRequest request, AsyncHandler<CancelSecretDeletionRequest, CancelSecretDeletionResponse> handler) {
        LOG.trace("Called async cancelSecretDeletion");
        CancelSecretDeletionRequest interceptedRequest = CancelSecretDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelSecretDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelSecretDeletionResponse> transformer = CancelSecretDeletionConverter.fromResponse();
        AsyncHandler<CancelSecretDeletionRequest, CancelSecretDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelSecretDeletionRequest, CancelSecretDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelSecretVersionDeletionResponse> cancelSecretVersionDeletion(CancelSecretVersionDeletionRequest request, AsyncHandler<CancelSecretVersionDeletionRequest, CancelSecretVersionDeletionResponse> handler) {
        LOG.trace("Called async cancelSecretVersionDeletion");
        CancelSecretVersionDeletionRequest interceptedRequest = CancelSecretVersionDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelSecretVersionDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelSecretVersionDeletionResponse> transformer = CancelSecretVersionDeletionConverter.fromResponse();
        AsyncHandler<CancelSecretVersionDeletionRequest, CancelSecretVersionDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelSecretVersionDeletionRequest, CancelSecretVersionDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeSecretCompartmentResponse> changeSecretCompartment(ChangeSecretCompartmentRequest request, AsyncHandler<ChangeSecretCompartmentRequest, ChangeSecretCompartmentResponse> handler) {
        LOG.trace("Called async changeSecretCompartment");
        ChangeSecretCompartmentRequest interceptedRequest = ChangeSecretCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSecretCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSecretCompartmentResponse> transformer = ChangeSecretCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeSecretCompartmentRequest, ChangeSecretCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeSecretCompartmentRequest, ChangeSecretCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSecretResponse> createSecret(CreateSecretRequest request, AsyncHandler<CreateSecretRequest, CreateSecretResponse> handler) {
        LOG.trace("Called async createSecret");
        CreateSecretRequest interceptedRequest = CreateSecretConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSecretConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSecretResponse> transformer = CreateSecretConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateSecretRequest, CreateSecretResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSecretRequest, CreateSecretResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSecretResponse> getSecret(GetSecretRequest request, AsyncHandler<GetSecretRequest, GetSecretResponse> handler) {
        LOG.trace("Called async getSecret");
        GetSecretRequest interceptedRequest = GetSecretConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSecretConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSecretResponse> transformer = GetSecretConverter.fromResponse();
        AsyncHandler<GetSecretRequest, GetSecretResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSecretRequest, GetSecretResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSecretVersionResponse> getSecretVersion(GetSecretVersionRequest request, AsyncHandler<GetSecretVersionRequest, GetSecretVersionResponse> handler) {
        LOG.trace("Called async getSecretVersion");
        GetSecretVersionRequest interceptedRequest = GetSecretVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSecretVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSecretVersionResponse> transformer = GetSecretVersionConverter.fromResponse();
        AsyncHandler<GetSecretVersionRequest, GetSecretVersionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSecretVersionRequest, GetSecretVersionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSecretVersionsResponse> listSecretVersions(ListSecretVersionsRequest request, AsyncHandler<ListSecretVersionsRequest, ListSecretVersionsResponse> handler) {
        LOG.trace("Called async listSecretVersions");
        ListSecretVersionsRequest interceptedRequest = ListSecretVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSecretVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSecretVersionsResponse> transformer = ListSecretVersionsConverter.fromResponse();
        AsyncHandler<ListSecretVersionsRequest, ListSecretVersionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSecretVersionsRequest, ListSecretVersionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSecretsResponse> listSecrets(ListSecretsRequest request, AsyncHandler<ListSecretsRequest, ListSecretsResponse> handler) {
        LOG.trace("Called async listSecrets");
        ListSecretsRequest interceptedRequest = ListSecretsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSecretsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSecretsResponse> transformer = ListSecretsConverter.fromResponse();
        AsyncHandler<ListSecretsRequest, ListSecretsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSecretsRequest, ListSecretsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScheduleSecretDeletionResponse> scheduleSecretDeletion(ScheduleSecretDeletionRequest request, AsyncHandler<ScheduleSecretDeletionRequest, ScheduleSecretDeletionResponse> handler) {
        LOG.trace("Called async scheduleSecretDeletion");
        ScheduleSecretDeletionRequest interceptedRequest = ScheduleSecretDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleSecretDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleSecretDeletionResponse> transformer = ScheduleSecretDeletionConverter.fromResponse();
        AsyncHandler<ScheduleSecretDeletionRequest, ScheduleSecretDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScheduleSecretDeletionRequest, ScheduleSecretDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScheduleSecretVersionDeletionResponse> scheduleSecretVersionDeletion(ScheduleSecretVersionDeletionRequest request, AsyncHandler<ScheduleSecretVersionDeletionRequest, ScheduleSecretVersionDeletionResponse> handler) {
        LOG.trace("Called async scheduleSecretVersionDeletion");
        ScheduleSecretVersionDeletionRequest interceptedRequest = ScheduleSecretVersionDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleSecretVersionDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleSecretVersionDeletionResponse> transformer = ScheduleSecretVersionDeletionConverter.fromResponse();
        AsyncHandler<ScheduleSecretVersionDeletionRequest, ScheduleSecretVersionDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScheduleSecretVersionDeletionRequest, ScheduleSecretVersionDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSecretResponse> updateSecret(UpdateSecretRequest request, AsyncHandler<UpdateSecretRequest, UpdateSecretResponse> handler) {
        LOG.trace("Called async updateSecret");
        UpdateSecretRequest interceptedRequest = UpdateSecretConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSecretConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSecretResponse> transformer = UpdateSecretConverter.fromResponse();
        AsyncHandler<UpdateSecretRequest, UpdateSecretResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSecretRequest, UpdateSecretResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, VaultsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public VaultsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new VaultsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

