/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.BinaryFloatCopyingBinder;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;

class BinaryFloatBinder
extends Binder {
    float paramVal;
    Binder theBinaryFloatCopyingBinder = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    static void init(Binder x2) {
        x2.type = (short)100;
        x2.bytelen = 4;
    }

    BinaryFloatBinder(float x2) {
        BinaryFloatBinder.init(this);
        this.paramVal = x2;
    }

    @Override
    Binder copyingBinder() {
        if (this.theBinaryFloatCopyingBinder == null) {
            this.theBinaryFloatCopyingBinder = new BinaryFloatCopyingBinder(this.paramVal);
        }
        return this.theBinaryFloatCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        int intBits;
        byte[] b2 = null;
        int offset = 0;
        float val = this.paramVal;
        int fixedLen = 4;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b2 = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b2 = bindBytes;
            offset = byteoffset;
        }
        if ((double)val == 0.0) {
            val = 0.0f;
        } else if (val != val) {
            val = Float.NaN;
        }
        int b3 = intBits = Float.floatToIntBits(val);
        int b22 = intBits >>= 8;
        int b1 = intBits >>= 8;
        int b0 = intBits >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b22 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
        }
        b2[offset + 3] = (byte)b3;
        b2[offset + 2] = (byte)b22;
        b2[offset + 1] = (byte)b1;
        b2[offset] = (byte)b0;
        if (bindUseDBA) {
            bindData.put(b2, 0, fixedLen);
            stmt.lastBoundDataLengths[bindPosition] = fixedLen;
            bindDataLengths[bindDataIndex] = fixedLen;
        }
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)fixedLen;
        return localCheckSum;
    }

    static {
        try {
            $$$methodRef$$$3 = BinaryFloatBinder.class.getDeclaredConstructor(Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BinaryFloatBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BinaryFloatBinder.class.getDeclaredMethod("copyingBinder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BinaryFloatBinder.class.getDeclaredMethod("init", Binder.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

