/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementCacheEntry;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.STATEMENT_CACHE})
class LRUStatementCache {
    private int cacheSize;
    private int numElements;
    private OracleStatementCacheEntry applicationCacheStart;
    private OracleStatementCacheEntry applicationCacheEnd;
    private OracleStatementCacheEntry implicitCacheStart;
    private OracleStatementCacheEntry explicitCacheStart;
    boolean implicitCacheEnabled;
    boolean explicitCacheEnabled;
    private boolean debug;
    static final String DMS_HIT_COUNT_NAME = "StatementCacheHit";
    static final String DMS_HIT_COUNT_DESCRIPTION = "Statement found in cache";
    static final String DMS_MISS_COUNT_NAME = "StatementCacheMiss";
    static final String DMS_MISS_COUNT_DESCRIPTION = "Statement not found in cache";
    EventIntf dmsStatementCacheHitCount;
    EventIntf dmsStatementCacheMissCount;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    protected LRUStatementCache(int size) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$20, null, size);
            }
            this.debug = false;
            this.dmsStatementCacheHitCount = null;
            this.dmsStatementCacheMissCount = null;
            if (size < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$20, null, sQLException);
                }
                throw sQLException;
            }
            this.cacheSize = size;
            this.numElements = 0;
            this.implicitCacheStart = null;
            this.explicitCacheStart = null;
            this.implicitCacheEnabled = false;
            this.explicitCacheEnabled = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createDMSSensors(NounIntf nounIntf) {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void parent;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this, nounIntf);
            }
            this.dmsStatementCacheHitCount = DMSFactory.createEvent((NounIntf)parent, DMS_HIT_COUNT_NAME, DMS_HIT_COUNT_DESCRIPTION);
            this.dmsStatementCacheMissCount = DMSFactory.createEvent((NounIntf)parent, DMS_MISS_COUNT_NAME, DMS_MISS_COUNT_DESCRIPTION);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void resize(int n2) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void newSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, n2);
            }
            if (newSize < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            if (newSize >= this.cacheSize || newSize >= this.numElements) {
                this.cacheSize = newSize;
            } else {
                OracleStatementCacheEntry e2 = this.applicationCacheEnd;
                while (this.numElements > newSize) {
                    this.purgeCacheEntry(e2);
                    e2 = e2.applicationPrev;
                }
                this.cacheSize = newSize;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this, bl);
            }
            if (cache == false) {
                this.purgeImplicitCache();
            }
            this.implicitCacheEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, new Object[0]);
            }
            boolean retValue = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
            boolean bl2 = retValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this, bl);
            }
            if (cache == false) {
                this.purgeExplicitCache();
            }
            this.explicitCacheEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean retValue = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
            boolean bl2 = retValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addToImplicitCache(OraclePreparedStatement oraclePreparedStatement, String string, int n2, int n3) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void scrollType;
            void statementType;
            void sql;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, oraclePreparedStatement, string, n2, n3);
            }
            if (!this.implicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "implicit caching not enabled or already cached, returning...");
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, null);
                }
                return;
            }
            if (this.numElements == this.cacheSize) {
                this.purgeCacheEntry(this.applicationCacheEnd);
            }
            stmt.enterImplicitCache();
            OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
            entry.statement = stmt;
            entry.onImplicit = true;
            entry.sql = sql;
            entry.statementType = statementType;
            entry.scrollType = scrollType;
            entry.applicationNext = this.applicationCacheStart;
            entry.applicationPrev = null;
            if (this.applicationCacheStart != null) {
                this.applicationCacheStart.applicationPrev = entry;
            }
            this.applicationCacheStart = entry;
            entry.implicitNext = this.implicitCacheStart;
            entry.implicitPrev = null;
            if (this.implicitCacheStart != null) {
                this.implicitCacheStart.implicitPrev = entry;
            }
            this.implicitCacheStart = entry;
            if (this.applicationCacheEnd == null) {
                this.applicationCacheEnd = entry;
            }
            ++this.numElements;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addToExplicitCache(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void key;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, oraclePreparedStatement, string);
            }
            if (!this.explicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, null);
                }
                return;
            }
            if (this.numElements == this.cacheSize) {
                this.purgeCacheEntry(this.applicationCacheEnd);
            }
            stmt.enterExplicitCache();
            OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
            entry.statement = stmt;
            entry.sql = key;
            entry.onImplicit = false;
            entry.applicationNext = this.applicationCacheStart;
            entry.applicationPrev = null;
            if (this.applicationCacheStart != null) {
                this.applicationCacheStart.applicationPrev = entry;
            }
            this.applicationCacheStart = entry;
            entry.explicitNext = this.explicitCacheStart;
            entry.explicitPrev = null;
            if (this.explicitCacheStart != null) {
                this.explicitCacheStart.explicitPrev = entry;
            }
            this.explicitCacheStart = entry;
            if (this.applicationCacheEnd == null) {
                this.applicationCacheEnd = entry;
            }
            ++this.numElements;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected OracleStatement searchImplicitCache(String string, int n2, int n3, PhysicalConnection physicalConnection) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            void scrollType;
            void statementType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, string, n2, n3, physicalConnection);
            }
            if (!this.implicitCacheEnabled) {
                OracleStatement oracleStatement = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, oracleStatement);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, null);
                }
                return null;
            }
            OracleStatementCacheEntry entry = null;
            entry = this.implicitCacheStart;
            while (!(entry == null || entry.statementType == statementType && entry.scrollType == scrollType && entry.sql.equals(sql))) {
                entry = entry.implicitNext;
            }
            if (entry != null) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "searchImplicitCache: Found statement with key " + (String)sql + "$$" + (int)statementType + "$$" + (int)scrollType);
                }
                this.dmsStatementCacheHitCount.occurred();
                if (entry.applicationPrev != null) {
                    entry.applicationPrev.applicationNext = entry.applicationNext;
                }
                if (entry.applicationNext != null) {
                    entry.applicationNext.applicationPrev = entry.applicationPrev;
                }
                if (this.applicationCacheStart == entry) {
                    this.applicationCacheStart = entry.applicationNext;
                }
                if (this.applicationCacheEnd == entry) {
                    this.applicationCacheEnd = entry.applicationPrev;
                }
                if (entry.implicitPrev != null) {
                    entry.implicitPrev.implicitNext = entry.implicitNext;
                }
                if (entry.implicitNext != null) {
                    entry.implicitNext.implicitPrev = entry.implicitPrev;
                }
                if (this.implicitCacheStart == entry) {
                    this.implicitCacheStart = entry.implicitNext;
                }
                --this.numElements;
                entry.statement.exitImplicitCacheToActive();
                OraclePreparedStatement oraclePreparedStatement = entry.statement;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, oraclePreparedStatement);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, null);
                }
                return oraclePreparedStatement;
            }
            OracleStatement stmt = null;
            this.dmsStatementCacheMissCount.occurred();
            OracleStatement oracleStatement = stmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, oracleStatement);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, null);
            }
            return oracleStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected OracleStatement searchExplicitCache(String string) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void key;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, string);
            }
            if (!this.explicitCacheEnabled) {
                OracleStatement oracleStatement = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, oracleStatement);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            OracleStatementCacheEntry entry = null;
            entry = this.explicitCacheStart;
            while (entry != null && !entry.sql.equals(key)) {
                entry = entry.explicitNext;
            }
            if (entry != null) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$9, Level.FINEST, this.getClass(), $$$methodRef$$$9, "searchExplicitCache: Found statement with key " + entry.sql);
                }
                this.dmsStatementCacheHitCount.occurred();
                if (entry.applicationPrev != null) {
                    entry.applicationPrev.applicationNext = entry.applicationNext;
                }
                if (entry.applicationNext != null) {
                    entry.applicationNext.applicationPrev = entry.applicationPrev;
                }
                if (this.applicationCacheStart == entry) {
                    this.applicationCacheStart = entry.applicationNext;
                }
                if (this.applicationCacheEnd == entry) {
                    this.applicationCacheEnd = entry.applicationPrev;
                }
                if (entry.explicitPrev != null) {
                    entry.explicitPrev.explicitNext = entry.explicitNext;
                }
                if (entry.explicitNext != null) {
                    entry.explicitNext.explicitPrev = entry.explicitPrev;
                }
                if (this.explicitCacheStart == entry) {
                    this.explicitCacheStart = entry.explicitNext;
                }
                --this.numElements;
                entry.statement.exitExplicitCacheToActive();
                OraclePreparedStatement oraclePreparedStatement = entry.statement;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, oraclePreparedStatement);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, null);
                }
                return oraclePreparedStatement;
            }
            this.dmsStatementCacheMissCount.occurred();
            OracleStatement oracleStatement = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, oracleStatement);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void purgeImplicitCache() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OracleStatementCacheEntry entry = this.implicitCacheStart;
            while (entry != null) {
                this.purgeCacheEntry(entry);
                entry = entry.implicitNext;
            }
            this.implicitCacheStart = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void purgeExplicitCache() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this, new Object[0]);
            }
            OracleStatementCacheEntry entry = this.explicitCacheStart;
            while (entry != null) {
                this.purgeCacheEntry(entry);
                entry = entry.explicitNext;
            }
            this.explicitCacheStart = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void purgeCacheEntry(OracleStatementCacheEntry oracleStatementCacheEntry) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, oracleStatementCacheEntry);
            }
            if (entry.applicationNext != null) {
                entry.applicationNext.applicationPrev = entry.applicationPrev;
            }
            if (entry.applicationPrev != null) {
                entry.applicationPrev.applicationNext = entry.applicationNext;
            }
            if (this.applicationCacheStart == entry) {
                this.applicationCacheStart = entry.applicationNext;
            }
            if (this.applicationCacheEnd == entry) {
                this.applicationCacheEnd = entry.applicationPrev;
            }
            OraclePreparedStatement pstmt = entry.statement;
            if (entry.onImplicit) {
                if (entry.implicitNext != null) {
                    entry.implicitNext.implicitPrev = entry.implicitPrev;
                }
                if (entry.implicitPrev != null) {
                    entry.implicitPrev.implicitNext = entry.implicitNext;
                }
                if (this.implicitCacheStart == entry) {
                    this.implicitCacheStart = entry.implicitNext;
                }
            } else {
                if (entry.explicitNext != null) {
                    entry.explicitNext.explicitPrev = entry.explicitPrev;
                }
                if (entry.explicitPrev != null) {
                    entry.explicitPrev.explicitNext = entry.explicitNext;
                }
                if (this.explicitCacheStart == entry) {
                    this.explicitCacheStart = entry.explicitNext;
                }
            }
            --this.numElements;
            entry.statement.exitExplicitCacheToClose();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getCacheSize() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, new Object[0]);
            }
            int n2 = this.cacheSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, n2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printCache(String string) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void msg;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, string);
            }
            System.out.println("*** Start of Statement Cache Dump (" + (String)msg + ") ***");
            System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled + " explicit enabled: " + this.explicitCacheEnabled);
            System.out.println("applicationStart: " + this.applicationCacheStart + "  applicationEnd: " + this.applicationCacheEnd);
            OracleStatementCacheEntry e2 = this.applicationCacheStart;
            while (e2 != null) {
                e2.print();
                e2 = e2.applicationNext;
            }
            System.out.println("implicitStart: " + this.implicitCacheStart);
            e2 = this.implicitCacheStart;
            while (e2 != null) {
                e2.print();
                e2 = e2.implicitNext;
            }
            System.out.println("explicitStart: " + this.explicitCacheStart);
            e2 = this.explicitCacheStart;
            while (e2 != null) {
                e2.print();
                e2 = e2.explicitNext;
            }
            System.out.println("*** End of Statement Cache Dump (" + (String)msg + ") ***");
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public void close() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this, new Object[0]);
            }
            OracleStatementCacheEntry entry = this.applicationCacheStart;
            while (entry != null) {
                if (entry.onImplicit) {
                    entry.statement.exitImplicitCacheToClose();
                } else {
                    entry.statement.exitExplicitCacheToClose();
                }
                entry = entry.applicationNext;
            }
            this.applicationCacheStart = null;
            this.applicationCacheEnd = null;
            this.implicitCacheStart = null;
            this.explicitCacheStart = null;
            this.numElements = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    int getNumberOfStatementsInCache() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, this, new Object[0]);
            }
            int n2 = this.numElements;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, this, n2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    String[] getCachedStrings() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, this, new Object[0]);
            }
            int _numElements = this.numElements;
            String[] cachedStrings = new String[_numElements];
            OracleStatementCacheEntry e2 = this.applicationCacheEnd;
            for (int i2 = 0; i2 < _numElements; ++i2) {
                cachedStrings[i2] = e2.statement.sqlObject.getOriginalSql();
                e2 = e2.applicationPrev;
            }
            String[] stringArray = cachedStrings;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, this, stringArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, this, null);
            }
            return cachedStrings;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void clearCursorIds() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, this, new Object[0]);
            }
            OracleStatementCacheEntry e2 = this.applicationCacheStart;
            while (e2 != null) {
                e2.statement.clearCursorId();
                e2 = e2.applicationNext;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$20 = LRUStatementCache.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = LRUStatementCache.class.getDeclaredMethod("clearCursorIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LRUStatementCache.class.getDeclaredMethod("getCachedStrings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LRUStatementCache.class.getDeclaredMethod("getNumberOfStatementsInCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LRUStatementCache.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LRUStatementCache.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LRUStatementCache.class.getDeclaredMethod("printCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LRUStatementCache.class.getDeclaredMethod("getCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LRUStatementCache.class.getDeclaredMethod("purgeCacheEntry", OracleStatementCacheEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LRUStatementCache.class.getDeclaredMethod("purgeExplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LRUStatementCache.class.getDeclaredMethod("purgeImplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LRUStatementCache.class.getDeclaredMethod("searchExplicitCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LRUStatementCache.class.getDeclaredMethod("searchImplicitCache", String.class, Integer.TYPE, Integer.TYPE, PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LRUStatementCache.class.getDeclaredMethod("addToExplicitCache", OraclePreparedStatement.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LRUStatementCache.class.getDeclaredMethod("addToImplicitCache", OraclePreparedStatement.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LRUStatementCache.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LRUStatementCache.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LRUStatementCache.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LRUStatementCache.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LRUStatementCache.class.getDeclaredMethod("resize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LRUStatementCache.class.getDeclaredMethod("createDMSSensors", NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

