/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
class NTFListener
extends Thread {
    private ArrayList<NTFConnection> connections;
    private int nbOfConnections;
    private boolean needsToBeClosed;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    public Properties socketOptions;
    private Exception[] connectionCreationExceptionArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    NTFListener(NTFManager _dcnManager, ServerSocketChannel _ssChannel, int _tcpport, Properties _socketOptions, Exception[] _connectionCreationExceptionArr) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null, _dcnManager, _ssChannel, _tcpport, _socketOptions, _connectionCreationExceptionArr);
            }
            this.nbOfConnections = 0;
            this.needsToBeClosed = false;
            this.dcnManager = _dcnManager;
            this.connections = new ArrayList(10);
            this.ssChannel = _ssChannel;
            this.tcpport = _tcpport;
            this.socketOptions = _socketOptions;
            this.connectionCreationExceptionArr = _connectionCreationExceptionArr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block20: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, new Object[0]);
                }
                try {
                    Selector selector = Selector.open();
                    this.ssChannel.register(selector, 16);
                    block9: while (true) {
                        selector.select();
                        if (this.needsToBeClosed) break;
                        Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                        while (true) {
                            block19: {
                                if (!iterator.hasNext()) continue block9;
                                SelectionKey aKey = iterator.next();
                                if ((aKey.readyOps() & 0x10) != 16) continue;
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + ") thread: OP_ACCEPT");
                                }
                                ServerSocketChannel server = (ServerSocketChannel)aKey.channel();
                                SocketChannel connectionChannel = server.accept();
                                try {
                                    NTFConnection conn = new NTFConnection(this.dcnManager, connectionChannel, this);
                                    ArrayList<NTFConnection> arrayList = this.connections;
                                    synchronized (arrayList) {
                                        try {
                                            this.connections.add(conn);
                                        }
                                        catch (Throwable throwable) {
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5, 9, 10] lbl32 : MonitorExitStatement: MONITOREXIT : var7_10
                                            Throwable throwable2 = throwable;
                                            if (bl) {
                                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, throwable2);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    conn.start();
                                    if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                                        this.connectionCreationExceptionArr[0] = null;
                                    }
                                }
                                catch (IOException ioe) {
                                    if (bl) {
                                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + "): ERROR: got IOException during connection creation in listener thread execution: " + ioe.getMessage());
                                    }
                                    if (this.connectionCreationExceptionArr == null || this.connectionCreationExceptionArr.length <= 0) break block19;
                                    this.connectionCreationExceptionArr[0] = ioe;
                                }
                            }
                            iterator.remove();
                        }
                        break;
                    }
                    selector.close();
                    this.ssChannel.close();
                }
                catch (IOException ioe) {
                    if (!bl) break block20;
                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + "): ERROR: got IOException during thread execution: " + ioe.getMessage());
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + "): end of run method. Thread will be closed.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeThisListener() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFListener (tcpport=" + this.tcpport + ") closing listener");
            }
            ArrayList<NTFConnection> arrayList = this.connections;
            synchronized (arrayList) {
                try {
                    for (NTFConnection conn : this.connections) {
                        conn.closeThisConnection();
                        conn.interrupt();
                    }
                    this.needsToBeClosed = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void releaseConnection(NTFConnection nTFConnection) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, nTFConnection);
            }
            ArrayList<NTFConnection> arrayList = this.connections;
            synchronized (arrayList) {
                try {
                    void conn;
                    this.connections.remove(conn);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : var2_3
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFListener (tcpport=" + this.tcpport + ") connection released");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, throwable3);
            }
            throw throwable;
        }
    }

    Exception getRegistrationException() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                Exception exception = this.connectionCreationExceptionArr[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, exception);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, null);
                }
                return exception;
            }
            Exception exception = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, exception);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = NTFListener.class.getDeclaredConstructor(NTFManager.class, ServerSocketChannel.class, Integer.TYPE, Properties.class, Exception[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFListener.class.getDeclaredMethod("getRegistrationException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFListener.class.getDeclaredMethod("releaseConnection", NTFConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFListener.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFListener.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

