/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.nt.TcpsNTAdapter;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5Logon;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

@Supports(value={Feature.CONNECT})
@DefaultLogger(value="oracle.jdbc")
final class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] enableTempLobRefCnt;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName;
    byte[] driverName;
    String ressourceManagerId;
    boolean bUseO5Logon;
    int verifierType;
    static final int ZTVT_ORCL_7 = 2361;
    static final int ZTVT_SSH1 = 6949;
    static final int ZTVT_NTV = 7809;
    static final int ZTVT_SMD5 = 59694;
    static final int ZTVT_MD5 = 40674;
    static final int ZTVT_SH1 = 45394;
    static final int ZTVT_SHA512 = 18453;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_SESSION_QCACHE = 0x800000;
    static final int KPZ_LOGON_SYSBKP = 0x1000000;
    static final int KPZ_LOGON_SYSDGD = 0x2000000;
    static final int KPZ_LOGON_SYSKMT = 0x4000000;
    static final int KPZ_CPW_AUTH = 16;
    static final int KPZ_OPASSWD_ENCRYPTED = 32;
    static final int KPZ_NPASSWD_ENCRYPTED = 64;
    static final int KPZ_NPASSWD_OBFUSCATE = 65536;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_NEWPASSWORD = "AUTH_NEWPASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_DB_ID = "AUTH_DB_ID";
    static final String AUTH_QCACHE_MAXSIZE = "AUTH_QCACHE_MAXSIZE";
    static final String AUTH_QCACHE_CACHELAG = "AUTH_QCACHE_CACHELAG";
    static final String AUTH_GLOBALLY_UNIQUE_DBID = "AUTH_GLOBALLY_UNIQUE_DBID";
    static final String AUTH_QCACHE_CACHEID = "AUTH_QCACHE_CACHEID";
    static final String AUTH_QCACHE_REGID = "AUTH_QCACHE_REGID";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SC_DB_DOMAIN = "AUTH_SC_DB_DOMAIN";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXNLSCOMP = "AUTH_NLS_LXNLSCOMP";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
    static final String AUTH_KPPL_CONN_CLASS = "AUTH_KPPL_CONN_CLASS";
    static final String AUTH_KPPL_PURITY = "AUTH_KPPL_PURITY";
    static final String AUTH_KPPL_TAG = "AUTH_KPPL_TAG";
    static final String AUTH_KPPL_IS_MULTIPROP_TAG = "AUTH_KPPL_IS_MULTIPROP_TAG";
    static final String AUTH_KPPL_FIXUP_CB = "AUTH_KPPL_FIXUP_CB";
    static final String AUTH_KPPL_WAIT = "AUTH_KPPL_WAIT";
    static final String AUTH_PBKDF2_SPEEDY_KEY = "AUTH_PBKDF2_SPEEDY_KEY";
    static final String KPPL_PURITY_DEFAULT = "0";
    static final String KPPL_PURITY_NEW = "1";
    static final String KPPL_PURITY_SELF = "2";
    static final String SESS_PURITY_DEFAULT = "DEFAULT";
    static final String SESS_PURITY_NEW = "NEW";
    static final String SESS_PURITY_SELF = "SELF";
    static final String[][] KPPL_PURITY;
    static final String AUTH_CONNECT_STRING = "AUTH_CONNECT_STRING";
    static final String DRIVER_NAME_DEFAULT = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_AUDIT_BANNER = "AUTH_AUDIT_BANNER";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    public static final int AUTH_FLAG_O5LOGON = 0;
    public static final int AUTH_FLAG_NONO5LOGON = 1;
    String sessionTimeZone;
    private T4CKvaldfList keyValList;
    private byte[] user;
    private long logonMode;
    private byte[][] outKeys;
    private byte[][] outValues;
    private int[] outFlags;
    private int outNbPairs;
    private byte[] PBKDF2Salt;
    private int PBKDF2VgenCount;
    private int PBKDF2SderCount;
    O5Logon o5logonHelper;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    T4CTTIoauthenticate(T4CConnection _conn, String _ressourceManagerId) throws SQLException {
        super(_conn, (byte)3);
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, null, _conn, _ressourceManagerId);
            }
            this.editionName = null;
            this.isSessionTZ = true;
            this.sessionTimeZone = null;
            this.keyValList = null;
            this.user = null;
            this.outKeys = null;
            this.outValues = null;
            this.outFlags = new int[0];
            this.outNbPairs = 0;
            this.o5logonHelper = null;
            this.ressourceManagerId = _ressourceManagerId;
            this.setSessionFields(_conn);
            this.isSessionTZ = true;
            this.bUseO5Logon = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.user != null && this.user.length > 0) {
                this.meg.marshalPTR();
                this.meg.marshalSB4(this.user.length);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSB4(0);
            }
            this.meg.marshalUB4(this.logonMode);
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.keyValList.size());
            this.meg.marshalPTR();
            this.meg.marshalPTR();
            if (this.user != null && this.user.length > 0) {
                this.meg.marshalCHR(this.user);
            }
            this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doOAUTH(byte[] byArray, @Blind byte[] byArray2, @Blind byte[] byArray3, long l2, String string, boolean bl, byte[] byArray4, byte[] byArray5, byte[][] byArray6, int n2, int n3, byte[] byArray7) throws IOException, SQLException {
        boolean bl2 = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void gl_serial_nb;
            void gl_session_id;
            void proxyCertificate;
            void proxyDN;
            void proxyRoles;
            void speedyKey;
            void lnewPassword;
            void authenticationAdaptor;
            void lpassword;
            void proxyAuthentication;
            void llogonMode;
            void luser;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this, new Object[]{byArray, "*****", "*****", l2, string, bl, byArray4, byArray5, byArray6, n2, n3, byArray7});
            }
            this.setFunCode((short)115);
            this.user = luser;
            this.logonMode = llogonMode | 1L;
            if (this.connection.isResultSetCacheEnabled) {
                this.logonMode |= 0x800000L;
            }
            if (proxyAuthentication != false) {
                this.logonMode |= 0x400L;
            }
            if (luser != null && ((void)luser).length != 0 && lpassword != null && authenticationAdaptor != "RADIUS") {
                this.logonMode |= 0x100L;
            }
            this.keyValList = new T4CKvaldfList(this.meg.conv);
            if (lpassword != null) {
                this.keyValList.add(AUTH_PASSWORD, (byte[])lpassword);
            }
            if (lnewPassword != null) {
                this.logonMode |= 0x12L;
                this.logonMode ^= 1L;
                this.keyValList.add(AUTH_NEWPASSWORD, (byte[])lnewPassword);
            }
            if (speedyKey != null) {
                this.keyValList.add(AUTH_PBKDF2_SPEEDY_KEY, (byte[])speedyKey);
            }
            if (proxyRoles != null) {
                for (int i2 = 0; i2 < ((void)proxyRoles).length; ++i2) {
                    this.keyValList.add(AUTH_INITIAL_CLIENT_ROLE, (byte[])proxyRoles[i2]);
                }
            }
            if (proxyDN != null) {
                this.keyValList.add(AUTH_CLIENT_DN, (byte[])proxyDN);
            }
            if (proxyCertificate != null) {
                this.keyValList.add(AUTH_CLIENT_CERTIFICATE, (byte[])proxyCertificate);
            }
            this.keyValList.add(AUTH_TERMINAL, this.terminal);
            if (this.bUseO5Logon && this.encryptedKB != null) {
                this.keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
            }
            if (this.programName != null) {
                this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
            }
            if (this.clientname != null) {
                this.keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
            }
            this.keyValList.add(AUTH_MACHINE, this.machine);
            this.keyValList.add(AUTH_PID, this.processID);
            if (!this.ressourceManagerId.equals("0000")) {
                byte[] key = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
                key[key.length - 1] = 0;
                this.keyValList.add(key, this.internalName);
                key = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
                key[key.length - 1] = 0;
                this.keyValList.add(key, this.externalName);
            }
            this.keyValList.add(AUTH_ACL, this.aclValue);
            this.keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
            if (this.editionName != null) {
                this.keyValList.add(AUTH_ORA_EDITION, this.editionName);
            }
            this.keyValList.add(SESSION_CLIENT_LOBATTR, this.enableTempLobRefCnt);
            this.keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.driverName);
            this.keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
            if (gl_session_id != -1) {
                this.keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString((int)gl_session_id)));
            }
            if (gl_serial_nb != -1) {
                this.keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString((int)gl_serial_nb)));
            }
            if (this.connection.drcpEnabled) {
                if (this.connection.drcpConnectionClass != null && this.connection.drcpConnectionClass != "") {
                    this.keyValList.add(AUTH_KPPL_CONN_CLASS, this.meg.conv.StringToCharBytes(this.connection.drcpConnectionClass));
                }
                this.keyValList.add(AUTH_KPPL_PURITY, this.meg.conv.StringToCharBytes(this.getKPPLPurity()));
                if (this.connection.drcpTagName != null) {
                    this.keyValList.add(AUTH_KPPL_TAG, this.meg.conv.StringToCharBytes(this.connection.drcpTagName));
                    if (this.connection.useDRCPMultipletag) {
                        this.keyValList.add(AUTH_KPPL_IS_MULTIPROP_TAG, this.meg.conv.StringToCharBytes("TRUE"));
                    }
                }
                if (this.connection.drcpPLSQLCallback != null && this.connection.drcpPLSQLCallback.length() > 0 && this.connection.getTTCVersion() >= 8) {
                    this.keyValList.add(AUTH_KPPL_FIXUP_CB, this.meg.conv.StringToCharBytes(this.connection.drcpPLSQLCallback));
                }
            }
            this.keyValList.add(AUTH_CONNECT_STRING, this.meg.conv.StringToCharBytes(this.connection.net.getConnectionString()));
            if (this.connection.isResultSetCacheActive()) {
                this.keyValList.add(AUTH_QCACHE_CACHEID, this.connection.getResultSetCacheIdAsNibbles());
                this.keyValList.add(AUTH_QCACHE_REGID, this.meg.conv.StringToCharBytes(Long.toString(this.connection.getResultSetCacheRegistrationId())));
            }
            this.keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
            this.outNbPairs = 0;
            this.outKeys = null;
            this.outValues = null;
            this.outFlags = new int[0];
            this.doRPC();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOSESSKEY(String string, long l2) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void llogonMode;
            void userName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, string, l2);
            }
            this.setFunCode((short)118);
            this.user = this.meg.conv.StringToCharBytes((String)userName);
            this.logonMode = llogonMode | 1L;
            this.keyValList = new T4CKvaldfList(this.meg.conv);
            this.keyValList.add(AUTH_TERMINAL, this.terminal);
            if (this.programName != null) {
                this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
            }
            this.keyValList.add(AUTH_MACHINE, this.machine);
            this.keyValList.add(AUTH_PID, this.processID);
            this.keyValList.add(AUTH_SID, this.sysUserName);
            this.outNbPairs = 0;
            this.outKeys = null;
            this.outValues = null;
            this.outFlags = new int[0];
            this.doRPC();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRPA() throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.outNbPairs = this.meg.unmarshalUB2();
            this.outKeys = new byte[this.outNbPairs][];
            this.outValues = new byte[this.outNbPairs][];
            this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void processError() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this, new Object[0]);
            }
            if (this.getFunCode() == 118) {
                if (this.oer.getRetCode() != 28035L || this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
                    this.oer.processError();
                }
            } else {
                super.processError();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void processRPA() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.getFunCode() == 115) {
                Properties connectionValues = new Properties();
                for (int i2 = 0; i2 < this.outNbPairs; ++i2) {
                    String keyStr = this.meg.conv.CharBytesToString(this.outKeys[i2], this.outKeys[i2].length).trim();
                    String valueStr = "";
                    if (this.outValues[i2] != null) {
                        valueStr = this.meg.conv.CharBytesToString(this.outValues[i2], this.outValues[i2].length).trim();
                    }
                    connectionValues.setProperty(keyStr, valueStr);
                }
                String versionNoStr = connectionValues.getProperty(AUTH_VERSION_NO);
                if (versionNoStr != null) {
                    try {
                        int serverVersionInt = new Integer(versionNoStr);
                        if (bl) {
                            this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "Server version at connection:" + this.versionIntToString(serverVersionInt));
                        }
                    }
                    catch (NumberFormatException serverVersionInt) {
                        // empty catch block
                    }
                }
                connectionValues.setProperty("SERVER_HOST", connectionValues.getProperty(AUTH_SC_SERVER_HOST, ""));
                connectionValues.setProperty("INSTANCE_NAME", connectionValues.getProperty(AUTH_SC_INSTANCE_NAME, ""));
                connectionValues.setProperty("DATABASE_NAME", connectionValues.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
                connectionValues.setProperty("SERVICE_NAME", connectionValues.getProperty(AUTH_SC_SERVICE_NAME, ""));
                connectionValues.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
                if (this.connection.sessionProperties != null) {
                    this.connection.sessionProperties.putAll((Map<?, ?>)connectionValues);
                } else {
                    this.connection.sessionProperties = connectionValues;
                }
            } else if (this.getFunCode() == 118) {
                Properties connectionValues = new Properties();
                for (int i3 = 0; i3 < this.outNbPairs; ++i3) {
                    String keyStr = this.meg.conv.CharBytesToString(this.outKeys[i3], this.outKeys[i3].length).trim();
                    String valueStr = "";
                    if (this.outValues[i3] != null) {
                        valueStr = this.meg.conv.CharBytesToString(this.outValues[i3], this.outValues[i3].length).trim();
                    }
                    if (keyStr.compareTo(AUTH_GLOBALLY_UNIQUE_DBID) != 0 && keyStr.compareTo(AUTH_QCACHE_MAXSIZE) != 0 && keyStr.compareTo(AUTH_QCACHE_CACHELAG) != 0) continue;
                    connectionValues.setProperty(keyStr, valueStr);
                }
                if (this.connection.sessionProperties != null) {
                    this.connection.sessionProperties.putAll((Map<?, ?>)connectionValues);
                } else {
                    this.connection.sessionProperties = connectionValues;
                }
                if (this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
                    if (this.outKeys == null || this.outKeys.length < 1) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, sQLException);
                        }
                        throw sQLException;
                    }
                    int indexOfSessKey = -1;
                    int indexOfVfrDat = -1;
                    int indexOfPBKDF2Salt = -1;
                    int indexOfPBKDF2VgenCount = -1;
                    int indexOfPBKDF2SderCount = -1;
                    try {
                        for (int i4 = 0; i4 < this.outKeys.length; ++i4) {
                            String sKey = new String(this.outKeys[i4], "US-ASCII");
                            if (sKey.equals(AUTH_SESSKEY)) {
                                indexOfSessKey = i4;
                            } else if (sKey.equals(AUTH_VFR_DATA)) {
                                indexOfVfrDat = i4;
                            } else if (sKey.equals("AUTH_PBKDF2_CSK_SALT")) {
                                indexOfPBKDF2Salt = i4;
                            } else if (sKey.equals("AUTH_PBKDF2_VGEN_COUNT")) {
                                indexOfPBKDF2VgenCount = i4;
                            } else if (sKey.equals("AUTH_PBKDF2_SDER_COUNT")) {
                                indexOfPBKDF2SderCount = i4;
                            }
                            if (indexOfVfrDat == -1 || indexOfSessKey == -1 || indexOfPBKDF2Salt == -1 || indexOfPBKDF2VgenCount == -1 || indexOfPBKDF2SderCount == -1) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (indexOfSessKey == -1) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.encryptedSK = this.outValues[indexOfSessKey];
                    if (indexOfVfrDat != -1) {
                        this.bUseO5Logon = true;
                        this.salt = this.outValues[indexOfVfrDat];
                        this.verifierType = this.outFlags[indexOfVfrDat];
                        if (this.connection.allowedLogonVersion.equals("12a") && this.verifierType != 18453) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, sQLException);
                            }
                            throw sQLException;
                        }
                        if (this.connection.allowedLogonVersion.equals("12") && this.verifierType != 18453 && (this.verifierType != 6949 && this.verifierType != 45394 || !this.connection.hasServerCompileTimeCapability(4, 2))) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 292).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    if (indexOfPBKDF2Salt != -1) {
                        this.PBKDF2Salt = this.outValues[indexOfPBKDF2Salt];
                    }
                    if (indexOfPBKDF2VgenCount != -1) {
                        try {
                            this.PBKDF2VgenCount = Integer.parseInt(new String(this.outValues[indexOfPBKDF2VgenCount], "US-ASCII"));
                            if (this.PBKDF2VgenCount < 4096) {
                                this.PBKDF2VgenCount = 4096;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (indexOfPBKDF2SderCount != -1) {
                        try {
                            this.PBKDF2SderCount = Integer.parseInt(new String(this.outValues[indexOfPBKDF2SderCount], "US-ASCII"));
                            if (this.PBKDF2SderCount < 3) {
                                this.PBKDF2SderCount = 3;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAUTH(String string, @Blind String string2, @Blind String string3, long l2) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void logonMode;
            void newPasswordStr;
            void passwordStr;
            void userStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this, string, "*****", "*****", l2);
            }
            this.doOAUTH((String)userStr, (String)passwordStr, (String)newPasswordStr, (long)logonMode, -1, -1, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAUTH(String string, @Blind String string2, @Blind String string3, long l2, int n2, int n3, byte[][] byArray) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void proxyRoles;
            void gl_serial_nb;
            void gl_session_id;
            void logonMode;
            void userStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, new Object[]{string, "*****", "*****", l2, n2, n3, byArray});
            }
            byte[] user = null;
            if (userStr != null && userStr.length() > 0) {
                user = this.meg.conv.StringToCharBytes((String)userStr);
            }
            byte[] passwordNet = null;
            byte[] newPasswordNet = null;
            byte[] paddedPwd = null;
            Object newPaddedPwd = null;
            byte[] password = null;
            byte[] newPassword = null;
            byte[] encryptedPk = null;
            String authenticationAdaptor = this.connection.net.getAuthenticationAdaptorName();
            if (userStr != null && userStr.length() != 0) {
                byte pwdPadLen;
                void newPasswordStr;
                Object passwordStr;
                if (authenticationAdaptor != "RADIUS" && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
                if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
                String trimUser = userStr.trim();
                String trimPwd = null;
                String trimNewPwd = null;
                if (passwordStr != null) {
                    trimPwd = passwordStr.trim();
                }
                if (newPasswordStr != null) {
                    trimNewPwd = newPasswordStr.trim();
                }
                passwordStr = null;
                String noQuotesUser = trimUser;
                String noQuotesPwd = trimPwd;
                String noQuotesNewPwd = trimNewPwd;
                if (trimUser.startsWith("\"") || trimUser.endsWith("\"")) {
                    noQuotesUser = this.removeQuotes(trimUser);
                }
                if (trimPwd != null && trimPwd.startsWith("\"") && trimPwd.endsWith("\"")) {
                    noQuotesPwd = this.removeQuotes(trimPwd);
                }
                if (trimNewPwd != null && trimNewPwd.startsWith("\"") && trimNewPwd.endsWith("\"")) {
                    noQuotesNewPwd = this.removeQuotes(trimNewPwd);
                }
                if (noQuotesPwd != null) {
                    passwordNet = this.meg.conv.StringToCharBytes(noQuotesPwd);
                }
                if (noQuotesNewPwd != null) {
                    newPasswordNet = this.meg.conv.StringToCharBytes(noQuotesNewPwd);
                }
                if (authenticationAdaptor != "RADIUS") {
                    if (passwordNet == null) {
                        password = null;
                    } else if (this.bUseO5Logon) {
                        if (this.o5logonHelper == null) {
                            this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
                        }
                        if (this.verifierType != 2361 && this.verifierType != 40674 && this.verifierType != 59694 && this.verifierType != 45394 && this.verifierType != 6949 && this.verifierType != 18453) {
                            if (bl) {
                                this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "T4CTTIoauthenticate.marshalOauth: verifierType = " + this.verifierType);
                            }
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 451).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, sQLException);
                            }
                            throw sQLException;
                        }
                        this.encryptedKB = new byte[this.encryptedSK.length];
                        for (int k2 = 0; k2 < this.encryptedKB.length; ++k2) {
                            this.encryptedKB[k2] = 1;
                        }
                        int[] encryptedPasswordLength = new int[1];
                        byte[] o5logonpassword = new byte[256];
                        int[] encryptedPkLength = new int[1];
                        byte[] encryptedPkTemp = new byte[256];
                        for (int k3 = 0; k3 < 256; ++k3) {
                            o5logonpassword[k3] = 0;
                        }
                        if (newPasswordNet != null) {
                            int[] encryptedNewPasswordLength = new int[1];
                            byte[] o5logonnewpassword = new byte[256];
                            for (int k4 = 0; k4 < 256; ++k4) {
                                o5logonnewpassword[k4] = 0;
                            }
                            try {
                                this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, noQuotesUser, noQuotesPwd, noQuotesNewPwd, passwordNet, newPasswordNet, this.encryptedSK, this.encryptedKB, o5logonpassword, o5logonnewpassword, encryptedPasswordLength, encryptedNewPasswordLength, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, encryptedPkTemp, encryptedPkLength);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            newPassword = new byte[encryptedNewPasswordLength[0]];
                            System.arraycopy(o5logonnewpassword, 0, newPassword, 0, encryptedNewPasswordLength[0]);
                            password = new byte[encryptedPasswordLength[0]];
                            System.arraycopy(o5logonpassword, 0, password, 0, encryptedPasswordLength[0]);
                        } else {
                            try {
                                this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, noQuotesUser, noQuotesPwd, passwordNet, this.encryptedSK, this.encryptedKB, o5logonpassword, encryptedPasswordLength, this.meg.conv.isServerCSMultiByte, this.connection.getServerCompileTimeCapability(4), this.PBKDF2Salt, this.PBKDF2VgenCount, this.PBKDF2SderCount, encryptedPkTemp, encryptedPkLength);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            password = new byte[encryptedPasswordLength[0]];
                            System.arraycopy(o5logonpassword, 0, password, 0, encryptedPasswordLength[0]);
                        }
                        if (this.verifierType == 18453 && this.connection.hasServerCompileTimeCapability(4, 32)) {
                            encryptedPk = new byte[encryptedPkLength[0]];
                            System.arraycopy(encryptedPkTemp, 0, encryptedPk, 0, encryptedPkLength[0]);
                        }
                    } else {
                        O3LoginClientHelper loginHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte, this.connection.thinUseJCEAPI);
                        byte[] sessionKey = loginHelper.getSessionKey(noQuotesUser, noQuotesPwd, this.encryptedSK);
                        if (bl) {
                            this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "T4CTTIoauthenticate: sessionKey = " + T4CMAREngine.toHex(sessionKey));
                        }
                        pwdPadLen = passwordNet.length % 8 > 0 ? (byte)((byte)(8 - passwordNet.length % 8)) : (byte)0;
                        paddedPwd = new byte[passwordNet.length + pwdPadLen];
                        System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
                        byte[] ePwdOnSessKey = loginHelper.getEPasswd(sessionKey, paddedPwd);
                        password = new byte[2 * paddedPwd.length + 1];
                        if (password.length < 2 * ePwdOnSessKey.length) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, sQLException);
                            }
                            throw sQLException;
                        }
                        RepConversion.bArray2Nibbles(ePwdOnSessKey, password);
                        password[password.length - 1] = RepConversion.nibbleToHex(pwdPadLen);
                    }
                } else if (passwordNet != null) {
                    if (this.connection.net.getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter) {
                        password = passwordNet;
                    } else {
                        pwdPadLen = (passwordNet.length + 1) % 8 > 0 ? (byte)((byte)(8 - (passwordNet.length + 1) % 8)) : (byte)0;
                        paddedPwd = new byte[passwordNet.length + 1 + pwdPadLen];
                        System.arraycopy(passwordNet, 0, paddedPwd, 0, passwordNet.length);
                        byte[] opwd = AuthenticationService.obfuscatePasswordForRadius(paddedPwd);
                        password = new byte[opwd.length * 2];
                        for (int i2 = 0; i2 < opwd.length; ++i2) {
                            byte b1 = (byte)((opwd[i2] & 0xF0) >> 4);
                            byte b2 = (byte)(opwd[i2] & 0xF);
                            password[i2 * 2] = (byte)(b1 < 10 ? b1 + 48 : b1 - 10 + 97);
                            password[i2 * 2 + 1] = (byte)(b2 < 10 ? b2 + 48 : b2 - 10 + 97);
                        }
                    }
                }
            }
            this.doOAUTH(user, password, newPassword, (long)logonMode, authenticationAdaptor, gl_session_id != -1 && gl_serial_nb != -1, null, null, (byte[][])proxyRoles, (int)gl_session_id, (int)gl_serial_nb, encryptedPk);
            if (authenticationAdaptor != "RADIUS" && this.bUseO5Logon) {
                String b64SvrResponse = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
                try {
                    if (this.o5logonHelper == null) {
                        this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
                    }
                    if (!this.o5logonHelper.validateServerIdentity(b64SvrResponse)) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                catch (Exception e2) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOAUTH(int n2, Properties properties, int n3, int n4) throws IOException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void gl_serial_nb;
            void gl_session_id;
            void type;
            void prop;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, n2, properties, n3, n4);
            }
            byte[] dn = null;
            byte[] certificate = null;
            Object roles = null;
            byte[] proxyClientUser = null;
            if (prop.containsKey("PROXY_ROLES")) {
                String[] strRoles = (String[])prop.get("PROXY_ROLES");
                roles = new byte[strRoles.length][];
                for (int i2 = 0; i2 < strRoles.length; ++i2) {
                    roles[i2] = this.meg.conv.StringToCharBytes(strRoles[i2]);
                }
            }
            if (type == true) {
                String _userStr = prop.getProperty("PROXY_USER_NAME");
                String _passwd = prop.getProperty("PROXY_USER_PASSWORD");
                if (_passwd != null && _passwd.length() != 0) {
                    this.doOAUTH(_userStr, _passwd, null, 0L, (int)gl_session_id, (int)gl_serial_nb, (byte[][])roles);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, null);
                    }
                    return;
                }
                proxyClientUser = this.meg.conv.StringToCharBytes(_userStr);
            } else if (type == 2) {
                String _dnStr = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                dn = this.meg.conv.StringToCharBytes(_dnStr);
            } else {
                try {
                    certificate = (byte[])prop.get("PROXY_CERTIFICATE");
                    StringBuffer sb = new StringBuffer();
                    for (int i3 = 0; i3 < certificate.length; ++i3) {
                        String str = Integer.toHexString(0xFF & certificate[i3]);
                        int length = str.length();
                        if (length == 0) {
                            sb.append("00");
                            continue;
                        }
                        if (length == 1) {
                            sb.append('0');
                            sb.append(str);
                            continue;
                        }
                        sb.append(str);
                    }
                    certificate = this.meg.conv.StringToCharBytes(sb.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.doOAUTH(proxyClientUser, null, null, 0L, null, true, dn, certificate, (byte[][])roles, (int)gl_session_id, (int)gl_serial_nb, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSessionFields(T4CConnection t4CConnection) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, t4CConnection);
            }
            String terminalStr = this.connection.thinVsessionTerminal;
            String machineStr = this.connection.thinVsessionMachine;
            String osuserStr = this.connection.thinVsessionOsuser;
            String programStr = this.connection.thinVsessionProgram;
            String processStr = this.connection.thinVsessionProcess;
            String internalNameStr = this.connection.thinVsessionIname;
            String externalNameStr = this.connection.thinVsessionEname;
            String clientNameStr = this.connection.proxyClientName;
            String driverNameStr = this.connection.driverNameAttribute;
            String editionStr = this.connection.editionName;
            byte[] byArray = this.enableTempLobRefCnt = this.connection.enableTempLobRefCnt ? this.meg.conv.StringToCharBytes(Integer.toString(1)) : this.meg.conv.StringToCharBytes(Integer.toString(0));
            if (machineStr == null) {
                try {
                    machineStr = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception e2) {
                    machineStr = "jdbcclient";
                }
            }
            if (externalNameStr == null) {
                externalNameStr = "jdbc_" + this.ressourceManagerId;
            }
            if (driverNameStr == null) {
                driverNameStr = "jdbcthin : " + BuildInfo.getDriverVersion();
            }
            this.terminal = this.meg.conv.StringToCharBytes(terminalStr);
            this.machine = this.meg.conv.StringToCharBytes(machineStr);
            this.sysUserName = this.meg.conv.StringToCharBytes(osuserStr);
            this.programName = this.meg.conv.StringToCharBytes(programStr);
            this.processID = this.meg.conv.StringToCharBytes(processStr);
            this.internalName = this.meg.conv.StringToCharBytes(internalNameStr);
            this.externalName = this.meg.conv.StringToCharBytes(externalNameStr);
            if (clientNameStr != null) {
                this.clientname = this.meg.conv.StringToCharBytes(clientNameStr);
            }
            if (editionStr != null) {
                this.editionName = this.meg.conv.StringToCharBytes(editionStr);
            }
            this.driverName = this.meg.conv.StringToCharBytes(driverNameStr);
            TimeZone tz = TimeZone.getDefault();
            String defaultTimeZone = tz.getID();
            if (!ZONEIDMAP.isValidRegion(defaultTimeZone) || !conn.timezoneAsRegion) {
                int tzOffset = tz.getOffset(System.currentTimeMillis());
                int hr = tzOffset / 3600000;
                int mi = Math.abs(tzOffset / 60000 % 60);
                defaultTimeZone = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
            }
            this.sessionTimeZone = defaultTimeZone;
            conn.sessionTimeZone = defaultTimeZone;
            String nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault(Locale.Category.FORMAT));
            String nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault(Locale.Category.FORMAT));
            if (nlslanguage == null || nlsterritory == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + " NLS_LANGUAGE='" + nlslanguage + "' NLS_TERRITORY='" + nlsterritory + "' ");
            this.aclValue = this.meg.conv.StringToCharBytes("4400");
            this.alterSession[this.alterSession.length - 1] = 0;
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoauthenticate.setSessionFields: terminalStr = " + terminalStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoauthenticate.setSessionFields: machineStr = " + machineStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoauthenticate.setSessionFields: osuserStr = " + osuserStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoauthenticate.setSessionFields: programStr = " + programStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoauthenticate.setSessionFields: processStr = " + processStr);
            }
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoauthenticate.setSessionFields: PrxyClientStr = " + clientNameStr);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String removeQuotes(String string) {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String result;
            int i2;
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, string);
            }
            int first = 0;
            int last = str.length() - 1;
            for (i2 = 0; i2 < str.length(); ++i2) {
                if (str.charAt(i2) == '\"') continue;
                first = i2;
                break;
            }
            for (i2 = str.length() - 1; i2 >= 0; --i2) {
                if (str.charAt(i2) == '\"') continue;
                last = i2;
                break;
            }
            String string2 = result = str.substring(first, last + 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, string2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int versionStringToInt(String string) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            int numericVersion;
            void driverVersion;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, string);
            }
            String[] versionElements = driverVersion.split("\\.");
            int versionNumber = Integer.parseInt(versionElements[0].replaceAll("\\D", ""));
            int releaseNumber = Integer.parseInt(versionElements[1].replaceAll("\\D", ""));
            int updateNumber = Integer.parseInt(versionElements[2].replaceAll("\\D", ""));
            int portingReleaseNumber = Integer.parseInt(versionElements[3].replaceAll("\\D", ""));
            int portingUpdateNumber = Integer.parseInt(versionElements[4].replaceAll("\\D", ""));
            int n2 = numericVersion = versionNumber << 24 | releaseNumber << 20 | updateNumber << 12 | portingReleaseNumber << 8 | portingUpdateNumber;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, n2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String versionIntToString(int n2) throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            String version;
            void versionInt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, n2);
            }
            int versionNumber = (versionInt & 0xFF000000) >> 24 & 0xFF;
            int releaseNumber = (versionInt & 0xF00000) >> 20 & 0xFF;
            int updateNumber = (versionInt & 0xFF000) >> 12 & 0xFF;
            int portingReleaseNumber = (versionInt & 0xF00) >> 8 & 0xFF;
            int portingUpdateNumber = versionInt & 0xFF;
            String string = version = "" + versionNumber + "." + releaseNumber + "." + updateNumber + "." + portingReleaseNumber + "." + portingUpdateNumber;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, string);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    private String getKPPLPurity() throws SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, new Object[0]);
            }
            for (String[] purity : KPPL_PURITY) {
                if (!this.connection.drcpConnectionPurity.equalsIgnoreCase(purity[0])) continue;
                String string = purity[1];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, string);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, null);
                }
                return string;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 297).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, new Object[0]);
            }
            T4CConnection t4CConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, t4CConnection);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, null);
            }
            return t4CConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getDerivedKeyJdbc(byte[] byArray, int n2) throws NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        boolean bl = (8L & TraceControllerImpl.feature) != 0L;
        try {
            void dhKey;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, byArray, n2);
            }
            int mode = this.verifierType == 2361 ? (mode |= 1) : (mode |= 0);
            if (this.o5logonHelper == null) {
                this.o5logonHelper = new O5Logon(this.connection, this.connection.isO7L_MRExposed, this.connection.thinUseJCEAPI);
            }
            byte[] byArray2 = this.o5logonHelper.getDerivedKey((byte[])dhKey, mode);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, null);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIoauthenticate.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$16 = T4CTTIoauthenticate.class.getDeclaredConstructor(T4CConnection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CTTIoauthenticate.class.getDeclaredMethod("getDerivedKeyJdbc", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CTTIoauthenticate.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIoauthenticate.class.getDeclaredMethod("getKPPLPurity", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIoauthenticate.class.getDeclaredMethod("versionIntToString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIoauthenticate.class.getDeclaredMethod("versionStringToInt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIoauthenticate.class.getDeclaredMethod("removeQuotes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIoauthenticate.class.getDeclaredMethod("setSessionFields", T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", Integer.TYPE, Properties.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", String.class, String.class, String.class, Long.TYPE, Integer.TYPE, Integer.TYPE, byte[][].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", String.class, String.class, String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoauthenticate.class.getDeclaredMethod("processRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoauthenticate.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoauthenticate.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoauthenticate.class.getDeclaredMethod("doOSESSKEY", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoauthenticate.class.getDeclaredMethod("doOAUTH", byte[].class, byte[].class, byte[].class, Long.TYPE, String.class, Boolean.TYPE, byte[].class, byte[].class, byte[][].class, Integer.TYPE, Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoauthenticate.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        KPPL_PURITY = new String[][]{{SESS_PURITY_DEFAULT, KPPL_PURITY_DEFAULT}, {SESS_PURITY_NEW, KPPL_PURITY_NEW}, {SESS_PURITY_SELF, KPPL_PURITY_SELF}};
    }
}

