/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.docker.compose.DockerComposeManager;
import com.palantir.docker.compose.EventEmitter;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ProjectName;
import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.DockerMachine;
import com.palantir.docker.compose.connection.waiting.ClusterWait;
import com.palantir.docker.compose.events.EventConsumer;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerComposeExecutable;
import com.palantir.docker.compose.execution.DockerExecutable;
import com.palantir.docker.compose.logging.LogCollector;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.joda.time.ReadableDuration;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DockerComposeManager", generator="Immutables")
@Immutable
public final class ImmutableDockerComposeManager
extends DockerComposeManager {
    private final DockerComposeFiles files;
    private final ImmutableList<ClusterWait> clusterWaits;
    private final ImmutableList<EventConsumer> eventConsumers;
    private final DockerMachine machine;
    private final ProjectName projectName;
    private final DockerComposeExecutable dockerComposeExecutable;
    private final DockerExecutable dockerExecutable;
    private final Docker docker;
    private final ShutdownStrategy shutdownStrategy;
    private final DockerCompose dockerCompose;
    private final Cluster containers;
    private final int retryAttempts;
    private final boolean removeConflictingContainersOnStartup;
    private final boolean pullOnStartup;
    private final ReadableDuration nativeServiceHealthCheckTimeout;
    private final LogCollector logCollector;
    private final transient EventEmitter emitEventsFor;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDockerComposeManager(Builder builder) {
        this.files = builder.files;
        this.clusterWaits = builder.clusterWaits.build();
        this.eventConsumers = builder.eventConsumers.build();
        if (builder.machineIsSet()) {
            this.initShim.machine(builder.machine);
        }
        if (builder.projectNameIsSet()) {
            this.initShim.projectName(builder.projectName);
        }
        if (builder.dockerComposeExecutableIsSet()) {
            this.initShim.dockerComposeExecutable(builder.dockerComposeExecutable);
        }
        if (builder.dockerExecutableIsSet()) {
            this.initShim.dockerExecutable(builder.dockerExecutable);
        }
        if (builder.dockerIsSet()) {
            this.initShim.docker(builder.docker);
        }
        if (builder.shutdownStrategyIsSet()) {
            this.initShim.shutdownStrategy(builder.shutdownStrategy);
        }
        if (builder.dockerComposeIsSet()) {
            this.initShim.dockerCompose(builder.dockerCompose);
        }
        if (builder.containersIsSet()) {
            this.initShim.containers(builder.containers);
        }
        if (builder.retryAttemptsIsSet()) {
            this.initShim.retryAttempts(builder.retryAttempts);
        }
        if (builder.removeConflictingContainersOnStartupIsSet()) {
            this.initShim.removeConflictingContainersOnStartup(builder.removeConflictingContainersOnStartup);
        }
        if (builder.pullOnStartupIsSet()) {
            this.initShim.pullOnStartup(builder.pullOnStartup);
        }
        if (builder.nativeServiceHealthCheckTimeoutIsSet()) {
            this.initShim.nativeServiceHealthCheckTimeout(builder.nativeServiceHealthCheckTimeout);
        }
        if (builder.logCollectorIsSet()) {
            this.initShim.logCollector(builder.logCollector);
        }
        this.machine = this.initShim.machine();
        this.projectName = this.initShim.projectName();
        this.dockerComposeExecutable = this.initShim.dockerComposeExecutable();
        this.dockerExecutable = this.initShim.dockerExecutable();
        this.docker = this.initShim.docker();
        this.shutdownStrategy = this.initShim.shutdownStrategy();
        this.dockerCompose = this.initShim.dockerCompose();
        this.containers = this.initShim.containers();
        this.retryAttempts = this.initShim.retryAttempts();
        this.removeConflictingContainersOnStartup = this.initShim.removeConflictingContainersOnStartup();
        this.pullOnStartup = this.initShim.pullOnStartup();
        this.nativeServiceHealthCheckTimeout = this.initShim.nativeServiceHealthCheckTimeout();
        this.logCollector = this.initShim.logCollector();
        this.emitEventsFor = this.initShim.emitEventsFor();
        this.initShim = null;
    }

    private ImmutableDockerComposeManager(DockerComposeFiles files, ImmutableList<ClusterWait> clusterWaits, ImmutableList<EventConsumer> eventConsumers, DockerMachine machine, ProjectName projectName, DockerComposeExecutable dockerComposeExecutable, DockerExecutable dockerExecutable, Docker docker, ShutdownStrategy shutdownStrategy, DockerCompose dockerCompose, Cluster containers, int retryAttempts, boolean removeConflictingContainersOnStartup, boolean pullOnStartup, ReadableDuration nativeServiceHealthCheckTimeout, LogCollector logCollector) {
        this.files = files;
        this.clusterWaits = clusterWaits;
        this.eventConsumers = eventConsumers;
        this.initShim.machine(machine);
        this.initShim.projectName(projectName);
        this.initShim.dockerComposeExecutable(dockerComposeExecutable);
        this.initShim.dockerExecutable(dockerExecutable);
        this.initShim.docker(docker);
        this.initShim.shutdownStrategy(shutdownStrategy);
        this.initShim.dockerCompose(dockerCompose);
        this.initShim.containers(containers);
        this.initShim.retryAttempts(retryAttempts);
        this.initShim.removeConflictingContainersOnStartup(removeConflictingContainersOnStartup);
        this.initShim.pullOnStartup(pullOnStartup);
        this.initShim.nativeServiceHealthCheckTimeout(nativeServiceHealthCheckTimeout);
        this.initShim.logCollector(logCollector);
        this.machine = this.initShim.machine();
        this.projectName = this.initShim.projectName();
        this.dockerComposeExecutable = this.initShim.dockerComposeExecutable();
        this.dockerExecutable = this.initShim.dockerExecutable();
        this.docker = this.initShim.docker();
        this.shutdownStrategy = this.initShim.shutdownStrategy();
        this.dockerCompose = this.initShim.dockerCompose();
        this.containers = this.initShim.containers();
        this.retryAttempts = this.initShim.retryAttempts();
        this.removeConflictingContainersOnStartup = this.initShim.removeConflictingContainersOnStartup();
        this.pullOnStartup = this.initShim.pullOnStartup();
        this.nativeServiceHealthCheckTimeout = this.initShim.nativeServiceHealthCheckTimeout();
        this.logCollector = this.initShim.logCollector();
        this.emitEventsFor = this.initShim.emitEventsFor();
        this.initShim = null;
    }

    @Override
    public DockerComposeFiles files() {
        return this.files;
    }

    protected ImmutableList<ClusterWait> clusterWaits() {
        return this.clusterWaits;
    }

    protected ImmutableList<EventConsumer> eventConsumers() {
        return this.eventConsumers;
    }

    @Override
    public DockerMachine machine() {
        InitShim shim = this.initShim;
        return shim != null ? shim.machine() : this.machine;
    }

    @Override
    public ProjectName projectName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.projectName() : this.projectName;
    }

    @Override
    public DockerComposeExecutable dockerComposeExecutable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dockerComposeExecutable() : this.dockerComposeExecutable;
    }

    @Override
    public DockerExecutable dockerExecutable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dockerExecutable() : this.dockerExecutable;
    }

    @Override
    public Docker docker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.docker() : this.docker;
    }

    @Override
    public ShutdownStrategy shutdownStrategy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shutdownStrategy() : this.shutdownStrategy;
    }

    @Override
    public DockerCompose dockerCompose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dockerCompose() : this.dockerCompose;
    }

    @Override
    public Cluster containers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.containers() : this.containers;
    }

    @Override
    protected int retryAttempts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.retryAttempts() : this.retryAttempts;
    }

    @Override
    protected boolean removeConflictingContainersOnStartup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.removeConflictingContainersOnStartup() : this.removeConflictingContainersOnStartup;
    }

    @Override
    protected boolean pullOnStartup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pullOnStartup() : this.pullOnStartup;
    }

    @Override
    protected ReadableDuration nativeServiceHealthCheckTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nativeServiceHealthCheckTimeout() : this.nativeServiceHealthCheckTimeout;
    }

    @Override
    protected LogCollector logCollector() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logCollector() : this.logCollector;
    }

    @Override
    protected EventEmitter emitEventsFor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.emitEventsFor() : this.emitEventsFor;
    }

    public final ImmutableDockerComposeManager withFiles(DockerComposeFiles value) {
        if (this.files == value) {
            return this;
        }
        DockerComposeFiles newValue = Objects.requireNonNull(value, "files");
        return new ImmutableDockerComposeManager(newValue, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withClusterWaits(ClusterWait ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDockerComposeManager(this.files, (ImmutableList<ClusterWait>)newValue, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withClusterWaits(Iterable<? extends ClusterWait> elements) {
        if (this.clusterWaits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDockerComposeManager(this.files, (ImmutableList<ClusterWait>)newValue, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withEventConsumers(EventConsumer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, (ImmutableList<EventConsumer>)newValue, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withEventConsumers(Iterable<? extends EventConsumer> elements) {
        if (this.eventConsumers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, (ImmutableList<EventConsumer>)newValue, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withMachine(DockerMachine value) {
        if (this.machine == value) {
            return this;
        }
        DockerMachine newValue = Objects.requireNonNull(value, "machine");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, newValue, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withProjectName(ProjectName value) {
        if (this.projectName == value) {
            return this;
        }
        ProjectName newValue = Objects.requireNonNull(value, "projectName");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, newValue, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withDockerComposeExecutable(DockerComposeExecutable value) {
        if (this.dockerComposeExecutable == value) {
            return this;
        }
        DockerComposeExecutable newValue = Objects.requireNonNull(value, "dockerComposeExecutable");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, newValue, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withDockerExecutable(DockerExecutable value) {
        if (this.dockerExecutable == value) {
            return this;
        }
        DockerExecutable newValue = Objects.requireNonNull(value, "dockerExecutable");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, newValue, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withDocker(Docker value) {
        if (this.docker == value) {
            return this;
        }
        Docker newValue = Objects.requireNonNull(value, "docker");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, newValue, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withShutdownStrategy(ShutdownStrategy value) {
        if (this.shutdownStrategy == value) {
            return this;
        }
        ShutdownStrategy newValue = Objects.requireNonNull(value, "shutdownStrategy");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, newValue, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withDockerCompose(DockerCompose value) {
        if (this.dockerCompose == value) {
            return this;
        }
        DockerCompose newValue = Objects.requireNonNull(value, "dockerCompose");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, newValue, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withContainers(Cluster value) {
        if (this.containers == value) {
            return this;
        }
        Cluster newValue = Objects.requireNonNull(value, "containers");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, newValue, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withRetryAttempts(int value) {
        if (this.retryAttempts == value) {
            return this;
        }
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, value, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withRemoveConflictingContainersOnStartup(boolean value) {
        if (this.removeConflictingContainersOnStartup == value) {
            return this;
        }
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, value, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withPullOnStartup(boolean value) {
        if (this.pullOnStartup == value) {
            return this;
        }
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, value, this.nativeServiceHealthCheckTimeout, this.logCollector);
    }

    public final ImmutableDockerComposeManager withNativeServiceHealthCheckTimeout(ReadableDuration value) {
        if (this.nativeServiceHealthCheckTimeout == value) {
            return this;
        }
        ReadableDuration newValue = Objects.requireNonNull(value, "nativeServiceHealthCheckTimeout");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, newValue, this.logCollector);
    }

    public final ImmutableDockerComposeManager withLogCollector(LogCollector value) {
        if (this.logCollector == value) {
            return this;
        }
        LogCollector newValue = Objects.requireNonNull(value, "logCollector");
        return new ImmutableDockerComposeManager(this.files, this.clusterWaits, this.eventConsumers, this.machine, this.projectName, this.dockerComposeExecutable, this.dockerExecutable, this.docker, this.shutdownStrategy, this.dockerCompose, this.containers, this.retryAttempts, this.removeConflictingContainersOnStartup, this.pullOnStartup, this.nativeServiceHealthCheckTimeout, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDockerComposeManager && this.equalTo((ImmutableDockerComposeManager)another);
    }

    private boolean equalTo(ImmutableDockerComposeManager another) {
        return this.files.equals(another.files) && this.clusterWaits.equals(another.clusterWaits) && this.eventConsumers.equals(another.eventConsumers) && this.machine.equals(another.machine) && this.projectName.equals(another.projectName) && this.dockerComposeExecutable.equals(another.dockerComposeExecutable) && this.dockerExecutable.equals(another.dockerExecutable) && this.docker.equals(another.docker) && this.shutdownStrategy.equals(another.shutdownStrategy) && this.dockerCompose.equals(another.dockerCompose) && this.containers.equals(another.containers) && this.retryAttempts == another.retryAttempts && this.removeConflictingContainersOnStartup == another.removeConflictingContainersOnStartup && this.pullOnStartup == another.pullOnStartup && this.nativeServiceHealthCheckTimeout.equals((Object)another.nativeServiceHealthCheckTimeout) && this.logCollector.equals(another.logCollector) && this.emitEventsFor.equals(another.emitEventsFor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.clusterWaits.hashCode();
        h += (h << 5) + this.eventConsumers.hashCode();
        h += (h << 5) + this.machine.hashCode();
        h += (h << 5) + this.projectName.hashCode();
        h += (h << 5) + this.dockerComposeExecutable.hashCode();
        h += (h << 5) + this.dockerExecutable.hashCode();
        h += (h << 5) + this.docker.hashCode();
        h += (h << 5) + this.shutdownStrategy.hashCode();
        h += (h << 5) + this.dockerCompose.hashCode();
        h += (h << 5) + this.containers.hashCode();
        h += (h << 5) + this.retryAttempts;
        h += (h << 5) + Booleans.hashCode((boolean)this.removeConflictingContainersOnStartup);
        h += (h << 5) + Booleans.hashCode((boolean)this.pullOnStartup);
        h += (h << 5) + this.nativeServiceHealthCheckTimeout.hashCode();
        h += (h << 5) + this.logCollector.hashCode();
        h += (h << 5) + this.emitEventsFor.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DockerComposeManager").omitNullValues().add("files", (Object)this.files).add("clusterWaits", this.clusterWaits).add("eventConsumers", this.eventConsumers).add("machine", (Object)this.machine).add("projectName", (Object)this.projectName).add("dockerComposeExecutable", (Object)this.dockerComposeExecutable).add("dockerExecutable", (Object)this.dockerExecutable).add("docker", (Object)this.docker).add("shutdownStrategy", (Object)this.shutdownStrategy).add("dockerCompose", (Object)this.dockerCompose).add("containers", (Object)this.containers).add("retryAttempts", this.retryAttempts).add("removeConflictingContainersOnStartup", this.removeConflictingContainersOnStartup).add("pullOnStartup", this.pullOnStartup).add("nativeServiceHealthCheckTimeout", (Object)this.nativeServiceHealthCheckTimeout).add("logCollector", (Object)this.logCollector).add("emitEventsFor", (Object)this.emitEventsFor).toString();
    }

    public static DockerComposeManager copyOf(DockerComposeManager instance) {
        if (instance instanceof ImmutableDockerComposeManager) {
            return (ImmutableDockerComposeManager)instance;
        }
        return ((DockerComposeManager.Builder)((Builder)((Object)((Builder)((Object)((DockerComposeManager.Builder)new DockerComposeManager.Builder().files(instance.files())).addAllClusterWaits(instance.clusterWaits()))).addAllEventConsumers(instance.eventConsumers()).machine(instance.machine()).projectName(instance.projectName()).dockerComposeExecutable(instance.dockerComposeExecutable()).dockerExecutable(instance.dockerExecutable()).docker(instance.docker()).shutdownStrategy(instance.shutdownStrategy()))).dockerCompose(instance.dockerCompose()).containers(instance.containers()).retryAttempts(instance.retryAttempts()).removeConflictingContainersOnStartup(instance.removeConflictingContainersOnStartup()).pullOnStartup(instance.pullOnStartup()).nativeServiceHealthCheckTimeout(instance.nativeServiceHealthCheckTimeout()).logCollector(instance.logCollector())).build();
    }

    @Generated(from="DockerComposeManager", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_FILES = 1L;
        private static final long OPT_BIT_MACHINE = 1L;
        private static final long OPT_BIT_PROJECT_NAME = 2L;
        private static final long OPT_BIT_DOCKER_COMPOSE_EXECUTABLE = 4L;
        private static final long OPT_BIT_DOCKER_EXECUTABLE = 8L;
        private static final long OPT_BIT_DOCKER = 16L;
        private static final long OPT_BIT_SHUTDOWN_STRATEGY = 32L;
        private static final long OPT_BIT_DOCKER_COMPOSE = 64L;
        private static final long OPT_BIT_CONTAINERS = 128L;
        private static final long OPT_BIT_RETRY_ATTEMPTS = 256L;
        private static final long OPT_BIT_REMOVE_CONFLICTING_CONTAINERS_ON_STARTUP = 512L;
        private static final long OPT_BIT_PULL_ON_STARTUP = 1024L;
        private static final long OPT_BIT_NATIVE_SERVICE_HEALTH_CHECK_TIMEOUT = 2048L;
        private static final long OPT_BIT_LOG_COLLECTOR = 4096L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private DockerComposeFiles files;
        private final ImmutableList.Builder<ClusterWait> clusterWaits = ImmutableList.builder();
        private final ImmutableList.Builder<EventConsumer> eventConsumers = ImmutableList.builder();
        @Nullable
        private DockerMachine machine;
        @Nullable
        private ProjectName projectName;
        @Nullable
        private DockerComposeExecutable dockerComposeExecutable;
        @Nullable
        private DockerExecutable dockerExecutable;
        @Nullable
        private Docker docker;
        @Nullable
        private ShutdownStrategy shutdownStrategy;
        @Nullable
        private DockerCompose dockerCompose;
        @Nullable
        private Cluster containers;
        private int retryAttempts;
        private boolean removeConflictingContainersOnStartup;
        private boolean pullOnStartup;
        @Nullable
        private ReadableDuration nativeServiceHealthCheckTimeout;
        @Nullable
        private LogCollector logCollector;

        public Builder() {
            if (!(this instanceof DockerComposeManager.Builder)) {
                throw new UnsupportedOperationException("Use: new DockerComposeManager.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder files(DockerComposeFiles files) {
            Builder.checkNotIsSet(this.filesIsSet(), "files");
            this.files = Objects.requireNonNull(files, "files");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder addClusterWait(ClusterWait element) {
            this.clusterWaits.add((Object)element);
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder addClusterWaits(ClusterWait ... elements) {
            this.clusterWaits.add((Object[])elements);
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder addAllClusterWaits(Iterable<? extends ClusterWait> elements) {
            this.clusterWaits.addAll(elements);
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder addEventConsumer(EventConsumer element) {
            this.eventConsumers.add((Object)element);
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder addEventConsumers(EventConsumer ... elements) {
            this.eventConsumers.add((Object[])elements);
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder addAllEventConsumers(Iterable<? extends EventConsumer> elements) {
            this.eventConsumers.addAll(elements);
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder machine(DockerMachine machine) {
            Builder.checkNotIsSet(this.machineIsSet(), "machine");
            this.machine = Objects.requireNonNull(machine, "machine");
            this.optBits |= 1L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder projectName(ProjectName projectName) {
            Builder.checkNotIsSet(this.projectNameIsSet(), "projectName");
            this.projectName = Objects.requireNonNull(projectName, "projectName");
            this.optBits |= 2L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder dockerComposeExecutable(DockerComposeExecutable dockerComposeExecutable) {
            Builder.checkNotIsSet(this.dockerComposeExecutableIsSet(), "dockerComposeExecutable");
            this.dockerComposeExecutable = Objects.requireNonNull(dockerComposeExecutable, "dockerComposeExecutable");
            this.optBits |= 4L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder dockerExecutable(DockerExecutable dockerExecutable) {
            Builder.checkNotIsSet(this.dockerExecutableIsSet(), "dockerExecutable");
            this.dockerExecutable = Objects.requireNonNull(dockerExecutable, "dockerExecutable");
            this.optBits |= 8L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder docker(Docker docker) {
            Builder.checkNotIsSet(this.dockerIsSet(), "docker");
            this.docker = Objects.requireNonNull(docker, "docker");
            this.optBits |= 0x10L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder shutdownStrategy(ShutdownStrategy shutdownStrategy) {
            Builder.checkNotIsSet(this.shutdownStrategyIsSet(), "shutdownStrategy");
            this.shutdownStrategy = Objects.requireNonNull(shutdownStrategy, "shutdownStrategy");
            this.optBits |= 0x20L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder dockerCompose(DockerCompose dockerCompose) {
            Builder.checkNotIsSet(this.dockerComposeIsSet(), "dockerCompose");
            this.dockerCompose = Objects.requireNonNull(dockerCompose, "dockerCompose");
            this.optBits |= 0x40L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder containers(Cluster containers) {
            Builder.checkNotIsSet(this.containersIsSet(), "containers");
            this.containers = Objects.requireNonNull(containers, "containers");
            this.optBits |= 0x80L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder retryAttempts(int retryAttempts) {
            Builder.checkNotIsSet(this.retryAttemptsIsSet(), "retryAttempts");
            this.retryAttempts = retryAttempts;
            this.optBits |= 0x100L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder removeConflictingContainersOnStartup(boolean removeConflictingContainersOnStartup) {
            Builder.checkNotIsSet(this.removeConflictingContainersOnStartupIsSet(), "removeConflictingContainersOnStartup");
            this.removeConflictingContainersOnStartup = removeConflictingContainersOnStartup;
            this.optBits |= 0x200L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder pullOnStartup(boolean pullOnStartup) {
            Builder.checkNotIsSet(this.pullOnStartupIsSet(), "pullOnStartup");
            this.pullOnStartup = pullOnStartup;
            this.optBits |= 0x400L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder nativeServiceHealthCheckTimeout(ReadableDuration nativeServiceHealthCheckTimeout) {
            Builder.checkNotIsSet(this.nativeServiceHealthCheckTimeoutIsSet(), "nativeServiceHealthCheckTimeout");
            this.nativeServiceHealthCheckTimeout = Objects.requireNonNull(nativeServiceHealthCheckTimeout, "nativeServiceHealthCheckTimeout");
            this.optBits |= 0x800L;
            return (DockerComposeManager.Builder)this;
        }

        @CanIgnoreReturnValue
        public final DockerComposeManager.Builder logCollector(LogCollector logCollector) {
            Builder.checkNotIsSet(this.logCollectorIsSet(), "logCollector");
            this.logCollector = Objects.requireNonNull(logCollector, "logCollector");
            this.optBits |= 0x1000L;
            return (DockerComposeManager.Builder)this;
        }

        public DockerComposeManager build() {
            this.checkRequiredAttributes();
            return new ImmutableDockerComposeManager(this);
        }

        private boolean machineIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean projectNameIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean dockerComposeExecutableIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean dockerExecutableIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean dockerIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean shutdownStrategyIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean dockerComposeIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean containersIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean retryAttemptsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean removeConflictingContainersOnStartupIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean pullOnStartupIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean nativeServiceHealthCheckTimeoutIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean logCollectorIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean filesIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of DockerComposeManager is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.filesIsSet()) {
                attributes.add("files");
            }
            return "Cannot build DockerComposeManager, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="DockerComposeManager", generator="Immutables")
    private final class InitShim {
        private byte machineBuildStage = 0;
        private DockerMachine machine;
        private byte projectNameBuildStage = 0;
        private ProjectName projectName;
        private byte dockerComposeExecutableBuildStage = 0;
        private DockerComposeExecutable dockerComposeExecutable;
        private byte dockerExecutableBuildStage = 0;
        private DockerExecutable dockerExecutable;
        private byte dockerBuildStage = 0;
        private Docker docker;
        private byte shutdownStrategyBuildStage = 0;
        private ShutdownStrategy shutdownStrategy;
        private byte dockerComposeBuildStage = 0;
        private DockerCompose dockerCompose;
        private byte containersBuildStage = 0;
        private Cluster containers;
        private byte retryAttemptsBuildStage = 0;
        private int retryAttempts;
        private byte removeConflictingContainersOnStartupBuildStage = 0;
        private boolean removeConflictingContainersOnStartup;
        private byte pullOnStartupBuildStage = 0;
        private boolean pullOnStartup;
        private byte nativeServiceHealthCheckTimeoutBuildStage = 0;
        private ReadableDuration nativeServiceHealthCheckTimeout;
        private byte logCollectorBuildStage = 0;
        private LogCollector logCollector;
        private byte emitEventsForBuildStage = 0;
        private EventEmitter emitEventsFor;

        private InitShim() {
        }

        DockerMachine machine() {
            if (this.machineBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.machineBuildStage == 0) {
                this.machineBuildStage = (byte)-1;
                this.machine = Objects.requireNonNull(ImmutableDockerComposeManager.super.machine(), "machine");
                this.machineBuildStage = 1;
            }
            return this.machine;
        }

        void machine(DockerMachine machine) {
            this.machine = machine;
            this.machineBuildStage = 1;
        }

        ProjectName projectName() {
            if (this.projectNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.projectNameBuildStage == 0) {
                this.projectNameBuildStage = (byte)-1;
                this.projectName = Objects.requireNonNull(ImmutableDockerComposeManager.super.projectName(), "projectName");
                this.projectNameBuildStage = 1;
            }
            return this.projectName;
        }

        void projectName(ProjectName projectName) {
            this.projectName = projectName;
            this.projectNameBuildStage = 1;
        }

        DockerComposeExecutable dockerComposeExecutable() {
            if (this.dockerComposeExecutableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerComposeExecutableBuildStage == 0) {
                this.dockerComposeExecutableBuildStage = (byte)-1;
                this.dockerComposeExecutable = Objects.requireNonNull(ImmutableDockerComposeManager.super.dockerComposeExecutable(), "dockerComposeExecutable");
                this.dockerComposeExecutableBuildStage = 1;
            }
            return this.dockerComposeExecutable;
        }

        void dockerComposeExecutable(DockerComposeExecutable dockerComposeExecutable) {
            this.dockerComposeExecutable = dockerComposeExecutable;
            this.dockerComposeExecutableBuildStage = 1;
        }

        DockerExecutable dockerExecutable() {
            if (this.dockerExecutableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerExecutableBuildStage == 0) {
                this.dockerExecutableBuildStage = (byte)-1;
                this.dockerExecutable = Objects.requireNonNull(ImmutableDockerComposeManager.super.dockerExecutable(), "dockerExecutable");
                this.dockerExecutableBuildStage = 1;
            }
            return this.dockerExecutable;
        }

        void dockerExecutable(DockerExecutable dockerExecutable) {
            this.dockerExecutable = dockerExecutable;
            this.dockerExecutableBuildStage = 1;
        }

        Docker docker() {
            if (this.dockerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerBuildStage == 0) {
                this.dockerBuildStage = (byte)-1;
                this.docker = Objects.requireNonNull(ImmutableDockerComposeManager.super.docker(), "docker");
                this.dockerBuildStage = 1;
            }
            return this.docker;
        }

        void docker(Docker docker) {
            this.docker = docker;
            this.dockerBuildStage = 1;
        }

        ShutdownStrategy shutdownStrategy() {
            if (this.shutdownStrategyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shutdownStrategyBuildStage == 0) {
                this.shutdownStrategyBuildStage = (byte)-1;
                this.shutdownStrategy = Objects.requireNonNull(ImmutableDockerComposeManager.super.shutdownStrategy(), "shutdownStrategy");
                this.shutdownStrategyBuildStage = 1;
            }
            return this.shutdownStrategy;
        }

        void shutdownStrategy(ShutdownStrategy shutdownStrategy) {
            this.shutdownStrategy = shutdownStrategy;
            this.shutdownStrategyBuildStage = 1;
        }

        DockerCompose dockerCompose() {
            if (this.dockerComposeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerComposeBuildStage == 0) {
                this.dockerComposeBuildStage = (byte)-1;
                this.dockerCompose = Objects.requireNonNull(ImmutableDockerComposeManager.super.dockerCompose(), "dockerCompose");
                this.dockerComposeBuildStage = 1;
            }
            return this.dockerCompose;
        }

        void dockerCompose(DockerCompose dockerCompose) {
            this.dockerCompose = dockerCompose;
            this.dockerComposeBuildStage = 1;
        }

        Cluster containers() {
            if (this.containersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.containersBuildStage == 0) {
                this.containersBuildStage = (byte)-1;
                this.containers = Objects.requireNonNull(ImmutableDockerComposeManager.super.containers(), "containers");
                this.containersBuildStage = 1;
            }
            return this.containers;
        }

        void containers(Cluster containers) {
            this.containers = containers;
            this.containersBuildStage = 1;
        }

        int retryAttempts() {
            if (this.retryAttemptsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryAttemptsBuildStage == 0) {
                this.retryAttemptsBuildStage = (byte)-1;
                this.retryAttempts = ImmutableDockerComposeManager.super.retryAttempts();
                this.retryAttemptsBuildStage = 1;
            }
            return this.retryAttempts;
        }

        void retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            this.retryAttemptsBuildStage = 1;
        }

        boolean removeConflictingContainersOnStartup() {
            if (this.removeConflictingContainersOnStartupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.removeConflictingContainersOnStartupBuildStage == 0) {
                this.removeConflictingContainersOnStartupBuildStage = (byte)-1;
                this.removeConflictingContainersOnStartup = ImmutableDockerComposeManager.super.removeConflictingContainersOnStartup();
                this.removeConflictingContainersOnStartupBuildStage = 1;
            }
            return this.removeConflictingContainersOnStartup;
        }

        void removeConflictingContainersOnStartup(boolean removeConflictingContainersOnStartup) {
            this.removeConflictingContainersOnStartup = removeConflictingContainersOnStartup;
            this.removeConflictingContainersOnStartupBuildStage = 1;
        }

        boolean pullOnStartup() {
            if (this.pullOnStartupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pullOnStartupBuildStage == 0) {
                this.pullOnStartupBuildStage = (byte)-1;
                this.pullOnStartup = ImmutableDockerComposeManager.super.pullOnStartup();
                this.pullOnStartupBuildStage = 1;
            }
            return this.pullOnStartup;
        }

        void pullOnStartup(boolean pullOnStartup) {
            this.pullOnStartup = pullOnStartup;
            this.pullOnStartupBuildStage = 1;
        }

        ReadableDuration nativeServiceHealthCheckTimeout() {
            if (this.nativeServiceHealthCheckTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nativeServiceHealthCheckTimeoutBuildStage == 0) {
                this.nativeServiceHealthCheckTimeoutBuildStage = (byte)-1;
                this.nativeServiceHealthCheckTimeout = Objects.requireNonNull(ImmutableDockerComposeManager.super.nativeServiceHealthCheckTimeout(), "nativeServiceHealthCheckTimeout");
                this.nativeServiceHealthCheckTimeoutBuildStage = 1;
            }
            return this.nativeServiceHealthCheckTimeout;
        }

        void nativeServiceHealthCheckTimeout(ReadableDuration nativeServiceHealthCheckTimeout) {
            this.nativeServiceHealthCheckTimeout = nativeServiceHealthCheckTimeout;
            this.nativeServiceHealthCheckTimeoutBuildStage = 1;
        }

        LogCollector logCollector() {
            if (this.logCollectorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logCollectorBuildStage == 0) {
                this.logCollectorBuildStage = (byte)-1;
                this.logCollector = Objects.requireNonNull(ImmutableDockerComposeManager.super.logCollector(), "logCollector");
                this.logCollectorBuildStage = 1;
            }
            return this.logCollector;
        }

        void logCollector(LogCollector logCollector) {
            this.logCollector = logCollector;
            this.logCollectorBuildStage = 1;
        }

        EventEmitter emitEventsFor() {
            if (this.emitEventsForBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.emitEventsForBuildStage == 0) {
                this.emitEventsForBuildStage = (byte)-1;
                this.emitEventsFor = Objects.requireNonNull(ImmutableDockerComposeManager.super.emitEventsFor(), "emitEventsFor");
                this.emitEventsForBuildStage = 1;
            }
            return this.emitEventsFor;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.machineBuildStage == -1) {
                attributes.add("machine");
            }
            if (this.projectNameBuildStage == -1) {
                attributes.add("projectName");
            }
            if (this.dockerComposeExecutableBuildStage == -1) {
                attributes.add("dockerComposeExecutable");
            }
            if (this.dockerExecutableBuildStage == -1) {
                attributes.add("dockerExecutable");
            }
            if (this.dockerBuildStage == -1) {
                attributes.add("docker");
            }
            if (this.shutdownStrategyBuildStage == -1) {
                attributes.add("shutdownStrategy");
            }
            if (this.dockerComposeBuildStage == -1) {
                attributes.add("dockerCompose");
            }
            if (this.containersBuildStage == -1) {
                attributes.add("containers");
            }
            if (this.retryAttemptsBuildStage == -1) {
                attributes.add("retryAttempts");
            }
            if (this.removeConflictingContainersOnStartupBuildStage == -1) {
                attributes.add("removeConflictingContainersOnStartup");
            }
            if (this.pullOnStartupBuildStage == -1) {
                attributes.add("pullOnStartup");
            }
            if (this.nativeServiceHealthCheckTimeoutBuildStage == -1) {
                attributes.add("nativeServiceHealthCheckTimeout");
            }
            if (this.logCollectorBuildStage == -1) {
                attributes.add("logCollector");
            }
            if (this.emitEventsForBuildStage == -1) {
                attributes.add("emitEventsFor");
            }
            return "Cannot build DockerComposeManager, attribute initializers form cycle " + attributes;
        }
    }
}

