/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose;

import com.palantir.docker.compose.connection.Cluster;
import com.palantir.docker.compose.connection.Container;
import com.palantir.docker.compose.connection.ContainerCache;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class RecordingCluster
extends Cluster {
    private final Cluster delegate;
    private final Set<String> recordedContainerNames = ConcurrentHashMap.newKeySet();

    RecordingCluster(Cluster delegate) {
        this.delegate = delegate;
    }

    @Override
    public String ip() {
        return this.delegate.ip();
    }

    @Override
    public ContainerCache containerCache() {
        return this.delegate.containerCache();
    }

    @Override
    public Container container(String name) {
        this.recordedContainerNames.add(name);
        return this.delegate.container(name);
    }

    @Override
    public List<Container> containers(List<String> containerNames) {
        this.recordedContainerNames.addAll(containerNames);
        return this.delegate.containers(containerNames);
    }

    @Override
    public Set<Container> allContainers() throws IOException, InterruptedException {
        Set<Container> containers = this.delegate.allContainers();
        containers.forEach(container -> this.recordedContainerNames.add(container.getContainerName()));
        return containers;
    }

    public Set<String> recordedContainerNames() {
        return this.recordedContainerNames;
    }
}

