/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.annotations.VisibleForTesting;
import com.palantir.docker.compose.CustomImmutablesStyle;
import com.palantir.docker.compose.configuration.ImmutableDockerComposeRuleConfig;
import com.palantir.docker.compose.reporting.ReportingConfig;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableDockerComposeRuleConfig.class)
@Value.Immutable
@CustomImmutablesStyle
public abstract class DockerComposeRuleConfig {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)new Jdk8Module()).registerModule((Module)new GuavaModule());
    public static final String CONFIG_FILENAME = ".docker-compose-rule.yml";

    public abstract Optional<ReportingConfig> reporting();

    public static Builder builder() {
        return new Builder();
    }

    public static Optional<DockerComposeRuleConfig> findAutomatically() {
        return DockerComposeRuleConfig.findAutomaticallyFrom(new File("."));
    }

    @VisibleForTesting
    static Optional<DockerComposeRuleConfig> findAutomaticallyFrom(File startDir) {
        Optional configFile = DockerComposeRuleConfig.dirAndParents(startDir).map(dir -> new File((File)dir, CONFIG_FILENAME)).findFirst(File::exists);
        return configFile.map(config -> {
            try {
                return (DockerComposeRuleConfig)OBJECT_MAPPER.readValue(config, DockerComposeRuleConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't deserialize config file", e);
            }
        });
    }

    private static StreamEx<File> dirAndParents(final File startDir) {
        return ((StreamEx)StreamEx.of(Stream.generate(new Supplier<Optional<File>>(){
            private Optional<File> dir;
            {
                this.dir = Optional.of(startDir.getAbsoluteFile());
            }

            @Override
            public Optional<File> get() {
                Optional<File> toReturn = this.dir;
                this.dir = this.dir.map(File::getParentFile);
                return toReturn;
            }
        })).takeWhile(Optional::isPresent)).map(Optional::get);
    }

    public static class Builder
    extends ImmutableDockerComposeRuleConfig.Builder {
    }
}

