/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.configuration;

import com.palantir.docker.compose.configuration.DaemonEnvironmentValidator;
import com.palantir.docker.compose.configuration.DaemonHostIpResolver;
import com.palantir.docker.compose.configuration.EnvironmentValidator;
import com.palantir.docker.compose.configuration.HostIpResolver;
import com.palantir.docker.compose.configuration.RemoteEnvironmentValidator;
import com.palantir.docker.compose.configuration.RemoteHostIpResolver;
import java.util.Map;
import java.util.Optional;

public enum DockerType implements HostIpResolver,
EnvironmentValidator
{
    DAEMON(DaemonEnvironmentValidator.instance(), new DaemonHostIpResolver()),
    REMOTE(RemoteEnvironmentValidator.instance(), new RemoteHostIpResolver());

    private final EnvironmentValidator validator;
    private final HostIpResolver resolver;

    private DockerType(EnvironmentValidator validator, HostIpResolver resolver) {
        this.validator = validator;
        this.resolver = resolver;
    }

    @Override
    public void validateEnvironmentVariables(Map<String, String> dockerEnvironment) {
        this.validator.validateEnvironmentVariables(dockerEnvironment);
    }

    @Override
    public String resolveIp(String dockerHost) {
        return this.resolver.resolveIp(dockerHost);
    }

    public static Optional<DockerType> getFirstValidDockerTypeForEnvironment(Map<String, String> environment) {
        for (DockerType currType : DockerType.values()) {
            try {
                currType.validateEnvironmentVariables(environment);
                return Optional.of(currType);
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return Optional.empty();
    }
}

