/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.palantir.docker.compose.connection.PortMapping;
import com.palantir.docker.compose.connection.waiting.SuccessOrFailure;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerPort {
    private static final Logger log = LoggerFactory.getLogger(DockerPort.class);
    private final String ip;
    private final PortMapping portMapping;

    public DockerPort(String ip, int externalPort, int internalPort) {
        this(ip, new PortMapping(externalPort, internalPort));
    }

    public DockerPort(String ip, PortMapping portMapping) {
        this.ip = ip;
        this.portMapping = portMapping;
    }

    public String getIp() {
        return this.ip;
    }

    public int getExternalPort() {
        return this.portMapping.getExternalPort();
    }

    public int getInternalPort() {
        return this.portMapping.getInternalPort();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isListeningNow() {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(this.ip, this.getExternalPort()), 500);
            log.trace("External Port '{}' on ip '{}' was open", (Object)this.getExternalPort(), (Object)this.ip);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isHttpResponding(Function<DockerPort, String> urlFunction, boolean andCheckStatus) {
        return this.isHttpRespondingSuccessfully(urlFunction, andCheckStatus).succeeded();
    }

    public SuccessOrFailure isHttpRespondingSuccessfully(Function<DockerPort, String> urlFunction, boolean andCheckStatus) {
        URL url;
        try {
            String urlString = urlFunction.apply(this);
            log.trace("Trying to connect to {}", (Object)urlString);
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create URL for connecting to localhost", e);
        }
        try {
            url.openConnection().connect();
            url.openStream().read();
            log.debug("Http connection acquired, assuming port active");
            return SuccessOrFailure.success();
        }
        catch (SocketException e) {
            return SuccessOrFailure.failureWithCondensedException("Failed to acquire http connection, assuming port inactive", e);
        }
        catch (FileNotFoundException e) {
            return SuccessOrFailure.fromBoolean(!andCheckStatus, "Received 404, assuming port inactive: " + e.getMessage());
        }
        catch (SSLHandshakeException e) {
            return SuccessOrFailure.failureWithCondensedException("Received bad SSL response, assuming port inactive", e);
        }
        catch (IOException e) {
            return SuccessOrFailure.failureWithCondensedException("Error acquiring http connection, assuming port open but inactive", e);
        }
    }

    public String inFormat(String format) {
        return format.replaceAll("\\$HOST", this.getIp()).replaceAll("\\$EXTERNAL_PORT", String.valueOf(this.getExternalPort())).replaceAll("\\$INTERNAL_PORT", String.valueOf(this.getInternalPort()));
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.portMapping);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerPort other = (DockerPort)obj;
        return Objects.equals(this.ip, other.ip) && Objects.equals(this.portMapping, other.portMapping);
    }

    public String toString() {
        return "DockerPort [ip=" + this.ip + ", portMapping=" + this.portMapping + "]";
    }
}

