/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.connection;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.palantir.docker.compose.connection.DockerPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class Ports {
    private static final Pattern PORT_PATTERN = Pattern.compile("((\\d+).(\\d+).(\\d+).(\\d+)):(\\d+)->(\\d+)/tcp");
    private static final int IP_ADDRESS = 1;
    private static final int EXTERNAL_PORT = 6;
    private static final int INTERNAL_PORT = 7;
    private static final String NO_IP_ADDRESS = "0.0.0.0";
    private final List<DockerPort> ports;

    public Ports(List<DockerPort> ports) {
        this.ports = ports;
    }

    public Ports(DockerPort port) {
        this(Collections.singletonList(port));
    }

    public Stream<DockerPort> stream() {
        return this.ports.stream();
    }

    public static Ports parseFromDockerComposePs(String psOutput, String dockerMachineIp) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)psOutput) ? 1 : 0) != 0, (Object)"No container found");
        Matcher matcher = PORT_PATTERN.matcher(psOutput);
        ArrayList<DockerPort> ports = new ArrayList<DockerPort>();
        while (matcher.find()) {
            String matchedIpAddress = matcher.group(1);
            String ip = matchedIpAddress.equals(NO_IP_ADDRESS) ? dockerMachineIp : matchedIpAddress;
            int externalPort = Integer.parseInt(matcher.group(6));
            int internalPort = Integer.parseInt(matcher.group(7));
            ports.add(new DockerPort(ip, externalPort, internalPort));
        }
        return new Ports(ports);
    }

    public int hashCode() {
        return Objects.hashCode(this.ports);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ports other = (Ports)obj;
        return Objects.equals(this.ports, other.ports);
    }

    public String toString() {
        return "Ports [ports=" + this.ports + "]";
    }
}

