/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.ContainerName;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerExecutionException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class AggressiveShutdownStrategy
implements ShutdownStrategy {
    private static final Logger log = LoggerFactory.getLogger(AggressiveShutdownStrategy.class);

    @Override
    public void shutdown(DockerCompose dockerCompose, Docker docker) throws IOException, InterruptedException {
        List<ContainerName> runningContainers = dockerCompose.ps();
        log.info("Shutting down {}", runningContainers.stream().map(ContainerName::semanticName).collect(Collectors.toList()));
        if (AggressiveShutdownStrategy.removeContainersCatchingErrors(docker, runningContainers)) {
            return;
        }
        log.debug("First shutdown attempted failed due to btrfs volume error... retrying");
        if (AggressiveShutdownStrategy.removeContainersCatchingErrors(docker, runningContainers)) {
            return;
        }
        log.warn("Couldn't shut down containers due to btrfs volume error, see https://circleci.com/docs/docker-btrfs-error/ for more info.");
        log.info("Pruning networks");
        docker.pruneNetworks();
    }

    private static boolean removeContainersCatchingErrors(Docker docker, List<ContainerName> runningContainers) throws IOException, InterruptedException {
        try {
            AggressiveShutdownStrategy.removeContainers(docker, runningContainers);
            return true;
        }
        catch (DockerExecutionException exception) {
            return false;
        }
    }

    private static void removeContainers(Docker docker, List<ContainerName> running) throws IOException, InterruptedException {
        List<String> rawContainerNames = running.stream().map(ContainerName::rawName).collect(Collectors.toList());
        docker.rm(rawContainerNames);
        log.debug("Finished shutdown");
    }
}

