/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.palantir.docker.compose.configuration.ShutdownStrategy;
import com.palantir.docker.compose.connection.ContainerName;
import com.palantir.docker.compose.execution.Docker;
import com.palantir.docker.compose.execution.DockerCompose;
import com.palantir.docker.compose.execution.DockerExecutionException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class AggressiveShutdownWithNetworkCleanupStrategy
implements ShutdownStrategy {
    private static final Logger log = LoggerFactory.getLogger(AggressiveShutdownWithNetworkCleanupStrategy.class);

    @Override
    public void shutdown(DockerCompose dockerCompose, Docker docker) throws IOException, InterruptedException {
        List<ContainerName> runningContainers = dockerCompose.ps();
        log.info("Shutting down {}", runningContainers.stream().map(ContainerName::semanticName).collect(Collectors.toList()));
        AggressiveShutdownWithNetworkCleanupStrategy.removeContainersCatchingErrors(docker, runningContainers);
        AggressiveShutdownWithNetworkCleanupStrategy.removeNetworks(dockerCompose, docker);
    }

    private static void removeContainersCatchingErrors(Docker docker, List<ContainerName> runningContainers) throws IOException, InterruptedException {
        try {
            AggressiveShutdownWithNetworkCleanupStrategy.removeContainers(docker, runningContainers);
        }
        catch (DockerExecutionException exception) {
            log.error("Error while trying to remove containers: {}", (Object)exception.getMessage());
        }
    }

    private static void removeContainers(Docker docker, List<ContainerName> running) throws IOException, InterruptedException {
        List<String> rawContainerNames = running.stream().map(ContainerName::rawName).collect(Collectors.toList());
        docker.rm(rawContainerNames);
        log.debug("Finished shutdown");
    }

    private static void removeNetworks(DockerCompose dockerCompose, Docker docker) throws IOException, InterruptedException {
        dockerCompose.down();
        docker.pruneNetworks();
    }
}

