/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.google.common.base.Throwables;
import com.palantir.docker.compose.execution.DockerExecutionException;
import com.palantir.docker.compose.execution.ErrorHandler;
import com.palantir.docker.compose.execution.Executable;
import com.palantir.docker.compose.execution.ProcessResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Command {
    public static final int HOURS_TO_WAIT_FOR_STD_OUT_TO_CLOSE = 12;
    public static final int MINUTES_TO_WAIT_AFTER_STD_OUT_CLOSES = 1;
    private final Executable executable;
    private final Consumer<String> logConsumer;

    public Command(Executable executable, Consumer<String> logConsumer) {
        this.executable = executable;
        this.logConsumer = logConsumer;
    }

    public String execute(ErrorHandler errorHandler, String ... commands) throws IOException, InterruptedException {
        ProcessResult result = this.run(commands);
        if (result.exitCode() != 0) {
            errorHandler.handle(result.exitCode(), result.output(), this.executable.commandName(), commands);
        }
        return result.output();
    }

    public static ErrorHandler throwingOnError() {
        return (exitCode, output, commandName, commands) -> {
            String message = Command.constructNonZeroExitErrorMessage(exitCode, commandName, commands) + "\nThe output was:\n" + output;
            throw new DockerExecutionException(message);
        };
    }

    private static String constructNonZeroExitErrorMessage(int exitCode, String commandName, String ... commands) {
        return "'" + commandName + " " + Arrays.stream(commands).collect(Collectors.joining(" ")) + "' returned exit code " + exitCode;
    }

    private ProcessResult run(String ... commands) throws IOException, InterruptedException {
        Process process = this.executable.execute(commands);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<String> outputProcessing = exec.submit(() -> this.processOutputFrom(process));
        String output = Command.waitForResultFrom(outputProcessing);
        process.waitFor(1L, TimeUnit.MINUTES);
        exec.shutdown();
        return new ProcessResult(process.exitValue(), output);
    }

    private String processOutputFrom(Process process) {
        return Command.asReader(process.getInputStream()).lines().peek(this.logConsumer).collect(Collectors.joining(System.lineSeparator()));
    }

    private static String waitForResultFrom(Future<String> outputProcessing) {
        try {
            return outputProcessing.get(12L, TimeUnit.HOURS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static BufferedReader asReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }
}

