/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public final class DockerCommandLocations {
    private static final Predicate<String> IS_NOT_NULL = path -> path != null;
    private static final Predicate<String> FILE_EXISTS = path -> new File((String)path).exists();
    private final List<String> possiblePaths;

    public DockerCommandLocations(String ... possiblePaths) {
        this.possiblePaths = Arrays.asList(possiblePaths);
    }

    public Optional<String> preferredLocation() {
        return this.possiblePaths.stream().filter(IS_NOT_NULL).filter(FILE_EXISTS).findFirst();
    }

    public String toString() {
        return "DockerCommandLocations{possiblePaths=" + this.possiblePaths + "}";
    }
}

