/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.docker.compose.configuration.DockerComposeFiles;
import com.palantir.docker.compose.configuration.ProjectName;
import com.palantir.docker.compose.execution.DockerComposeExecutable;
import com.palantir.docker.compose.execution.DockerConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DockerComposeExecutable", generator="Immutables")
@Immutable
public final class ImmutableDockerComposeExecutable
extends DockerComposeExecutable {
    private final DockerComposeFiles dockerComposeFiles;
    private final DockerConfiguration dockerConfiguration;
    private final ProjectName projectName;
    private final transient String dockerComposePath;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDockerComposeExecutable(DockerComposeFiles dockerComposeFiles, DockerConfiguration dockerConfiguration) {
        this.dockerComposeFiles = Objects.requireNonNull(dockerComposeFiles, "dockerComposeFiles");
        this.dockerConfiguration = Objects.requireNonNull(dockerConfiguration, "dockerConfiguration");
        this.projectName = this.initShim.projectName();
        this.dockerComposePath = this.initShim.dockerComposePath();
        this.initShim = null;
    }

    private ImmutableDockerComposeExecutable(Builder builder) {
        this.dockerComposeFiles = builder.dockerComposeFiles;
        this.dockerConfiguration = builder.dockerConfiguration;
        if (builder.projectName != null) {
            this.initShim.projectName(builder.projectName);
        }
        this.projectName = this.initShim.projectName();
        this.dockerComposePath = this.initShim.dockerComposePath();
        this.initShim = null;
    }

    private ImmutableDockerComposeExecutable(DockerComposeFiles dockerComposeFiles, DockerConfiguration dockerConfiguration, ProjectName projectName) {
        this.dockerComposeFiles = dockerComposeFiles;
        this.dockerConfiguration = dockerConfiguration;
        this.initShim.projectName(projectName);
        this.projectName = this.initShim.projectName();
        this.dockerComposePath = this.initShim.dockerComposePath();
        this.initShim = null;
    }

    @Override
    protected DockerComposeFiles dockerComposeFiles() {
        return this.dockerComposeFiles;
    }

    @Override
    protected DockerConfiguration dockerConfiguration() {
        return this.dockerConfiguration;
    }

    @Override
    public ProjectName projectName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.projectName() : this.projectName;
    }

    @Override
    protected String dockerComposePath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dockerComposePath() : this.dockerComposePath;
    }

    public final ImmutableDockerComposeExecutable withDockerComposeFiles(DockerComposeFiles value) {
        if (this.dockerComposeFiles == value) {
            return this;
        }
        DockerComposeFiles newValue = Objects.requireNonNull(value, "dockerComposeFiles");
        return new ImmutableDockerComposeExecutable(newValue, this.dockerConfiguration, this.projectName);
    }

    public final ImmutableDockerComposeExecutable withDockerConfiguration(DockerConfiguration value) {
        if (this.dockerConfiguration == value) {
            return this;
        }
        DockerConfiguration newValue = Objects.requireNonNull(value, "dockerConfiguration");
        return new ImmutableDockerComposeExecutable(this.dockerComposeFiles, newValue, this.projectName);
    }

    public final ImmutableDockerComposeExecutable withProjectName(ProjectName value) {
        if (this.projectName == value) {
            return this;
        }
        ProjectName newValue = Objects.requireNonNull(value, "projectName");
        return new ImmutableDockerComposeExecutable(this.dockerComposeFiles, this.dockerConfiguration, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDockerComposeExecutable && this.equalTo((ImmutableDockerComposeExecutable)another);
    }

    private boolean equalTo(ImmutableDockerComposeExecutable another) {
        return this.dockerComposeFiles.equals(another.dockerComposeFiles) && this.dockerConfiguration.equals(another.dockerConfiguration) && this.projectName.equals(another.projectName) && this.dockerComposePath.equals(another.dockerComposePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.dockerComposeFiles.hashCode();
        h += (h << 5) + this.dockerConfiguration.hashCode();
        h += (h << 5) + this.projectName.hashCode();
        h += (h << 5) + this.dockerComposePath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DockerComposeExecutable").omitNullValues().add("dockerComposeFiles", (Object)this.dockerComposeFiles).add("dockerConfiguration", (Object)this.dockerConfiguration).add("projectName", (Object)this.projectName).add("dockerComposePath", (Object)this.dockerComposePath).toString();
    }

    public static ImmutableDockerComposeExecutable of(DockerComposeFiles dockerComposeFiles, DockerConfiguration dockerConfiguration) {
        return new ImmutableDockerComposeExecutable(dockerComposeFiles, dockerConfiguration);
    }

    public static ImmutableDockerComposeExecutable copyOf(DockerComposeExecutable instance) {
        if (instance instanceof ImmutableDockerComposeExecutable) {
            return (ImmutableDockerComposeExecutable)instance;
        }
        return ImmutableDockerComposeExecutable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DockerComposeExecutable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DOCKER_COMPOSE_FILES = 1L;
        private static final long INIT_BIT_DOCKER_CONFIGURATION = 2L;
        private long initBits = 3L;
        @Nullable
        private DockerComposeFiles dockerComposeFiles;
        @Nullable
        private DockerConfiguration dockerConfiguration;
        @Nullable
        private ProjectName projectName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DockerComposeExecutable instance) {
            Objects.requireNonNull(instance, "instance");
            this.dockerComposeFiles(instance.dockerComposeFiles());
            this.dockerConfiguration(instance.dockerConfiguration());
            this.projectName(instance.projectName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dockerComposeFiles(DockerComposeFiles dockerComposeFiles) {
            this.dockerComposeFiles = Objects.requireNonNull(dockerComposeFiles, "dockerComposeFiles");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dockerConfiguration(DockerConfiguration dockerConfiguration) {
            this.dockerConfiguration = Objects.requireNonNull(dockerConfiguration, "dockerConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectName(ProjectName projectName) {
            this.projectName = Objects.requireNonNull(projectName, "projectName");
            return this;
        }

        public ImmutableDockerComposeExecutable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDockerComposeExecutable(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dockerComposeFiles");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dockerConfiguration");
            }
            return "Cannot build DockerComposeExecutable, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="DockerComposeExecutable", generator="Immutables")
    private final class InitShim {
        private byte projectNameBuildStage = 0;
        private ProjectName projectName;
        private byte dockerComposePathBuildStage = 0;
        private String dockerComposePath;

        private InitShim() {
        }

        ProjectName projectName() {
            if (this.projectNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.projectNameBuildStage == 0) {
                this.projectNameBuildStage = (byte)-1;
                this.projectName = Objects.requireNonNull(ImmutableDockerComposeExecutable.super.projectName(), "projectName");
                this.projectNameBuildStage = 1;
            }
            return this.projectName;
        }

        void projectName(ProjectName projectName) {
            this.projectName = projectName;
            this.projectNameBuildStage = 1;
        }

        String dockerComposePath() {
            if (this.dockerComposePathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dockerComposePathBuildStage == 0) {
                this.dockerComposePathBuildStage = (byte)-1;
                this.dockerComposePath = Objects.requireNonNull(ImmutableDockerComposeExecutable.super.dockerComposePath(), "dockerComposePath");
                this.dockerComposePathBuildStage = 1;
            }
            return this.dockerComposePath;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.projectNameBuildStage == -1) {
                attributes.add("projectName");
            }
            if (this.dockerComposePathBuildStage == -1) {
                attributes.add("dockerComposePath");
            }
            return "Cannot build DockerComposeExecutable, attribute initializers form cycle " + attributes;
        }
    }
}

