/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.docker.compose.execution.DockerConfiguration;
import com.palantir.docker.compose.execution.DockerExecutable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DockerExecutable", generator="Immutables")
@Immutable
public final class ImmutableDockerExecutable
extends DockerExecutable {
    private final DockerConfiguration dockerConfiguration;
    private final transient String dockerPath;

    private ImmutableDockerExecutable(DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = Objects.requireNonNull(dockerConfiguration, "dockerConfiguration");
        this.dockerPath = Objects.requireNonNull(super.dockerPath(), "dockerPath");
    }

    private ImmutableDockerExecutable(ImmutableDockerExecutable original, DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = dockerConfiguration;
        this.dockerPath = Objects.requireNonNull(super.dockerPath(), "dockerPath");
    }

    @Override
    protected DockerConfiguration dockerConfiguration() {
        return this.dockerConfiguration;
    }

    @Override
    protected String dockerPath() {
        return this.dockerPath;
    }

    public final ImmutableDockerExecutable withDockerConfiguration(DockerConfiguration value) {
        if (this.dockerConfiguration == value) {
            return this;
        }
        DockerConfiguration newValue = Objects.requireNonNull(value, "dockerConfiguration");
        return new ImmutableDockerExecutable(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDockerExecutable && this.equalTo((ImmutableDockerExecutable)another);
    }

    private boolean equalTo(ImmutableDockerExecutable another) {
        return this.dockerConfiguration.equals(another.dockerConfiguration) && this.dockerPath.equals(another.dockerPath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.dockerConfiguration.hashCode();
        h += (h << 5) + this.dockerPath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DockerExecutable").omitNullValues().add("dockerConfiguration", (Object)this.dockerConfiguration).add("dockerPath", (Object)this.dockerPath).toString();
    }

    public static ImmutableDockerExecutable of(DockerConfiguration dockerConfiguration) {
        return new ImmutableDockerExecutable(dockerConfiguration);
    }

    public static ImmutableDockerExecutable copyOf(DockerExecutable instance) {
        if (instance instanceof ImmutableDockerExecutable) {
            return (ImmutableDockerExecutable)instance;
        }
        return ImmutableDockerExecutable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DockerExecutable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DOCKER_CONFIGURATION = 1L;
        private long initBits = 1L;
        @Nullable
        private DockerConfiguration dockerConfiguration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DockerExecutable instance) {
            Objects.requireNonNull(instance, "instance");
            this.dockerConfiguration(instance.dockerConfiguration());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dockerConfiguration(DockerConfiguration dockerConfiguration) {
            this.dockerConfiguration = Objects.requireNonNull(dockerConfiguration, "dockerConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDockerExecutable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDockerExecutable(null, this.dockerConfiguration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dockerConfiguration");
            }
            return "Cannot build DockerExecutable, some of required attributes are not set " + attributes;
        }
    }
}

