/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.execution;

import com.palantir.docker.compose.execution.DockerExecutionException;
import java.io.IOException;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Retryer {
    private static final Logger log = LoggerFactory.getLogger(Retryer.class);
    public static final ReadableDuration STANDARD_DELAY = Duration.standardSeconds((long)5L);
    private final int retryAttempts;
    private final ReadableDuration delay;

    public Retryer(int retryAttempts, ReadableDuration delay) {
        this.retryAttempts = retryAttempts;
        this.delay = delay;
    }

    public <T> T runWithRetries(RetryableDockerOperation<T> operation) throws IOException, InterruptedException {
        DockerExecutionException lastExecutionException = null;
        for (int i = 0; i <= this.retryAttempts; ++i) {
            try {
                return operation.call();
            }
            catch (DockerExecutionException e) {
                lastExecutionException = e;
                log.warn("Caught exception: {}", (Object)e.getMessage());
                log.warn("Retrying after {}", (Object)this.delay);
                if (i >= this.retryAttempts) continue;
                Thread.sleep(this.delay.getMillis());
                continue;
            }
        }
        log.error("Exhausted all retry attempts. Tried {} times.", (Object)this.retryAttempts);
        throw lastExecutionException;
    }

    public static interface RetryableDockerOperation<T> {
        public T call() throws IOException, InterruptedException;
    }
}

