/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.matchers;

import com.palantir.docker.compose.connection.DockerPort;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public final class AvailablePortMatcher
extends TypeSafeMatcher<Collection<DockerPort>> {
    public void describeTo(Description description) {
        description.appendText("No ports to be unavailable");
    }

    protected boolean matchesSafely(Collection<DockerPort> unavailablePorts) {
        return unavailablePorts.isEmpty();
    }

    protected void describeMismatchSafely(Collection<DockerPort> unavailablePorts, Description mismatchDescription) {
        mismatchDescription.appendValueList("These ports were unavailable:\n", "\n", ".", AvailablePortMatcher.buildClosedPortsErrorMessage(unavailablePorts));
    }

    private static Collection<String> buildClosedPortsErrorMessage(Collection<DockerPort> unavailablePorts) {
        return unavailablePorts.stream().map(port -> "For host with ip address: " + port.getIp() + " external port '" + port.getExternalPort() + "' mapped to internal port '" + port.getInternalPort() + "' was unavailable").collect(Collectors.toList());
    }

    public static AvailablePortMatcher areAvailable() {
        return new AvailablePortMatcher();
    }
}

