/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.google.common.collect.Streams;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

final class GitUtils {
    private static final Pattern SSH_REGEX = Pattern.compile(GitUtils.sshRegex());
    private static final Pattern JUST_A_PATH = Pattern.compile("[\\w/]+", 256);

    private GitUtils() {
    }

    public static Optional<String> parsePathFromGitRemoteUrl(String gitRemoteUrl) {
        if (gitRemoteUrl.startsWith("file://") || gitRemoteUrl.startsWith("/") || JUST_A_PATH.matcher(gitRemoteUrl).matches()) {
            return Optional.empty();
        }
        return Stream.of(GitUtils.parseHttp(gitRemoteUrl), GitUtils.parseSshOrGit(gitRemoteUrl)).flatMap(Streams::stream).map(path -> path.replaceAll("(\\.git)?/?$", "")).map(path -> path.replaceAll("^/", "")).findFirst();
    }

    private static Optional<String> parseSshOrGit(String gitRemoteUrl) {
        Matcher matcher = SSH_REGEX.matcher(gitRemoteUrl);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(1));
    }

    private static Optional<String> parseHttp(String gitRemoteUrl) {
        try {
            URL url = new URL(gitRemoteUrl);
            return Optional.of(url.getPath());
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
    }

    private static String sshRegex() {
        String sshOrGit = "(?:(?:ssh|git)://)?";
        String user = "(?:.+@)?";
        String hostname = ".*?";
        String separator = "[:/]";
        String port = "(?:\\d+/)?";
        String squigglyUser = "(?:~[^/]*/)?";
        String pathCapture = "(.*)";
        return sshOrGit + user + hostname + separator + port + squigglyUser + pathCapture;
    }
}

