/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.google.common.io.CharStreams;
import com.palantir.docker.compose.reporting.ReportingConfig;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpJsonPoster {
    private static final Logger log = LoggerFactory.getLogger(HttpJsonPoster.class);
    private final ReportingConfig reportingConfig;

    HttpJsonPoster(ReportingConfig reportingConfig) {
        this.reportingConfig = reportingConfig;
    }

    public void post(String json) {
        try {
            URL url = new URL(this.reportingConfig.url());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(10000);
            connection.setRequestMethod("POST");
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Content-Type", "application/json");
            String version = Optional.ofNullable(this.getClass().getPackage().getImplementationVersion()).orElse("0.0.0");
            connection.setRequestProperty("User-Agent", "docker-compose-rule/" + version);
            connection.setDoOutput(true);
            PrintWriter body = new PrintWriter(new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8)));
            body.println(json);
            body.close();
            connection.connect();
            int status = connection.getResponseCode();
            if (status >= 400) {
                String error = CharStreams.toString((Readable)new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                throw new RuntimeException("Posting json failed. Error is: " + error);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            log.error("Failed to post report", (Throwable)e);
        }
    }
}

