/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.reporting;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.docker.compose.reporting.PatternCollection;
import com.palantir.docker.compose.reporting.ReportingConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReportingConfig", generator="Immutables")
@Immutable
public final class ImmutableReportingConfig
implements ReportingConfig {
    private final String url;
    private final transient PatternCollection envVarWhitelistPatterns;

    private ImmutableReportingConfig(String url) {
        this.url = url;
        this.envVarWhitelistPatterns = Objects.requireNonNull(ReportingConfig.super.envVarWhitelistPatterns(), "envVarWhitelistPatterns");
    }

    @Override
    @JsonProperty(value="url")
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty(value="envVarWhitelistPatterns")
    public PatternCollection envVarWhitelistPatterns() {
        return this.envVarWhitelistPatterns;
    }

    public final ImmutableReportingConfig withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableReportingConfig(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportingConfig && this.equalTo((ImmutableReportingConfig)another);
    }

    private boolean equalTo(ImmutableReportingConfig another) {
        return this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReportingConfig").omitNullValues().add("url", (Object)this.url).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReportingConfig fromJson(Json json) {
        ReportingConfig.Builder builder = new ReportingConfig.Builder();
        if (json.url != null) {
            builder.url(json.url);
        }
        return (ImmutableReportingConfig)builder.build();
    }

    public static ReportingConfig copyOf(ReportingConfig instance) {
        if (instance instanceof ImmutableReportingConfig) {
            return (ImmutableReportingConfig)instance;
        }
        return new ReportingConfig.Builder().url(instance.url()).build();
    }

    @Generated(from="ReportingConfig", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_URL = 1L;
        private long initBits = 1L;
        @Nullable
        private String url;

        public Builder() {
            if (!(this instanceof ReportingConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new ReportingConfig.Builder()");
            }
        }

        @JsonProperty(value="url")
        @CanIgnoreReturnValue
        public final ReportingConfig.Builder url(String url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ReportingConfig.Builder)this;
        }

        public ReportingConfig build() {
            this.checkRequiredAttributes();
            return new ImmutableReportingConfig(this.url);
        }

        private boolean urlIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ReportingConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            return "Cannot build ReportingConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReportingConfig", generator="Immutables")
    static final class Json
    implements ReportingConfig {
        @Nullable
        String url;

        Json() {
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public PatternCollection envVarWhitelistPatterns() {
            throw new UnsupportedOperationException();
        }
    }
}

