package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@JsonDeserialize(builder = Versions.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class Versions {
    private final Optional<String> dockerComposeRule;

    private final Optional<String> docker;

    private final Optional<String> dockerCompose;

    private int memoizedHashCode;

    private Versions(Optional<String> dockerComposeRule, Optional<String> docker, Optional<String> dockerCompose) {
        validateFields(dockerComposeRule, docker, dockerCompose);
        this.dockerComposeRule = dockerComposeRule;
        this.docker = docker;
        this.dockerCompose = dockerCompose;
    }

    @JsonProperty("dockerComposeRule")
    public Optional<String> getDockerComposeRule() {
        return this.dockerComposeRule;
    }

    @JsonProperty("docker")
    public Optional<String> getDocker() {
        return this.docker;
    }

    @JsonProperty("dockerCompose")
    public Optional<String> getDockerCompose() {
        return this.dockerCompose;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof Versions && equalTo((Versions) other));
    }

    private boolean equalTo(Versions other) {
        return this.dockerComposeRule.equals(other.dockerComposeRule)
                && this.docker.equals(other.docker)
                && this.dockerCompose.equals(other.dockerCompose);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(this.dockerComposeRule, this.docker, this.dockerCompose);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "Versions{dockerComposeRule: " + dockerComposeRule + ", docker: " + docker + ", dockerCompose: "
                + dockerCompose + '}';
    }

    public static Versions of(String dockerComposeRule, String docker, String dockerCompose) {
        return builder()
                .dockerComposeRule(Optional.of(dockerComposeRule))
                .docker(Optional.of(docker))
                .dockerCompose(Optional.of(dockerCompose))
                .build();
    }

    private static void validateFields(
            Optional<String> dockerComposeRule, Optional<String> docker, Optional<String> dockerCompose) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, dockerComposeRule, "dockerComposeRule");
        missingFields = addFieldIfMissing(missingFields, docker, "docker");
        missingFields = addFieldIfMissing(missingFields, dockerCompose, "dockerCompose");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> dockerComposeRule = Optional.empty();

        private Optional<String> docker = Optional.empty();

        private Optional<String> dockerCompose = Optional.empty();

        private Builder() {}

        public Builder from(Versions other) {
            dockerComposeRule(other.getDockerComposeRule());
            docker(other.getDocker());
            dockerCompose(other.getDockerCompose());
            return this;
        }

        @JsonSetter(value = "dockerComposeRule", nulls = Nulls.SKIP)
        public Builder dockerComposeRule(@Nonnull Optional<String> dockerComposeRule) {
            this.dockerComposeRule = Preconditions.checkNotNull(dockerComposeRule, "dockerComposeRule cannot be null");
            return this;
        }

        public Builder dockerComposeRule(@Nonnull String dockerComposeRule) {
            this.dockerComposeRule =
                    Optional.of(Preconditions.checkNotNull(dockerComposeRule, "dockerComposeRule cannot be null"));
            return this;
        }

        @JsonSetter(value = "docker", nulls = Nulls.SKIP)
        public Builder docker(@Nonnull Optional<String> docker) {
            this.docker = Preconditions.checkNotNull(docker, "docker cannot be null");
            return this;
        }

        public Builder docker(@Nonnull String docker) {
            this.docker = Optional.of(Preconditions.checkNotNull(docker, "docker cannot be null"));
            return this;
        }

        @JsonSetter(value = "dockerCompose", nulls = Nulls.SKIP)
        public Builder dockerCompose(@Nonnull Optional<String> dockerCompose) {
            this.dockerCompose = Preconditions.checkNotNull(dockerCompose, "dockerCompose cannot be null");
            return this;
        }

        public Builder dockerCompose(@Nonnull String dockerCompose) {
            this.dockerCompose = Optional.of(Preconditions.checkNotNull(dockerCompose, "dockerCompose cannot be null"));
            return this;
        }

        public Versions build() {
            return new Versions(dockerComposeRule, docker, dockerCompose);
        }
    }
}
