/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007Jc\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u000fJ\f\u0010\u0018\u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010\u0019\u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010\u001a\u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010\u001b\u001a\u00020\u0015*\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u00020\u0015*\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\f\u0010\u001e\u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010\u001f\u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u0015*\u00020\rH\u0002J\f\u0010!\u001a\u00020\u0010*\u00020\u000bH\u0002J \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0#*\u00020\u000b2\u0006\u0010$\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/StringTemplateIndenter;", "", "codeStyle", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "indentConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "<init>", "(Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;)V", "visitClosingQuotes", "", "expectedIndent", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emitAndApprove", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "isRawStringLiteralFunctionBodyExpression", "isRawStringLiteralReturnInFunctionBodyBlock", "isFollowedByTrimIndent", "isFollowedByTrimMargin", "isFollowedBy", "callExpressionName", "isMultiLine", "containsMixedIndentationCharacters", "isIndentBeforeClosingQuote", "indentLength", "splitIndentAt", "Lkotlin/Pair;", "index", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nIndentationRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentationRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/StringTemplateIndenter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 AutocorrectDecision.kt\ncom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecisionKt\n+ 5 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,1598:1\n1#2:1599\n1#2:1603\n1321#3:1600\n1322#3:1604\n1255#3,2:1614\n19#4:1601\n18#4:1602\n325#5:1605\n297#5,8:1606\n827#6:1616\n855#6,2:1617\n827#6:1619\n855#6,2:1620\n827#6:1622\n855#6,2:1623\n158#7,6:1625\n158#7,6:1631\n*S KotlinDebug\n*F\n+ 1 IndentationRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/StringTemplateIndenter\n*L\n1505#1:1603\n1497#1:1600\n1497#1:1604\n1543#1:1614,2\n1505#1:1601\n1505#1:1602\n1525#1:1605\n1537#1:1606,8\n1551#1:1616\n1551#1:1617,2\n1552#1:1619\n1552#1:1620,2\n1553#1:1622\n1553#1:1623,2\n1568#1:1625,6\n1582#1:1631,6\n*E\n"})
final class StringTemplateIndenter {
    @NotNull
    private final CodeStyleValue codeStyle;
    @NotNull
    private final IndentConfig indentConfig;

    public StringTemplateIndenter(@NotNull CodeStyleValue codeStyle, @NotNull IndentConfig indentConfig) {
        Intrinsics.checkNotNullParameter((Object)codeStyle, (String)"codeStyle");
        Intrinsics.checkNotNullParameter((Object)indentConfig, (String)"indentConfig");
        this.codeStyle = codeStyle;
        this.indentConfig = indentConfig;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitClosingQuotes(@NotNull String expectedIndent, @NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emitAndApprove) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        Intrinsics.checkNotNullParameter((Object)expectedIndent, (String)"expectedIndent");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emitAndApprove, (String)"emitAndApprove");
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ASTNode it = aSTNode2 = node;
        boolean bl = false;
        Object object = aSTNode = this.isFollowedByTrimIndent(it) || this.isFollowedByTrimMargin(it) ? aSTNode2 : null;
        if (aSTNode != null) {
            ASTNode aSTNode3;
            ASTNode it2 = aSTNode3 = aSTNode;
            boolean bl2 = false;
            Object object2 = aSTNode2 = this.isMultiLine(it2) ? aSTNode3 : null;
            if (aSTNode2 != null) {
                void $this$forEach$iv;
                String string;
                boolean bl3 = false;
                if (this.containsMixedIndentationCharacters(node)) {
                    emitAndApprove.invoke((Object)node.getStartOffset(), (Object)"Indentation of multiline string should not contain both tab(s) and space(s)", (Object)false);
                    return;
                }
                ASTNode prevLeaf = ASTNodeExtensionKt.getPrevLeaf((ASTNode)node);
                if (this.codeStyle == CodeStyleValue.ktlint_official && this.isRawStringLiteralReturnInFunctionBodyBlock(node)) {
                    string = ASTNodeExtensionKt.getIndentWithoutNewlinePrefix((ASTNode)node) + this.indentConfig.getIndent();
                } else if (this.codeStyle == CodeStyleValue.ktlint_official && this.isRawStringLiteralFunctionBodyExpression(node)) {
                    string = ASTNodeExtensionKt.getIndentWithoutNewlinePrefix((ASTNode)node) + this.indentConfig.getIndent();
                } else {
                    ASTNode aSTNode4 = prevLeaf;
                    string = Intrinsics.areEqual((Object)(aSTNode4 != null ? aSTNode4.getText() : null), (Object)"\n") ? "" : expectedIndent;
                }
                String correctedExpectedIndent = string;
                Sequence sequence = SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)node), arg_0 -> StringTemplateIndenter.visitClosingQuotes$lambda$2$0(this, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$ifAutocorrectAllowed$iv;
                    ASTNode it3 = (ASTNode)element$iv;
                    boolean bl4 = false;
                    ASTNode aSTNode5 = ASTNodeExtensionKt.getPrevLeaf((ASTNode)it3);
                    if (!Intrinsics.areEqual((Object)(aSTNode5 != null ? aSTNode5.getText() : null), (Object)"\n")) continue;
                    String string2 = it3.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    Pair<String, String> pair = this.splitIndentAt(string2, it3.getText().length());
                    String actualIndent = (String)pair.component1();
                    String actualContent = (String)pair.component2();
                    if (Intrinsics.areEqual((Object)actualIndent, (Object)correctedExpectedIndent)) continue;
                    AutocorrectDecision autocorrectDecision = (AutocorrectDecision)emitAndApprove.invoke((Object)it3.getStartOffset(), (Object)"Unexpected indent of multiline string closing quotes", (Object)true);
                    boolean $i$f$ifAutocorrectAllowed = false;
                    void var22_24 = $this$ifAutocorrectAllowed$iv;
                    Object it$iv = var22_24;
                    boolean bl5 = false;
                    Object object3 = $this$ifAutocorrectAllowed$iv == AutocorrectDecision.ALLOW_AUTOCORRECT ? var22_24 : null;
                    if (object3 == null) continue;
                    it$iv = object3;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    if (it3.getFirstChildNode() == null) {
                        Intrinsics.checkNotNull((Object)it3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        ((LeafPsiElement)it3).rawInsertBeforeMe((TreeElement)new LeafPsiElement(ElementType.INSTANCE.getREGULAR_STRING_PART(), (CharSequence)correctedExpectedIndent));
                        continue;
                    }
                    ASTNode aSTNode6 = it3.getFirstChildNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"getFirstChildNode(...)");
                    ASTNodeExtensionKt.replaceTextWith((ASTNode)aSTNode6, (String)(correctedExpectedIndent + actualContent));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean isRawStringLiteralFunctionBodyExpression(ASTNode $this$isRawStringLiteralFunctionBodyExpression) {
        block4: {
            if (!ASTNodeExtensionKt.isWhiteSpace20((ASTNode)ASTNodeExtensionKt.getPrevLeaf((ASTNode)$this$isRawStringLiteralFunctionBodyExpression))) break block4;
            v0 = ASTNodeExtensionKt.getPrevLeaf((ASTNode)$this$isRawStringLiteralFunctionBodyExpression);
            if (!Intrinsics.areEqual((Object)(v0 != null ? v0.getText() : null), (Object)" ")) ** GOTO lbl-1000
        }
        var4_3 = var3_2 = ASTNodeExtensionKt.getPrevCodeLeaf((ASTNode)$this$isRawStringLiteralFunctionBodyExpression);
        var6_4 = ElementType.INSTANCE.getFUN();
        $i$a$-takeIf-StringTemplateIndenter$isRawStringLiteralFunctionBodyExpression$1 = false;
        v1 = it;
        var7_6 = Intrinsics.areEqual((Object)(v1 != null ? v1.getElementType() : null), (Object)ElementType.INSTANCE.getEQ());
        v2 /* !! */  = var2_7 = var7_6 != false ? var3_2 : null;
        if (var2_7 == null) ** GOTO lbl-1000
        it = var2_7;
        $i$f$getParent = false;
        var3_2 = $this$parent$iv.getTreeParent();
        if (var3_2 != null) {
            v3 = var3_2.getElementType();
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        if (Intrinsics.areEqual((Object)var6_4, v3)) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        return v4;
    }

    private final boolean isRawStringLiteralReturnInFunctionBodyBlock(ASTNode $this$isRawStringLiteralReturnInFunctionBodyBlock) {
        ASTNode aSTNode = ASTNodeExtensionKt.getPrevCodeLeaf((ASTNode)$this$isRawStringLiteralReturnInFunctionBodyBlock);
        return Intrinsics.areEqual((Object)ElementType.INSTANCE.getRETURN_KEYWORD(), (Object)(aSTNode != null ? aSTNode.getElementType() : null));
    }

    private final boolean isFollowedByTrimIndent(ASTNode $this$isFollowedByTrimIndent) {
        return this.isFollowedBy($this$isFollowedByTrimIndent, "trimIndent()");
    }

    private final boolean isFollowedByTrimMargin(ASTNode $this$isFollowedByTrimMargin) {
        return this.isFollowedBy($this$isFollowedByTrimMargin, "trimMargin()");
    }

    private final boolean isFollowedBy(ASTNode $this$isFollowedBy, String callExpressionName) {
        ASTNode aSTNode;
        block2: {
            ASTNode aSTNode2;
            ASTNode it = aSTNode2 = $this$isFollowedBy;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            ASTNode $this$nextSibling$iv = aSTNode2;
            boolean $i$f$nextSibling = false;
            for (ASTNode node$iv = $this$nextSibling$iv.getTreeNext(); node$iv != null; node$iv = node$iv.getTreeNext()) {
                ASTNode it2 = node$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getDOT()))) continue;
                aSTNode = node$iv;
                break block2;
            }
            aSTNode = null;
        }
        ASTNode it = aSTNode;
        boolean bl = false;
        ASTNode aSTNode3 = it;
        return Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)ElementType.INSTANCE.getCALL_EXPRESSION()) && Intrinsics.areEqual((Object)it.getText(), (Object)callExpressionName);
    }

    private final boolean isMultiLine(ASTNode $this$isMultiLine) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)$this$isMultiLine), StringTemplateIndenter::isMultiLine$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)"\n")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean containsMixedIndentationCharacters(ASTNode $this$containsMixedIndentationCharacters) {
        Comparable comparable;
        String it;
        Iterable $this$filterNotTo$iv$iv;
        boolean bl = this.isMultiLine($this$containsMixedIndentationCharacters);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = $this$containsMixedIndentationCharacters.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.startsWith$default((String)it, (String)"\"\"\"", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.endsWith$default((String)it, (String)"\"\"\"", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonBlankLines = (List)destination$iv$iv;
        Iterator iterator = ((Iterable)nonBlankLines).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            String it2 = (String)iterator.next();
            boolean bl5 = false;
            Comparable comparable2 = Integer.valueOf(this.indentLength(it2));
            while (iterator.hasNext()) {
                String it3 = (String)iterator.next();
                $i$a$-minOfOrNull-StringTemplateIndenter$containsMixedIndentationCharacters$prefixLength$1 = false;
                Comparable comparable3 = Integer.valueOf(this.indentLength(it3));
                if (comparable2.compareTo(comparable3) <= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int prefixLength = n != null ? n : 0;
        char[] cArray = CollectionsKt.joinToString$default((Iterable)nonBlankLines, (CharSequence)"", null, null, (int)0, null, arg_0 -> StringTemplateIndenter.containsMixedIndentationCharacters$lambda$4(this, prefixLength, arg_0), (int)30, null).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        int distinctIndentCharacters = ((Collection)ArraysKt.distinct((char[])cArray)).size();
        return distinctIndentCharacters > 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIndentBeforeClosingQuote(ASTNode $this$isIndentBeforeClosingQuote) {
        if (Intrinsics.areEqual((Object)$this$isIndentBeforeClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return true;
        String string = $this$isIndentBeforeClosingQuote.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.isBlank((CharSequence)string)) return false;
        ASTNode aSTNode = ASTNodeExtensionKt.getNextCodeSibling20((ASTNode)$this$isIndentBeforeClosingQuote);
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int indentLength(String $this$indentLength) {
        void var3_3;
        int n;
        block1: {
            CharSequence $this$indexOfFirst$iv = $this$indentLength;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        return it == -1 ? $this$indentLength.length() : var3_3;
    }

    private final Pair<String, String> splitIndentAt(String $this$splitIndentAt, int index) {
        int n;
        block3: {
            boolean bl;
            boolean bl2 = bl = index >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (Intrinsics.areEqual((Object)$this$splitIndentAt, (Object)"\n")) {
                return new Pair((Object)"", (Object)"");
            }
            CharSequence $this$indexOfFirst$iv = $this$splitIndentAt;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl3 = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block3;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        int firstNonWhitespaceIndex = it == -1 ? $this$splitIndentAt.length() : it;
        int safeIndex = Math.min(firstNonWhitespaceIndex, index);
        String string = StringsKt.take((String)$this$splitIndentAt, (int)safeIndex);
        String string2 = $this$splitIndentAt.substring(safeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return new Pair((Object)string, (Object)string2);
    }

    private static final boolean visitClosingQuotes$lambda$2$0(StringTemplateIndenter this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isIndentBeforeClosingQuote(it);
    }

    private static final boolean isMultiLine$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY());
    }

    private static final CharSequence containsMixedIndentationCharacters$lambda$4(StringTemplateIndenter this$0, int $prefixLength, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)this$0.splitIndentAt(it, $prefixLength).getFirst();
    }
}

